<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TranslationList StructType
 * @subpackage Structs
 */
class TranslationList extends AbstractStructBase
{
    /**
     * The translation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Translation[]
     */
    public $translation;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for TranslationList
     * @uses TranslationList::setTranslation()
     * @uses TranslationList::setReplaceAll()
     * @param \StructType\Translation[] $translation
     * @param bool $replaceAll
     */
    public function __construct(array $translation = array(), $replaceAll = true)
    {
        $this
            ->setTranslation($translation)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get translation value
     * @return \StructType\Translation[]|null
     */
    public function getTranslation()
    {
        return $this->translation;
    }
    /**
     * This method is responsible for validating the values passed to the setTranslation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTranslation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTranslationForArrayConstraintsFromSetTranslation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $translationListTranslationItem) {
            // validation for constraint: itemType
            if (!$translationListTranslationItem instanceof \StructType\Translation) {
                $invalidValues[] = is_object($translationListTranslationItem) ? get_class($translationListTranslationItem) : sprintf('%s(%s)', gettype($translationListTranslationItem), var_export($translationListTranslationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The translation property can only contain items of type \StructType\Translation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set translation value
     * @throws \InvalidArgumentException
     * @param \StructType\Translation[] $translation
     * @return \StructType\TranslationList
     */
    public function setTranslation(array $translation = array())
    {
        // validation for constraint: array
        if ('' !== ($translationArrayErrorMessage = self::validateTranslationForArrayConstraintsFromSetTranslation($translation))) {
            throw new \InvalidArgumentException($translationArrayErrorMessage, __LINE__);
        }
        $this->translation = $translation;
        return $this;
    }
    /**
     * Add item to translation value
     * @throws \InvalidArgumentException
     * @param \StructType\Translation $item
     * @return \StructType\TranslationList
     */
    public function addToTranslation(\StructType\Translation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Translation) {
            throw new \InvalidArgumentException(sprintf('The translation property can only contain items of type \StructType\Translation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->translation[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\TranslationList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
