<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TimeSheetTimeGridList StructType
 * @subpackage Structs
 */
class TimeSheetTimeGridList extends AbstractStructBase
{
    /**
     * The timeSheetTimeGrid
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TimeSheetTimeGrid[]
     */
    public $timeSheetTimeGrid;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for TimeSheetTimeGridList
     * @uses TimeSheetTimeGridList::setTimeSheetTimeGrid()
     * @uses TimeSheetTimeGridList::setReplaceAll()
     * @param \StructType\TimeSheetTimeGrid[] $timeSheetTimeGrid
     * @param bool $replaceAll
     */
    public function __construct(array $timeSheetTimeGrid = array(), $replaceAll = true)
    {
        $this
            ->setTimeSheetTimeGrid($timeSheetTimeGrid)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get timeSheetTimeGrid value
     * @return \StructType\TimeSheetTimeGrid[]|null
     */
    public function getTimeSheetTimeGrid()
    {
        return $this->timeSheetTimeGrid;
    }
    /**
     * This method is responsible for validating the values passed to the setTimeSheetTimeGrid method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTimeSheetTimeGrid method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTimeSheetTimeGridForArrayConstraintsFromSetTimeSheetTimeGrid(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $timeSheetTimeGridListTimeSheetTimeGridItem) {
            // validation for constraint: itemType
            if (!$timeSheetTimeGridListTimeSheetTimeGridItem instanceof \StructType\TimeSheetTimeGrid) {
                $invalidValues[] = is_object($timeSheetTimeGridListTimeSheetTimeGridItem) ? get_class($timeSheetTimeGridListTimeSheetTimeGridItem) : sprintf('%s(%s)', gettype($timeSheetTimeGridListTimeSheetTimeGridItem), var_export($timeSheetTimeGridListTimeSheetTimeGridItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The timeSheetTimeGrid property can only contain items of type \StructType\TimeSheetTimeGrid, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set timeSheetTimeGrid value
     * @throws \InvalidArgumentException
     * @param \StructType\TimeSheetTimeGrid[] $timeSheetTimeGrid
     * @return \StructType\TimeSheetTimeGridList
     */
    public function setTimeSheetTimeGrid(array $timeSheetTimeGrid = array())
    {
        // validation for constraint: array
        if ('' !== ($timeSheetTimeGridArrayErrorMessage = self::validateTimeSheetTimeGridForArrayConstraintsFromSetTimeSheetTimeGrid($timeSheetTimeGrid))) {
            throw new \InvalidArgumentException($timeSheetTimeGridArrayErrorMessage, __LINE__);
        }
        $this->timeSheetTimeGrid = $timeSheetTimeGrid;
        return $this;
    }
    /**
     * Add item to timeSheetTimeGrid value
     * @throws \InvalidArgumentException
     * @param \StructType\TimeSheetTimeGrid $item
     * @return \StructType\TimeSheetTimeGridList
     */
    public function addToTimeSheetTimeGrid(\StructType\TimeSheetTimeGrid $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TimeSheetTimeGrid) {
            throw new \InvalidArgumentException(sprintf('The timeSheetTimeGrid property can only contain items of type \StructType\TimeSheetTimeGrid, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->timeSheetTimeGrid[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\TimeSheetTimeGridList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
