<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TimeSheetSearch StructType
 * @subpackage Structs
 */
class TimeSheetSearch extends SearchRecord
{
    /**
     * The basic
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TimeSheetSearchBasic
     */
    public $basic;
    /**
     * The employeeJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EmployeeSearchBasic
     */
    public $employeeJoin;
    /**
     * The timeBillJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TimeBillSearchBasic
     */
    public $timeBillJoin;
    /**
     * The timeEntryJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TimeEntrySearchBasic
     */
    public $timeEntryJoin;
    /**
     * The customSearchJoin
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomSearchJoin[]
     */
    public $customSearchJoin;
    /**
     * Constructor method for TimeSheetSearch
     * @uses TimeSheetSearch::setBasic()
     * @uses TimeSheetSearch::setEmployeeJoin()
     * @uses TimeSheetSearch::setTimeBillJoin()
     * @uses TimeSheetSearch::setTimeEntryJoin()
     * @uses TimeSheetSearch::setCustomSearchJoin()
     * @param \StructType\TimeSheetSearchBasic $basic
     * @param \StructType\EmployeeSearchBasic $employeeJoin
     * @param \StructType\TimeBillSearchBasic $timeBillJoin
     * @param \StructType\TimeEntrySearchBasic $timeEntryJoin
     * @param \StructType\CustomSearchJoin[] $customSearchJoin
     */
    public function __construct(\StructType\TimeSheetSearchBasic $basic = null, \StructType\EmployeeSearchBasic $employeeJoin = null, \StructType\TimeBillSearchBasic $timeBillJoin = null, \StructType\TimeEntrySearchBasic $timeEntryJoin = null, array $customSearchJoin = array())
    {
        $this
            ->setBasic($basic)
            ->setEmployeeJoin($employeeJoin)
            ->setTimeBillJoin($timeBillJoin)
            ->setTimeEntryJoin($timeEntryJoin)
            ->setCustomSearchJoin($customSearchJoin);
    }
    /**
     * Get basic value
     * @return \StructType\TimeSheetSearchBasic|null
     */
    public function getBasic()
    {
        return $this->basic;
    }
    /**
     * Set basic value
     * @param \StructType\TimeSheetSearchBasic $basic
     * @return \StructType\TimeSheetSearch
     */
    public function setBasic(\StructType\TimeSheetSearchBasic $basic = null)
    {
        $this->basic = $basic;
        return $this;
    }
    /**
     * Get employeeJoin value
     * @return \StructType\EmployeeSearchBasic|null
     */
    public function getEmployeeJoin()
    {
        return $this->employeeJoin;
    }
    /**
     * Set employeeJoin value
     * @param \StructType\EmployeeSearchBasic $employeeJoin
     * @return \StructType\TimeSheetSearch
     */
    public function setEmployeeJoin(\StructType\EmployeeSearchBasic $employeeJoin = null)
    {
        $this->employeeJoin = $employeeJoin;
        return $this;
    }
    /**
     * Get timeBillJoin value
     * @return \StructType\TimeBillSearchBasic|null
     */
    public function getTimeBillJoin()
    {
        return $this->timeBillJoin;
    }
    /**
     * Set timeBillJoin value
     * @param \StructType\TimeBillSearchBasic $timeBillJoin
     * @return \StructType\TimeSheetSearch
     */
    public function setTimeBillJoin(\StructType\TimeBillSearchBasic $timeBillJoin = null)
    {
        $this->timeBillJoin = $timeBillJoin;
        return $this;
    }
    /**
     * Get timeEntryJoin value
     * @return \StructType\TimeEntrySearchBasic|null
     */
    public function getTimeEntryJoin()
    {
        return $this->timeEntryJoin;
    }
    /**
     * Set timeEntryJoin value
     * @param \StructType\TimeEntrySearchBasic $timeEntryJoin
     * @return \StructType\TimeSheetSearch
     */
    public function setTimeEntryJoin(\StructType\TimeEntrySearchBasic $timeEntryJoin = null)
    {
        $this->timeEntryJoin = $timeEntryJoin;
        return $this;
    }
    /**
     * Get customSearchJoin value
     * @return \StructType\CustomSearchJoin[]|null
     */
    public function getCustomSearchJoin()
    {
        return $this->customSearchJoin;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomSearchJoin method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomSearchJoin method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomSearchJoinForArrayConstraintsFromSetCustomSearchJoin(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $timeSheetSearchCustomSearchJoinItem) {
            // validation for constraint: itemType
            if (!$timeSheetSearchCustomSearchJoinItem instanceof \StructType\CustomSearchJoin) {
                $invalidValues[] = is_object($timeSheetSearchCustomSearchJoinItem) ? get_class($timeSheetSearchCustomSearchJoinItem) : sprintf('%s(%s)', gettype($timeSheetSearchCustomSearchJoinItem), var_export($timeSheetSearchCustomSearchJoinItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The customSearchJoin property can only contain items of type \StructType\CustomSearchJoin, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set customSearchJoin value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomSearchJoin[] $customSearchJoin
     * @return \StructType\TimeSheetSearch
     */
    public function setCustomSearchJoin(array $customSearchJoin = array())
    {
        // validation for constraint: array
        if ('' !== ($customSearchJoinArrayErrorMessage = self::validateCustomSearchJoinForArrayConstraintsFromSetCustomSearchJoin($customSearchJoin))) {
            throw new \InvalidArgumentException($customSearchJoinArrayErrorMessage, __LINE__);
        }
        $this->customSearchJoin = $customSearchJoin;
        return $this;
    }
    /**
     * Add item to customSearchJoin value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomSearchJoin $item
     * @return \StructType\TimeSheetSearch
     */
    public function addToCustomSearchJoin(\StructType\CustomSearchJoin $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomSearchJoin) {
            throw new \InvalidArgumentException(sprintf('The customSearchJoin property can only contain items of type \StructType\CustomSearchJoin, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->customSearchJoin[] = $item;
        return $this;
    }
}
