<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxGroupTaxItem StructType
 * @subpackage Structs
 */
class TaxGroupTaxItem extends AbstractStructBase
{
    /**
     * The taxName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $taxName;
    /**
     * The rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $rate;
    /**
     * The basis
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $basis;
    /**
     * The taxType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $taxType;
    /**
     * Constructor method for TaxGroupTaxItem
     * @uses TaxGroupTaxItem::setTaxName()
     * @uses TaxGroupTaxItem::setRate()
     * @uses TaxGroupTaxItem::setBasis()
     * @uses TaxGroupTaxItem::setTaxType()
     * @param \StructType\RecordRef $taxName
     * @param float $rate
     * @param float $basis
     * @param string $taxType
     */
    public function __construct(\StructType\RecordRef $taxName = null, $rate = null, $basis = null, $taxType = null)
    {
        $this
            ->setTaxName($taxName)
            ->setRate($rate)
            ->setBasis($basis)
            ->setTaxType($taxType);
    }
    /**
     * Get taxName value
     * @return \StructType\RecordRef|null
     */
    public function getTaxName()
    {
        return $this->taxName;
    }
    /**
     * Set taxName value
     * @param \StructType\RecordRef $taxName
     * @return \StructType\TaxGroupTaxItem
     */
    public function setTaxName(\StructType\RecordRef $taxName = null)
    {
        $this->taxName = $taxName;
        return $this;
    }
    /**
     * Get rate value
     * @return float|null
     */
    public function getRate()
    {
        return $this->rate;
    }
    /**
     * Set rate value
     * @param float $rate
     * @return \StructType\TaxGroupTaxItem
     */
    public function setRate($rate = null)
    {
        // validation for constraint: float
        if (!is_null($rate) && !(is_float($rate) || is_numeric($rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rate, true), gettype($rate)), __LINE__);
        }
        $this->rate = $rate;
        return $this;
    }
    /**
     * Get basis value
     * @return float|null
     */
    public function getBasis()
    {
        return $this->basis;
    }
    /**
     * Set basis value
     * @param float $basis
     * @return \StructType\TaxGroupTaxItem
     */
    public function setBasis($basis = null)
    {
        // validation for constraint: float
        if (!is_null($basis) && !(is_float($basis) || is_numeric($basis))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($basis, true), gettype($basis)), __LINE__);
        }
        $this->basis = $basis;
        return $this;
    }
    /**
     * Get taxType value
     * @return string|null
     */
    public function getTaxType()
    {
        return $this->taxType;
    }
    /**
     * Set taxType value
     * @param string $taxType
     * @return \StructType\TaxGroupTaxItem
     */
    public function setTaxType($taxType = null)
    {
        // validation for constraint: string
        if (!is_null($taxType) && !is_string($taxType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxType, true), gettype($taxType)), __LINE__);
        }
        $this->taxType = $taxType;
        return $this;
    }
}
