<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxGroup StructType
 * Meta information extracted from the WSDL
 * - type: listAcct:TaxGroup
 * @subpackage Structs
 */
class TaxGroup extends Record
{
    /**
     * The itemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $itemId;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The state
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $state;
    /**
     * The subsidiaryList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRefList
     */
    public $subsidiaryList;
    /**
     * The taxitem1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $taxitem1;
    /**
     * The unitprice1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $unitprice1;
    /**
     * The taxitem2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $taxitem2;
    /**
     * The unitprice2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $unitprice2;
    /**
     * The piggyback
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $piggyback;
    /**
     * The isInactive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isInactive;
    /**
     * The rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $rate;
    /**
     * The taxType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $taxType;
    /**
     * The includeChildren
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $includeChildren;
    /**
     * The county
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $county;
    /**
     * The city
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $city;
    /**
     * The zip
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $zip;
    /**
     * The nexusCountry
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $nexusCountry;
    /**
     * The isDefault
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isDefault;
    /**
     * The taxItemList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TaxGroupTaxItemList
     */
    public $taxItemList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for TaxGroup
     * @uses TaxGroup::setItemId()
     * @uses TaxGroup::setDescription()
     * @uses TaxGroup::setState()
     * @uses TaxGroup::setSubsidiaryList()
     * @uses TaxGroup::setTaxitem1()
     * @uses TaxGroup::setUnitprice1()
     * @uses TaxGroup::setTaxitem2()
     * @uses TaxGroup::setUnitprice2()
     * @uses TaxGroup::setPiggyback()
     * @uses TaxGroup::setIsInactive()
     * @uses TaxGroup::setRate()
     * @uses TaxGroup::setTaxType()
     * @uses TaxGroup::setIncludeChildren()
     * @uses TaxGroup::setCounty()
     * @uses TaxGroup::setCity()
     * @uses TaxGroup::setZip()
     * @uses TaxGroup::setNexusCountry()
     * @uses TaxGroup::setIsDefault()
     * @uses TaxGroup::setTaxItemList()
     * @uses TaxGroup::setInternalId()
     * @uses TaxGroup::setExternalId()
     * @param string $itemId
     * @param string $description
     * @param string $state
     * @param \StructType\RecordRefList $subsidiaryList
     * @param \StructType\RecordRef $taxitem1
     * @param string $unitprice1
     * @param \StructType\RecordRef $taxitem2
     * @param string $unitprice2
     * @param bool $piggyback
     * @param bool $isInactive
     * @param float $rate
     * @param \StructType\RecordRef $taxType
     * @param bool $includeChildren
     * @param string $county
     * @param string $city
     * @param string $zip
     * @param \StructType\RecordRef $nexusCountry
     * @param bool $isDefault
     * @param \StructType\TaxGroupTaxItemList $taxItemList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct($itemId = null, $description = null, $state = null, \StructType\RecordRefList $subsidiaryList = null, \StructType\RecordRef $taxitem1 = null, $unitprice1 = null, \StructType\RecordRef $taxitem2 = null, $unitprice2 = null, $piggyback = null, $isInactive = null, $rate = null, \StructType\RecordRef $taxType = null, $includeChildren = null, $county = null, $city = null, $zip = null, \StructType\RecordRef $nexusCountry = null, $isDefault = null, \StructType\TaxGroupTaxItemList $taxItemList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setItemId($itemId)
            ->setDescription($description)
            ->setState($state)
            ->setSubsidiaryList($subsidiaryList)
            ->setTaxitem1($taxitem1)
            ->setUnitprice1($unitprice1)
            ->setTaxitem2($taxitem2)
            ->setUnitprice2($unitprice2)
            ->setPiggyback($piggyback)
            ->setIsInactive($isInactive)
            ->setRate($rate)
            ->setTaxType($taxType)
            ->setIncludeChildren($includeChildren)
            ->setCounty($county)
            ->setCity($city)
            ->setZip($zip)
            ->setNexusCountry($nexusCountry)
            ->setIsDefault($isDefault)
            ->setTaxItemList($taxItemList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get itemId value
     * @return string|null
     */
    public function getItemId()
    {
        return $this->itemId;
    }
    /**
     * Set itemId value
     * @param string $itemId
     * @return \StructType\TaxGroup
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: string
        if (!is_null($itemId) && !is_string($itemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        $this->itemId = $itemId;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\TaxGroup
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get state value
     * @return string|null
     */
    public function getState()
    {
        return $this->state;
    }
    /**
     * Set state value
     * @param string $state
     * @return \StructType\TaxGroup
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($state, true), gettype($state)), __LINE__);
        }
        $this->state = $state;
        return $this;
    }
    /**
     * Get subsidiaryList value
     * @return \StructType\RecordRefList|null
     */
    public function getSubsidiaryList()
    {
        return $this->subsidiaryList;
    }
    /**
     * Set subsidiaryList value
     * @param \StructType\RecordRefList $subsidiaryList
     * @return \StructType\TaxGroup
     */
    public function setSubsidiaryList(\StructType\RecordRefList $subsidiaryList = null)
    {
        $this->subsidiaryList = $subsidiaryList;
        return $this;
    }
    /**
     * Get taxitem1 value
     * @return \StructType\RecordRef|null
     */
    public function getTaxitem1()
    {
        return $this->taxitem1;
    }
    /**
     * Set taxitem1 value
     * @param \StructType\RecordRef $taxitem1
     * @return \StructType\TaxGroup
     */
    public function setTaxitem1(\StructType\RecordRef $taxitem1 = null)
    {
        $this->taxitem1 = $taxitem1;
        return $this;
    }
    /**
     * Get unitprice1 value
     * @return string|null
     */
    public function getUnitprice1()
    {
        return $this->unitprice1;
    }
    /**
     * Set unitprice1 value
     * @param string $unitprice1
     * @return \StructType\TaxGroup
     */
    public function setUnitprice1($unitprice1 = null)
    {
        // validation for constraint: string
        if (!is_null($unitprice1) && !is_string($unitprice1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitprice1, true), gettype($unitprice1)), __LINE__);
        }
        $this->unitprice1 = $unitprice1;
        return $this;
    }
    /**
     * Get taxitem2 value
     * @return \StructType\RecordRef|null
     */
    public function getTaxitem2()
    {
        return $this->taxitem2;
    }
    /**
     * Set taxitem2 value
     * @param \StructType\RecordRef $taxitem2
     * @return \StructType\TaxGroup
     */
    public function setTaxitem2(\StructType\RecordRef $taxitem2 = null)
    {
        $this->taxitem2 = $taxitem2;
        return $this;
    }
    /**
     * Get unitprice2 value
     * @return string|null
     */
    public function getUnitprice2()
    {
        return $this->unitprice2;
    }
    /**
     * Set unitprice2 value
     * @param string $unitprice2
     * @return \StructType\TaxGroup
     */
    public function setUnitprice2($unitprice2 = null)
    {
        // validation for constraint: string
        if (!is_null($unitprice2) && !is_string($unitprice2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitprice2, true), gettype($unitprice2)), __LINE__);
        }
        $this->unitprice2 = $unitprice2;
        return $this;
    }
    /**
     * Get piggyback value
     * @return bool|null
     */
    public function getPiggyback()
    {
        return $this->piggyback;
    }
    /**
     * Set piggyback value
     * @param bool $piggyback
     * @return \StructType\TaxGroup
     */
    public function setPiggyback($piggyback = null)
    {
        // validation for constraint: boolean
        if (!is_null($piggyback) && !is_bool($piggyback)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($piggyback, true), gettype($piggyback)), __LINE__);
        }
        $this->piggyback = $piggyback;
        return $this;
    }
    /**
     * Get isInactive value
     * @return bool|null
     */
    public function getIsInactive()
    {
        return $this->isInactive;
    }
    /**
     * Set isInactive value
     * @param bool $isInactive
     * @return \StructType\TaxGroup
     */
    public function setIsInactive($isInactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInactive) && !is_bool($isInactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInactive, true), gettype($isInactive)), __LINE__);
        }
        $this->isInactive = $isInactive;
        return $this;
    }
    /**
     * Get rate value
     * @return float|null
     */
    public function getRate()
    {
        return $this->rate;
    }
    /**
     * Set rate value
     * @param float $rate
     * @return \StructType\TaxGroup
     */
    public function setRate($rate = null)
    {
        // validation for constraint: float
        if (!is_null($rate) && !(is_float($rate) || is_numeric($rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rate, true), gettype($rate)), __LINE__);
        }
        $this->rate = $rate;
        return $this;
    }
    /**
     * Get taxType value
     * @return \StructType\RecordRef|null
     */
    public function getTaxType()
    {
        return $this->taxType;
    }
    /**
     * Set taxType value
     * @param \StructType\RecordRef $taxType
     * @return \StructType\TaxGroup
     */
    public function setTaxType(\StructType\RecordRef $taxType = null)
    {
        $this->taxType = $taxType;
        return $this;
    }
    /**
     * Get includeChildren value
     * @return bool|null
     */
    public function getIncludeChildren()
    {
        return $this->includeChildren;
    }
    /**
     * Set includeChildren value
     * @param bool $includeChildren
     * @return \StructType\TaxGroup
     */
    public function setIncludeChildren($includeChildren = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeChildren) && !is_bool($includeChildren)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeChildren, true), gettype($includeChildren)), __LINE__);
        }
        $this->includeChildren = $includeChildren;
        return $this;
    }
    /**
     * Get county value
     * @return string|null
     */
    public function getCounty()
    {
        return $this->county;
    }
    /**
     * Set county value
     * @param string $county
     * @return \StructType\TaxGroup
     */
    public function setCounty($county = null)
    {
        // validation for constraint: string
        if (!is_null($county) && !is_string($county)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($county, true), gettype($county)), __LINE__);
        }
        $this->county = $county;
        return $this;
    }
    /**
     * Get city value
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \StructType\TaxGroup
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get zip value
     * @return string|null
     */
    public function getZip()
    {
        return $this->zip;
    }
    /**
     * Set zip value
     * @param string $zip
     * @return \StructType\TaxGroup
     */
    public function setZip($zip = null)
    {
        // validation for constraint: string
        if (!is_null($zip) && !is_string($zip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zip, true), gettype($zip)), __LINE__);
        }
        $this->zip = $zip;
        return $this;
    }
    /**
     * Get nexusCountry value
     * @return \StructType\RecordRef|null
     */
    public function getNexusCountry()
    {
        return $this->nexusCountry;
    }
    /**
     * Set nexusCountry value
     * @param \StructType\RecordRef $nexusCountry
     * @return \StructType\TaxGroup
     */
    public function setNexusCountry(\StructType\RecordRef $nexusCountry = null)
    {
        $this->nexusCountry = $nexusCountry;
        return $this;
    }
    /**
     * Get isDefault value
     * @return bool|null
     */
    public function getIsDefault()
    {
        return $this->isDefault;
    }
    /**
     * Set isDefault value
     * @param bool $isDefault
     * @return \StructType\TaxGroup
     */
    public function setIsDefault($isDefault = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDefault) && !is_bool($isDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDefault, true), gettype($isDefault)), __LINE__);
        }
        $this->isDefault = $isDefault;
        return $this;
    }
    /**
     * Get taxItemList value
     * @return \StructType\TaxGroupTaxItemList|null
     */
    public function getTaxItemList()
    {
        return $this->taxItemList;
    }
    /**
     * Set taxItemList value
     * @param \StructType\TaxGroupTaxItemList $taxItemList
     * @return \StructType\TaxGroup
     */
    public function setTaxItemList(\StructType\TaxGroupTaxItemList $taxItemList = null)
    {
        $this->taxItemList = $taxItemList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\TaxGroup
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\TaxGroup
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
