<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Task StructType
 * Meta information extracted from the WSDL
 * - type: actSched:Task
 * @subpackage Structs
 */
class Task extends Record
{
    /**
     * The company
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $company;
    /**
     * The contact
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $contact;
    /**
     * The supportCase
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $supportCase;
    /**
     * The transaction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $transaction;
    /**
     * The milestone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $milestone;
    /**
     * The customForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customForm;
    /**
     * The title
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $title;
    /**
     * The assigned
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $assigned;
    /**
     * The sendEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $sendEmail;
    /**
     * The timedEvent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $timedEvent;
    /**
     * The estimatedTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Duration
     */
    public $estimatedTime;
    /**
     * The estimatedTimeOverride
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Duration
     */
    public $estimatedTimeOverride;
    /**
     * The actualTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Duration
     */
    public $actualTime;
    /**
     * The timeRemaining
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Duration
     */
    public $timeRemaining;
    /**
     * The percentTimeComplete
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $percentTimeComplete;
    /**
     * The percentComplete
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $percentComplete;
    /**
     * The parent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $parent;
    /**
     * The startDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $startDate;
    /**
     * The endDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $endDate;
    /**
     * The dueDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dueDate;
    /**
     * The completedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $completedDate;
    /**
     * The priority
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $priority;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The message
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $message;
    /**
     * The accessLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $accessLevel;
    /**
     * The reminderType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $reminderType;
    /**
     * The reminderMinutes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $reminderMinutes;
    /**
     * The createdDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $createdDate;
    /**
     * The lastModifiedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastModifiedDate;
    /**
     * The owner
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $owner;
    /**
     * The contactList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TaskContactList
     */
    public $contactList;
    /**
     * The timeItemList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TaskTimeItemList
     */
    public $timeItemList;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for Task
     * @uses Task::setCompany()
     * @uses Task::setContact()
     * @uses Task::setSupportCase()
     * @uses Task::setTransaction()
     * @uses Task::setMilestone()
     * @uses Task::setCustomForm()
     * @uses Task::setTitle()
     * @uses Task::setAssigned()
     * @uses Task::setSendEmail()
     * @uses Task::setTimedEvent()
     * @uses Task::setEstimatedTime()
     * @uses Task::setEstimatedTimeOverride()
     * @uses Task::setActualTime()
     * @uses Task::setTimeRemaining()
     * @uses Task::setPercentTimeComplete()
     * @uses Task::setPercentComplete()
     * @uses Task::setParent()
     * @uses Task::setStartDate()
     * @uses Task::setEndDate()
     * @uses Task::setDueDate()
     * @uses Task::setCompletedDate()
     * @uses Task::setPriority()
     * @uses Task::setStatus()
     * @uses Task::setMessage()
     * @uses Task::setAccessLevel()
     * @uses Task::setReminderType()
     * @uses Task::setReminderMinutes()
     * @uses Task::setCreatedDate()
     * @uses Task::setLastModifiedDate()
     * @uses Task::setOwner()
     * @uses Task::setContactList()
     * @uses Task::setTimeItemList()
     * @uses Task::setCustomFieldList()
     * @uses Task::setInternalId()
     * @uses Task::setExternalId()
     * @param \StructType\RecordRef $company
     * @param \StructType\RecordRef $contact
     * @param \StructType\RecordRef $supportCase
     * @param \StructType\RecordRef $transaction
     * @param \StructType\RecordRef $milestone
     * @param \StructType\RecordRef $customForm
     * @param string $title
     * @param \StructType\RecordRef $assigned
     * @param bool $sendEmail
     * @param bool $timedEvent
     * @param \StructType\Duration $estimatedTime
     * @param \StructType\Duration $estimatedTimeOverride
     * @param \StructType\Duration $actualTime
     * @param \StructType\Duration $timeRemaining
     * @param float $percentTimeComplete
     * @param float $percentComplete
     * @param \StructType\RecordRef $parent
     * @param string $startDate
     * @param string $endDate
     * @param string $dueDate
     * @param string $completedDate
     * @param string $priority
     * @param string $status
     * @param string $message
     * @param bool $accessLevel
     * @param string $reminderType
     * @param string $reminderMinutes
     * @param string $createdDate
     * @param string $lastModifiedDate
     * @param \StructType\RecordRef $owner
     * @param \StructType\TaskContactList $contactList
     * @param \StructType\TaskTimeItemList $timeItemList
     * @param \StructType\CustomFieldList $customFieldList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct(\StructType\RecordRef $company = null, \StructType\RecordRef $contact = null, \StructType\RecordRef $supportCase = null, \StructType\RecordRef $transaction = null, \StructType\RecordRef $milestone = null, \StructType\RecordRef $customForm = null, $title = null, \StructType\RecordRef $assigned = null, $sendEmail = null, $timedEvent = null, \StructType\Duration $estimatedTime = null, \StructType\Duration $estimatedTimeOverride = null, \StructType\Duration $actualTime = null, \StructType\Duration $timeRemaining = null, $percentTimeComplete = null, $percentComplete = null, \StructType\RecordRef $parent = null, $startDate = null, $endDate = null, $dueDate = null, $completedDate = null, $priority = null, $status = null, $message = null, $accessLevel = null, $reminderType = null, $reminderMinutes = null, $createdDate = null, $lastModifiedDate = null, \StructType\RecordRef $owner = null, \StructType\TaskContactList $contactList = null, \StructType\TaskTimeItemList $timeItemList = null, \StructType\CustomFieldList $customFieldList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setCompany($company)
            ->setContact($contact)
            ->setSupportCase($supportCase)
            ->setTransaction($transaction)
            ->setMilestone($milestone)
            ->setCustomForm($customForm)
            ->setTitle($title)
            ->setAssigned($assigned)
            ->setSendEmail($sendEmail)
            ->setTimedEvent($timedEvent)
            ->setEstimatedTime($estimatedTime)
            ->setEstimatedTimeOverride($estimatedTimeOverride)
            ->setActualTime($actualTime)
            ->setTimeRemaining($timeRemaining)
            ->setPercentTimeComplete($percentTimeComplete)
            ->setPercentComplete($percentComplete)
            ->setParent($parent)
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setDueDate($dueDate)
            ->setCompletedDate($completedDate)
            ->setPriority($priority)
            ->setStatus($status)
            ->setMessage($message)
            ->setAccessLevel($accessLevel)
            ->setReminderType($reminderType)
            ->setReminderMinutes($reminderMinutes)
            ->setCreatedDate($createdDate)
            ->setLastModifiedDate($lastModifiedDate)
            ->setOwner($owner)
            ->setContactList($contactList)
            ->setTimeItemList($timeItemList)
            ->setCustomFieldList($customFieldList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get company value
     * @return \StructType\RecordRef|null
     */
    public function getCompany()
    {
        return $this->company;
    }
    /**
     * Set company value
     * @param \StructType\RecordRef $company
     * @return \StructType\Task
     */
    public function setCompany(\StructType\RecordRef $company = null)
    {
        $this->company = $company;
        return $this;
    }
    /**
     * Get contact value
     * @return \StructType\RecordRef|null
     */
    public function getContact()
    {
        return $this->contact;
    }
    /**
     * Set contact value
     * @param \StructType\RecordRef $contact
     * @return \StructType\Task
     */
    public function setContact(\StructType\RecordRef $contact = null)
    {
        $this->contact = $contact;
        return $this;
    }
    /**
     * Get supportCase value
     * @return \StructType\RecordRef|null
     */
    public function getSupportCase()
    {
        return $this->supportCase;
    }
    /**
     * Set supportCase value
     * @param \StructType\RecordRef $supportCase
     * @return \StructType\Task
     */
    public function setSupportCase(\StructType\RecordRef $supportCase = null)
    {
        $this->supportCase = $supportCase;
        return $this;
    }
    /**
     * Get transaction value
     * @return \StructType\RecordRef|null
     */
    public function getTransaction()
    {
        return $this->transaction;
    }
    /**
     * Set transaction value
     * @param \StructType\RecordRef $transaction
     * @return \StructType\Task
     */
    public function setTransaction(\StructType\RecordRef $transaction = null)
    {
        $this->transaction = $transaction;
        return $this;
    }
    /**
     * Get milestone value
     * @return \StructType\RecordRef|null
     */
    public function getMilestone()
    {
        return $this->milestone;
    }
    /**
     * Set milestone value
     * @param \StructType\RecordRef $milestone
     * @return \StructType\Task
     */
    public function setMilestone(\StructType\RecordRef $milestone = null)
    {
        $this->milestone = $milestone;
        return $this;
    }
    /**
     * Get customForm value
     * @return \StructType\RecordRef|null
     */
    public function getCustomForm()
    {
        return $this->customForm;
    }
    /**
     * Set customForm value
     * @param \StructType\RecordRef $customForm
     * @return \StructType\Task
     */
    public function setCustomForm(\StructType\RecordRef $customForm = null)
    {
        $this->customForm = $customForm;
        return $this;
    }
    /**
     * Get title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \StructType\Task
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get assigned value
     * @return \StructType\RecordRef|null
     */
    public function getAssigned()
    {
        return $this->assigned;
    }
    /**
     * Set assigned value
     * @param \StructType\RecordRef $assigned
     * @return \StructType\Task
     */
    public function setAssigned(\StructType\RecordRef $assigned = null)
    {
        $this->assigned = $assigned;
        return $this;
    }
    /**
     * Get sendEmail value
     * @return bool|null
     */
    public function getSendEmail()
    {
        return $this->sendEmail;
    }
    /**
     * Set sendEmail value
     * @param bool $sendEmail
     * @return \StructType\Task
     */
    public function setSendEmail($sendEmail = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendEmail) && !is_bool($sendEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sendEmail, true), gettype($sendEmail)), __LINE__);
        }
        $this->sendEmail = $sendEmail;
        return $this;
    }
    /**
     * Get timedEvent value
     * @return bool|null
     */
    public function getTimedEvent()
    {
        return $this->timedEvent;
    }
    /**
     * Set timedEvent value
     * @param bool $timedEvent
     * @return \StructType\Task
     */
    public function setTimedEvent($timedEvent = null)
    {
        // validation for constraint: boolean
        if (!is_null($timedEvent) && !is_bool($timedEvent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($timedEvent, true), gettype($timedEvent)), __LINE__);
        }
        $this->timedEvent = $timedEvent;
        return $this;
    }
    /**
     * Get estimatedTime value
     * @return \StructType\Duration|null
     */
    public function getEstimatedTime()
    {
        return $this->estimatedTime;
    }
    /**
     * Set estimatedTime value
     * @param \StructType\Duration $estimatedTime
     * @return \StructType\Task
     */
    public function setEstimatedTime(\StructType\Duration $estimatedTime = null)
    {
        $this->estimatedTime = $estimatedTime;
        return $this;
    }
    /**
     * Get estimatedTimeOverride value
     * @return \StructType\Duration|null
     */
    public function getEstimatedTimeOverride()
    {
        return $this->estimatedTimeOverride;
    }
    /**
     * Set estimatedTimeOverride value
     * @param \StructType\Duration $estimatedTimeOverride
     * @return \StructType\Task
     */
    public function setEstimatedTimeOverride(\StructType\Duration $estimatedTimeOverride = null)
    {
        $this->estimatedTimeOverride = $estimatedTimeOverride;
        return $this;
    }
    /**
     * Get actualTime value
     * @return \StructType\Duration|null
     */
    public function getActualTime()
    {
        return $this->actualTime;
    }
    /**
     * Set actualTime value
     * @param \StructType\Duration $actualTime
     * @return \StructType\Task
     */
    public function setActualTime(\StructType\Duration $actualTime = null)
    {
        $this->actualTime = $actualTime;
        return $this;
    }
    /**
     * Get timeRemaining value
     * @return \StructType\Duration|null
     */
    public function getTimeRemaining()
    {
        return $this->timeRemaining;
    }
    /**
     * Set timeRemaining value
     * @param \StructType\Duration $timeRemaining
     * @return \StructType\Task
     */
    public function setTimeRemaining(\StructType\Duration $timeRemaining = null)
    {
        $this->timeRemaining = $timeRemaining;
        return $this;
    }
    /**
     * Get percentTimeComplete value
     * @return float|null
     */
    public function getPercentTimeComplete()
    {
        return $this->percentTimeComplete;
    }
    /**
     * Set percentTimeComplete value
     * @param float $percentTimeComplete
     * @return \StructType\Task
     */
    public function setPercentTimeComplete($percentTimeComplete = null)
    {
        // validation for constraint: float
        if (!is_null($percentTimeComplete) && !(is_float($percentTimeComplete) || is_numeric($percentTimeComplete))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percentTimeComplete, true), gettype($percentTimeComplete)), __LINE__);
        }
        $this->percentTimeComplete = $percentTimeComplete;
        return $this;
    }
    /**
     * Get percentComplete value
     * @return float|null
     */
    public function getPercentComplete()
    {
        return $this->percentComplete;
    }
    /**
     * Set percentComplete value
     * @param float $percentComplete
     * @return \StructType\Task
     */
    public function setPercentComplete($percentComplete = null)
    {
        // validation for constraint: float
        if (!is_null($percentComplete) && !(is_float($percentComplete) || is_numeric($percentComplete))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percentComplete, true), gettype($percentComplete)), __LINE__);
        }
        $this->percentComplete = $percentComplete;
        return $this;
    }
    /**
     * Get parent value
     * @return \StructType\RecordRef|null
     */
    public function getParent()
    {
        return $this->parent;
    }
    /**
     * Set parent value
     * @param \StructType\RecordRef $parent
     * @return \StructType\Task
     */
    public function setParent(\StructType\RecordRef $parent = null)
    {
        $this->parent = $parent;
        return $this;
    }
    /**
     * Get startDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \StructType\Task
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \StructType\Task
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Get dueDate value
     * @return string|null
     */
    public function getDueDate()
    {
        return $this->dueDate;
    }
    /**
     * Set dueDate value
     * @param string $dueDate
     * @return \StructType\Task
     */
    public function setDueDate($dueDate = null)
    {
        // validation for constraint: string
        if (!is_null($dueDate) && !is_string($dueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dueDate, true), gettype($dueDate)), __LINE__);
        }
        $this->dueDate = $dueDate;
        return $this;
    }
    /**
     * Get completedDate value
     * @return string|null
     */
    public function getCompletedDate()
    {
        return $this->completedDate;
    }
    /**
     * Set completedDate value
     * @param string $completedDate
     * @return \StructType\Task
     */
    public function setCompletedDate($completedDate = null)
    {
        // validation for constraint: string
        if (!is_null($completedDate) && !is_string($completedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($completedDate, true), gettype($completedDate)), __LINE__);
        }
        $this->completedDate = $completedDate;
        return $this;
    }
    /**
     * Get priority value
     * @return string|null
     */
    public function getPriority()
    {
        return $this->priority;
    }
    /**
     * Set priority value
     * @uses \EnumType\TaskPriority::valueIsValid()
     * @uses \EnumType\TaskPriority::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $priority
     * @return \StructType\Task
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TaskPriority::valueIsValid($priority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TaskPriority', is_array($priority) ? implode(', ', $priority) : var_export($priority, true), implode(', ', \EnumType\TaskPriority::getValidValues())), __LINE__);
        }
        $this->priority = $priority;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \EnumType\TaskStatus::valueIsValid()
     * @uses \EnumType\TaskStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\Task
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TaskStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TaskStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\TaskStatus::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \StructType\Task
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
    /**
     * Get accessLevel value
     * @return bool|null
     */
    public function getAccessLevel()
    {
        return $this->accessLevel;
    }
    /**
     * Set accessLevel value
     * @param bool $accessLevel
     * @return \StructType\Task
     */
    public function setAccessLevel($accessLevel = null)
    {
        // validation for constraint: boolean
        if (!is_null($accessLevel) && !is_bool($accessLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($accessLevel, true), gettype($accessLevel)), __LINE__);
        }
        $this->accessLevel = $accessLevel;
        return $this;
    }
    /**
     * Get reminderType value
     * @return string|null
     */
    public function getReminderType()
    {
        return $this->reminderType;
    }
    /**
     * Set reminderType value
     * @uses \EnumType\TaskReminderType::valueIsValid()
     * @uses \EnumType\TaskReminderType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $reminderType
     * @return \StructType\Task
     */
    public function setReminderType($reminderType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TaskReminderType::valueIsValid($reminderType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TaskReminderType', is_array($reminderType) ? implode(', ', $reminderType) : var_export($reminderType, true), implode(', ', \EnumType\TaskReminderType::getValidValues())), __LINE__);
        }
        $this->reminderType = $reminderType;
        return $this;
    }
    /**
     * Get reminderMinutes value
     * @return string|null
     */
    public function getReminderMinutes()
    {
        return $this->reminderMinutes;
    }
    /**
     * Set reminderMinutes value
     * @uses \EnumType\TaskReminderMinutes::valueIsValid()
     * @uses \EnumType\TaskReminderMinutes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $reminderMinutes
     * @return \StructType\Task
     */
    public function setReminderMinutes($reminderMinutes = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TaskReminderMinutes::valueIsValid($reminderMinutes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TaskReminderMinutes', is_array($reminderMinutes) ? implode(', ', $reminderMinutes) : var_export($reminderMinutes, true), implode(', ', \EnumType\TaskReminderMinutes::getValidValues())), __LINE__);
        }
        $this->reminderMinutes = $reminderMinutes;
        return $this;
    }
    /**
     * Get createdDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->createdDate;
    }
    /**
     * Set createdDate value
     * @param string $createdDate
     * @return \StructType\Task
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        $this->createdDate = $createdDate;
        return $this;
    }
    /**
     * Get lastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->lastModifiedDate;
    }
    /**
     * Set lastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\Task
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->lastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get owner value
     * @return \StructType\RecordRef|null
     */
    public function getOwner()
    {
        return $this->owner;
    }
    /**
     * Set owner value
     * @param \StructType\RecordRef $owner
     * @return \StructType\Task
     */
    public function setOwner(\StructType\RecordRef $owner = null)
    {
        $this->owner = $owner;
        return $this;
    }
    /**
     * Get contactList value
     * @return \StructType\TaskContactList|null
     */
    public function getContactList()
    {
        return $this->contactList;
    }
    /**
     * Set contactList value
     * @param \StructType\TaskContactList $contactList
     * @return \StructType\Task
     */
    public function setContactList(\StructType\TaskContactList $contactList = null)
    {
        $this->contactList = $contactList;
        return $this;
    }
    /**
     * Get timeItemList value
     * @return \StructType\TaskTimeItemList|null
     */
    public function getTimeItemList()
    {
        return $this->timeItemList;
    }
    /**
     * Set timeItemList value
     * @param \StructType\TaskTimeItemList $timeItemList
     * @return \StructType\Task
     */
    public function setTimeItemList(\StructType\TaskTimeItemList $timeItemList = null)
    {
        $this->timeItemList = $timeItemList;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\Task
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\Task
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\Task
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
