<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SupportCaseSolutionsList StructType
 * @subpackage Structs
 */
class SupportCaseSolutionsList extends AbstractStructBase
{
    /**
     * The solutions
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SupportCaseSolutions[]
     */
    public $solutions;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for SupportCaseSolutionsList
     * @uses SupportCaseSolutionsList::setSolutions()
     * @uses SupportCaseSolutionsList::setReplaceAll()
     * @param \StructType\SupportCaseSolutions[] $solutions
     * @param bool $replaceAll
     */
    public function __construct(array $solutions = array(), $replaceAll = true)
    {
        $this
            ->setSolutions($solutions)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get solutions value
     * @return \StructType\SupportCaseSolutions[]|null
     */
    public function getSolutions()
    {
        return $this->solutions;
    }
    /**
     * This method is responsible for validating the values passed to the setSolutions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSolutions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSolutionsForArrayConstraintsFromSetSolutions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $supportCaseSolutionsListSolutionsItem) {
            // validation for constraint: itemType
            if (!$supportCaseSolutionsListSolutionsItem instanceof \StructType\SupportCaseSolutions) {
                $invalidValues[] = is_object($supportCaseSolutionsListSolutionsItem) ? get_class($supportCaseSolutionsListSolutionsItem) : sprintf('%s(%s)', gettype($supportCaseSolutionsListSolutionsItem), var_export($supportCaseSolutionsListSolutionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The solutions property can only contain items of type \StructType\SupportCaseSolutions, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set solutions value
     * @throws \InvalidArgumentException
     * @param \StructType\SupportCaseSolutions[] $solutions
     * @return \StructType\SupportCaseSolutionsList
     */
    public function setSolutions(array $solutions = array())
    {
        // validation for constraint: array
        if ('' !== ($solutionsArrayErrorMessage = self::validateSolutionsForArrayConstraintsFromSetSolutions($solutions))) {
            throw new \InvalidArgumentException($solutionsArrayErrorMessage, __LINE__);
        }
        $this->solutions = $solutions;
        return $this;
    }
    /**
     * Add item to solutions value
     * @throws \InvalidArgumentException
     * @param \StructType\SupportCaseSolutions $item
     * @return \StructType\SupportCaseSolutionsList
     */
    public function addToSolutions(\StructType\SupportCaseSolutions $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SupportCaseSolutions) {
            throw new \InvalidArgumentException(sprintf('The solutions property can only contain items of type \StructType\SupportCaseSolutions, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->solutions[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\SupportCaseSolutionsList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
