<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SubsidiaryNexusList StructType
 * @subpackage Structs
 */
class SubsidiaryNexusList extends AbstractStructBase
{
    /**
     * The nexus
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SubsidiaryNexus[]
     */
    public $nexus;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for SubsidiaryNexusList
     * @uses SubsidiaryNexusList::setNexus()
     * @uses SubsidiaryNexusList::setReplaceAll()
     * @param \StructType\SubsidiaryNexus[] $nexus
     * @param bool $replaceAll
     */
    public function __construct(array $nexus = array(), $replaceAll = true)
    {
        $this
            ->setNexus($nexus)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get nexus value
     * @return \StructType\SubsidiaryNexus[]|null
     */
    public function getNexus()
    {
        return $this->nexus;
    }
    /**
     * This method is responsible for validating the values passed to the setNexus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNexus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNexusForArrayConstraintsFromSetNexus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $subsidiaryNexusListNexusItem) {
            // validation for constraint: itemType
            if (!$subsidiaryNexusListNexusItem instanceof \StructType\SubsidiaryNexus) {
                $invalidValues[] = is_object($subsidiaryNexusListNexusItem) ? get_class($subsidiaryNexusListNexusItem) : sprintf('%s(%s)', gettype($subsidiaryNexusListNexusItem), var_export($subsidiaryNexusListNexusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The nexus property can only contain items of type \StructType\SubsidiaryNexus, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set nexus value
     * @throws \InvalidArgumentException
     * @param \StructType\SubsidiaryNexus[] $nexus
     * @return \StructType\SubsidiaryNexusList
     */
    public function setNexus(array $nexus = array())
    {
        // validation for constraint: array
        if ('' !== ($nexusArrayErrorMessage = self::validateNexusForArrayConstraintsFromSetNexus($nexus))) {
            throw new \InvalidArgumentException($nexusArrayErrorMessage, __LINE__);
        }
        $this->nexus = $nexus;
        return $this;
    }
    /**
     * Add item to nexus value
     * @throws \InvalidArgumentException
     * @param \StructType\SubsidiaryNexus $item
     * @return \StructType\SubsidiaryNexusList
     */
    public function addToNexus(\StructType\SubsidiaryNexus $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SubsidiaryNexus) {
            throw new \InvalidArgumentException(sprintf('The nexus property can only contain items of type \StructType\SubsidiaryNexus, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->nexus[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\SubsidiaryNexusList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
