<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StatusDetail StructType
 * @subpackage Structs
 */
class StatusDetail extends AbstractStructBase
{
    /**
     * The code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $code;
    /**
     * The message
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $message;
    /**
     * The afterSubmitFailed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $afterSubmitFailed;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - default: ERROR
     * @var string
     */
    public $type;
    /**
     * Constructor method for StatusDetail
     * @uses StatusDetail::setCode()
     * @uses StatusDetail::setMessage()
     * @uses StatusDetail::setAfterSubmitFailed()
     * @uses StatusDetail::setType()
     * @param string $code
     * @param string $message
     * @param bool $afterSubmitFailed
     * @param string $type
     */
    public function __construct($code = null, $message = null, $afterSubmitFailed = null, $type = 'ERROR')
    {
        $this
            ->setCode($code)
            ->setMessage($message)
            ->setAfterSubmitFailed($afterSubmitFailed)
            ->setType($type);
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @uses \EnumType\StatusDetailCodeType::valueIsValid()
     * @uses \EnumType\StatusDetailCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $code
     * @return \StructType\StatusDetail
     */
    public function setCode($code = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StatusDetailCodeType::valueIsValid($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\StatusDetailCodeType', is_array($code) ? implode(', ', $code) : var_export($code, true), implode(', ', \EnumType\StatusDetailCodeType::getValidValues())), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \StructType\StatusDetail
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
    /**
     * Get afterSubmitFailed value
     * @return bool|null
     */
    public function getAfterSubmitFailed()
    {
        return $this->afterSubmitFailed;
    }
    /**
     * Set afterSubmitFailed value
     * @param bool $afterSubmitFailed
     * @return \StructType\StatusDetail
     */
    public function setAfterSubmitFailed($afterSubmitFailed = null)
    {
        // validation for constraint: boolean
        if (!is_null($afterSubmitFailed) && !is_bool($afterSubmitFailed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($afterSubmitFailed, true), gettype($afterSubmitFailed)), __LINE__);
        }
        $this->afterSubmitFailed = $afterSubmitFailed;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\StatusDetailType::valueIsValid()
     * @uses \EnumType\StatusDetailType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\StatusDetail
     */
    public function setType($type = 'ERROR')
    {
        // validation for constraint: enumeration
        if (!\EnumType\StatusDetailType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\StatusDetailType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \EnumType\StatusDetailType::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
}
