<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for State StructType
 * @subpackage Structs
 */
class State extends Record
{
    /**
     * The country
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $country;
    /**
     * The fullName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fullName;
    /**
     * The shortname
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shortname;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * Constructor method for State
     * @uses State::setCountry()
     * @uses State::setFullName()
     * @uses State::setShortname()
     * @uses State::setInternalId()
     * @param string $country
     * @param string $fullName
     * @param string $shortname
     * @param string $internalId
     */
    public function __construct($country = null, $fullName = null, $shortname = null, $internalId = null)
    {
        $this
            ->setCountry($country)
            ->setFullName($fullName)
            ->setShortname($shortname)
            ->setInternalId($internalId);
    }
    /**
     * Get country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @uses \EnumType\Country::valueIsValid()
     * @uses \EnumType\Country::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $country
     * @return \StructType\State
     */
    public function setCountry($country = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Country::valueIsValid($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Country', is_array($country) ? implode(', ', $country) : var_export($country, true), implode(', ', \EnumType\Country::getValidValues())), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get fullName value
     * @return string|null
     */
    public function getFullName()
    {
        return $this->fullName;
    }
    /**
     * Set fullName value
     * @param string $fullName
     * @return \StructType\State
     */
    public function setFullName($fullName = null)
    {
        // validation for constraint: string
        if (!is_null($fullName) && !is_string($fullName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fullName, true), gettype($fullName)), __LINE__);
        }
        $this->fullName = $fullName;
        return $this;
    }
    /**
     * Get shortname value
     * @return string|null
     */
    public function getShortname()
    {
        return $this->shortname;
    }
    /**
     * Set shortname value
     * @param string $shortname
     * @return \StructType\State
     */
    public function setShortname($shortname = null)
    {
        // validation for constraint: string
        if (!is_null($shortname) && !is_string($shortname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shortname, true), gettype($shortname)), __LINE__);
        }
        $this->shortname = $shortname;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\State
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
}
