<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SoapFault StructType
 * @subpackage Structs
 */
class SoapFault extends AbstractStructBase
{
    /**
     * The code
     * @var string
     */
    public $code;
    /**
     * The message
     * @var string
     */
    public $message;
    /**
     * Constructor method for SoapFault
     * @uses SoapFault::setCode()
     * @uses SoapFault::setMessage()
     * @param string $code
     * @param string $message
     */
    public function __construct($code = null, $message = null)
    {
        $this
            ->setCode($code)
            ->setMessage($message);
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @uses \EnumType\FaultCodeType::valueIsValid()
     * @uses \EnumType\FaultCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $code
     * @return \StructType\SoapFault
     */
    public function setCode($code = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FaultCodeType::valueIsValid($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\FaultCodeType', is_array($code) ? implode(', ', $code) : var_export($code, true), implode(', ', \EnumType\FaultCodeType::getValidValues())), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \StructType\SoapFault
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
}
