<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SiteCategoryList StructType
 * @subpackage Structs
 */
class SiteCategoryList extends AbstractStructBase
{
    /**
     * The siteCategory
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SiteCategory[]
     */
    public $siteCategory;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for SiteCategoryList
     * @uses SiteCategoryList::setSiteCategory()
     * @uses SiteCategoryList::setReplaceAll()
     * @param \StructType\SiteCategory[] $siteCategory
     * @param bool $replaceAll
     */
    public function __construct(array $siteCategory = array(), $replaceAll = true)
    {
        $this
            ->setSiteCategory($siteCategory)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get siteCategory value
     * @return \StructType\SiteCategory[]|null
     */
    public function getSiteCategory()
    {
        return $this->siteCategory;
    }
    /**
     * This method is responsible for validating the values passed to the setSiteCategory method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSiteCategory method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSiteCategoryForArrayConstraintsFromSetSiteCategory(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $siteCategoryListSiteCategoryItem) {
            // validation for constraint: itemType
            if (!$siteCategoryListSiteCategoryItem instanceof \StructType\SiteCategory) {
                $invalidValues[] = is_object($siteCategoryListSiteCategoryItem) ? get_class($siteCategoryListSiteCategoryItem) : sprintf('%s(%s)', gettype($siteCategoryListSiteCategoryItem), var_export($siteCategoryListSiteCategoryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The siteCategory property can only contain items of type \StructType\SiteCategory, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set siteCategory value
     * @throws \InvalidArgumentException
     * @param \StructType\SiteCategory[] $siteCategory
     * @return \StructType\SiteCategoryList
     */
    public function setSiteCategory(array $siteCategory = array())
    {
        // validation for constraint: array
        if ('' !== ($siteCategoryArrayErrorMessage = self::validateSiteCategoryForArrayConstraintsFromSetSiteCategory($siteCategory))) {
            throw new \InvalidArgumentException($siteCategoryArrayErrorMessage, __LINE__);
        }
        $this->siteCategory = $siteCategory;
        return $this;
    }
    /**
     * Add item to siteCategory value
     * @throws \InvalidArgumentException
     * @param \StructType\SiteCategory $item
     * @return \StructType\SiteCategoryList
     */
    public function addToSiteCategory(\StructType\SiteCategory $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SiteCategory) {
            throw new \InvalidArgumentException(sprintf('The siteCategory property can only contain items of type \StructType\SiteCategory, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->siteCategory[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\SiteCategoryList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
