<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchMultiSelectCustomField StructType
 * @subpackage Structs
 */
class SearchMultiSelectCustomField extends SearchCustomField
{
    /**
     * The searchValue
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ListOrRecordRef[]
     */
    public $searchValue;
    /**
     * The operator
     * @var string
     */
    public $operator;
    /**
     * Constructor method for SearchMultiSelectCustomField
     * @uses SearchMultiSelectCustomField::setSearchValue()
     * @uses SearchMultiSelectCustomField::setOperator()
     * @param \StructType\ListOrRecordRef[] $searchValue
     * @param string $operator
     */
    public function __construct(array $searchValue = array(), $operator = null)
    {
        $this
            ->setSearchValue($searchValue)
            ->setOperator($operator);
    }
    /**
     * Get searchValue value
     * @return \StructType\ListOrRecordRef[]|null
     */
    public function getSearchValue()
    {
        return $this->searchValue;
    }
    /**
     * This method is responsible for validating the values passed to the setSearchValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSearchValue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSearchValueForArrayConstraintsFromSetSearchValue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $searchMultiSelectCustomFieldSearchValueItem) {
            // validation for constraint: itemType
            if (!$searchMultiSelectCustomFieldSearchValueItem instanceof \StructType\ListOrRecordRef) {
                $invalidValues[] = is_object($searchMultiSelectCustomFieldSearchValueItem) ? get_class($searchMultiSelectCustomFieldSearchValueItem) : sprintf('%s(%s)', gettype($searchMultiSelectCustomFieldSearchValueItem), var_export($searchMultiSelectCustomFieldSearchValueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The searchValue property can only contain items of type \StructType\ListOrRecordRef, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set searchValue value
     * @throws \InvalidArgumentException
     * @param \StructType\ListOrRecordRef[] $searchValue
     * @return \StructType\SearchMultiSelectCustomField
     */
    public function setSearchValue(array $searchValue = array())
    {
        // validation for constraint: array
        if ('' !== ($searchValueArrayErrorMessage = self::validateSearchValueForArrayConstraintsFromSetSearchValue($searchValue))) {
            throw new \InvalidArgumentException($searchValueArrayErrorMessage, __LINE__);
        }
        $this->searchValue = $searchValue;
        return $this;
    }
    /**
     * Add item to searchValue value
     * @throws \InvalidArgumentException
     * @param \StructType\ListOrRecordRef $item
     * @return \StructType\SearchMultiSelectCustomField
     */
    public function addToSearchValue(\StructType\ListOrRecordRef $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ListOrRecordRef) {
            throw new \InvalidArgumentException(sprintf('The searchValue property can only contain items of type \StructType\ListOrRecordRef, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->searchValue[] = $item;
        return $this;
    }
    /**
     * Get operator value
     * @return string|null
     */
    public function getOperator()
    {
        return $this->operator;
    }
    /**
     * Set operator value
     * @uses \EnumType\SearchMultiSelectFieldOperator::valueIsValid()
     * @uses \EnumType\SearchMultiSelectFieldOperator::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operator
     * @return \StructType\SearchMultiSelectCustomField
     */
    public function setOperator($operator = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SearchMultiSelectFieldOperator::valueIsValid($operator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SearchMultiSelectFieldOperator', is_array($operator) ? implode(', ', $operator) : var_export($operator, true), implode(', ', \EnumType\SearchMultiSelectFieldOperator::getValidValues())), __LINE__);
        }
        $this->operator = $operator;
        return $this;
    }
}
