<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchLongCustomField StructType
 * @subpackage Structs
 */
class SearchLongCustomField extends SearchCustomField
{
    /**
     * The searchValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $searchValue;
    /**
     * The searchValue2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $searchValue2;
    /**
     * The operator
     * @var string
     */
    public $operator;
    /**
     * Constructor method for SearchLongCustomField
     * @uses SearchLongCustomField::setSearchValue()
     * @uses SearchLongCustomField::setSearchValue2()
     * @uses SearchLongCustomField::setOperator()
     * @param int $searchValue
     * @param int $searchValue2
     * @param string $operator
     */
    public function __construct($searchValue = null, $searchValue2 = null, $operator = null)
    {
        $this
            ->setSearchValue($searchValue)
            ->setSearchValue2($searchValue2)
            ->setOperator($operator);
    }
    /**
     * Get searchValue value
     * @return int|null
     */
    public function getSearchValue()
    {
        return $this->searchValue;
    }
    /**
     * Set searchValue value
     * @param int $searchValue
     * @return \StructType\SearchLongCustomField
     */
    public function setSearchValue($searchValue = null)
    {
        // validation for constraint: int
        if (!is_null($searchValue) && !(is_int($searchValue) || ctype_digit($searchValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($searchValue, true), gettype($searchValue)), __LINE__);
        }
        $this->searchValue = $searchValue;
        return $this;
    }
    /**
     * Get searchValue2 value
     * @return int|null
     */
    public function getSearchValue2()
    {
        return $this->searchValue2;
    }
    /**
     * Set searchValue2 value
     * @param int $searchValue2
     * @return \StructType\SearchLongCustomField
     */
    public function setSearchValue2($searchValue2 = null)
    {
        // validation for constraint: int
        if (!is_null($searchValue2) && !(is_int($searchValue2) || ctype_digit($searchValue2))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($searchValue2, true), gettype($searchValue2)), __LINE__);
        }
        $this->searchValue2 = $searchValue2;
        return $this;
    }
    /**
     * Get operator value
     * @return string|null
     */
    public function getOperator()
    {
        return $this->operator;
    }
    /**
     * Set operator value
     * @uses \EnumType\SearchLongFieldOperator::valueIsValid()
     * @uses \EnumType\SearchLongFieldOperator::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operator
     * @return \StructType\SearchLongCustomField
     */
    public function setOperator($operator = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SearchLongFieldOperator::valueIsValid($operator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SearchLongFieldOperator', is_array($operator) ? implode(', ', $operator) : var_export($operator, true), implode(', ', \EnumType\SearchLongFieldOperator::getValidValues())), __LINE__);
        }
        $this->operator = $operator;
        return $this;
    }
}
