<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchEnumMultiSelectCustomField StructType
 * @subpackage Structs
 */
class SearchEnumMultiSelectCustomField extends SearchCustomField
{
    /**
     * The searchValue
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $searchValue;
    /**
     * The operator
     * @var string
     */
    public $operator;
    /**
     * Constructor method for SearchEnumMultiSelectCustomField
     * @uses SearchEnumMultiSelectCustomField::setSearchValue()
     * @uses SearchEnumMultiSelectCustomField::setOperator()
     * @param string[] $searchValue
     * @param string $operator
     */
    public function __construct(array $searchValue = array(), $operator = null)
    {
        $this
            ->setSearchValue($searchValue)
            ->setOperator($operator);
    }
    /**
     * Get searchValue value
     * @return string[]|null
     */
    public function getSearchValue()
    {
        return $this->searchValue;
    }
    /**
     * This method is responsible for validating the values passed to the setSearchValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSearchValue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSearchValueForArrayConstraintsFromSetSearchValue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $searchEnumMultiSelectCustomFieldSearchValueItem) {
            // validation for constraint: itemType
            if (!is_string($searchEnumMultiSelectCustomFieldSearchValueItem)) {
                $invalidValues[] = is_object($searchEnumMultiSelectCustomFieldSearchValueItem) ? get_class($searchEnumMultiSelectCustomFieldSearchValueItem) : sprintf('%s(%s)', gettype($searchEnumMultiSelectCustomFieldSearchValueItem), var_export($searchEnumMultiSelectCustomFieldSearchValueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The searchValue property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set searchValue value
     * @throws \InvalidArgumentException
     * @param string[] $searchValue
     * @return \StructType\SearchEnumMultiSelectCustomField
     */
    public function setSearchValue(array $searchValue = array())
    {
        // validation for constraint: array
        if ('' !== ($searchValueArrayErrorMessage = self::validateSearchValueForArrayConstraintsFromSetSearchValue($searchValue))) {
            throw new \InvalidArgumentException($searchValueArrayErrorMessage, __LINE__);
        }
        $this->searchValue = $searchValue;
        return $this;
    }
    /**
     * Add item to searchValue value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\SearchEnumMultiSelectCustomField
     */
    public function addToSearchValue($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The searchValue property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->searchValue[] = $item;
        return $this;
    }
    /**
     * Get operator value
     * @return string|null
     */
    public function getOperator()
    {
        return $this->operator;
    }
    /**
     * Set operator value
     * @uses \EnumType\SearchEnumMultiSelectFieldOperator::valueIsValid()
     * @uses \EnumType\SearchEnumMultiSelectFieldOperator::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operator
     * @return \StructType\SearchEnumMultiSelectCustomField
     */
    public function setOperator($operator = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SearchEnumMultiSelectFieldOperator::valueIsValid($operator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SearchEnumMultiSelectFieldOperator', is_array($operator) ? implode(', ', $operator) : var_export($operator, true), implode(', ', \EnumType\SearchEnumMultiSelectFieldOperator::getValidValues())), __LINE__);
        }
        $this->operator = $operator;
        return $this;
    }
}
