<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SalesTaxItemSearchRow StructType
 * @subpackage Structs
 */
class SalesTaxItemSearchRow extends SearchRow
{
    /**
     * The basic
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SalesTaxItemSearchRowBasic
     */
    public $basic;
    /**
     * The taxTypeJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TaxTypeSearchRowBasic
     */
    public $taxTypeJoin;
    /**
     * The userJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EmployeeSearchRowBasic
     */
    public $userJoin;
    /**
     * The customSearchJoin
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomSearchRowBasic[]
     */
    public $customSearchJoin;
    /**
     * Constructor method for SalesTaxItemSearchRow
     * @uses SalesTaxItemSearchRow::setBasic()
     * @uses SalesTaxItemSearchRow::setTaxTypeJoin()
     * @uses SalesTaxItemSearchRow::setUserJoin()
     * @uses SalesTaxItemSearchRow::setCustomSearchJoin()
     * @param \StructType\SalesTaxItemSearchRowBasic $basic
     * @param \StructType\TaxTypeSearchRowBasic $taxTypeJoin
     * @param \StructType\EmployeeSearchRowBasic $userJoin
     * @param \StructType\CustomSearchRowBasic[] $customSearchJoin
     */
    public function __construct(\StructType\SalesTaxItemSearchRowBasic $basic = null, \StructType\TaxTypeSearchRowBasic $taxTypeJoin = null, \StructType\EmployeeSearchRowBasic $userJoin = null, array $customSearchJoin = array())
    {
        $this
            ->setBasic($basic)
            ->setTaxTypeJoin($taxTypeJoin)
            ->setUserJoin($userJoin)
            ->setCustomSearchJoin($customSearchJoin);
    }
    /**
     * Get basic value
     * @return \StructType\SalesTaxItemSearchRowBasic|null
     */
    public function getBasic()
    {
        return $this->basic;
    }
    /**
     * Set basic value
     * @param \StructType\SalesTaxItemSearchRowBasic $basic
     * @return \StructType\SalesTaxItemSearchRow
     */
    public function setBasic(\StructType\SalesTaxItemSearchRowBasic $basic = null)
    {
        $this->basic = $basic;
        return $this;
    }
    /**
     * Get taxTypeJoin value
     * @return \StructType\TaxTypeSearchRowBasic|null
     */
    public function getTaxTypeJoin()
    {
        return $this->taxTypeJoin;
    }
    /**
     * Set taxTypeJoin value
     * @param \StructType\TaxTypeSearchRowBasic $taxTypeJoin
     * @return \StructType\SalesTaxItemSearchRow
     */
    public function setTaxTypeJoin(\StructType\TaxTypeSearchRowBasic $taxTypeJoin = null)
    {
        $this->taxTypeJoin = $taxTypeJoin;
        return $this;
    }
    /**
     * Get userJoin value
     * @return \StructType\EmployeeSearchRowBasic|null
     */
    public function getUserJoin()
    {
        return $this->userJoin;
    }
    /**
     * Set userJoin value
     * @param \StructType\EmployeeSearchRowBasic $userJoin
     * @return \StructType\SalesTaxItemSearchRow
     */
    public function setUserJoin(\StructType\EmployeeSearchRowBasic $userJoin = null)
    {
        $this->userJoin = $userJoin;
        return $this;
    }
    /**
     * Get customSearchJoin value
     * @return \StructType\CustomSearchRowBasic[]|null
     */
    public function getCustomSearchJoin()
    {
        return $this->customSearchJoin;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomSearchJoin method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomSearchJoin method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomSearchJoinForArrayConstraintsFromSetCustomSearchJoin(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $salesTaxItemSearchRowCustomSearchJoinItem) {
            // validation for constraint: itemType
            if (!$salesTaxItemSearchRowCustomSearchJoinItem instanceof \StructType\CustomSearchRowBasic) {
                $invalidValues[] = is_object($salesTaxItemSearchRowCustomSearchJoinItem) ? get_class($salesTaxItemSearchRowCustomSearchJoinItem) : sprintf('%s(%s)', gettype($salesTaxItemSearchRowCustomSearchJoinItem), var_export($salesTaxItemSearchRowCustomSearchJoinItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The customSearchJoin property can only contain items of type \StructType\CustomSearchRowBasic, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set customSearchJoin value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomSearchRowBasic[] $customSearchJoin
     * @return \StructType\SalesTaxItemSearchRow
     */
    public function setCustomSearchJoin(array $customSearchJoin = array())
    {
        // validation for constraint: array
        if ('' !== ($customSearchJoinArrayErrorMessage = self::validateCustomSearchJoinForArrayConstraintsFromSetCustomSearchJoin($customSearchJoin))) {
            throw new \InvalidArgumentException($customSearchJoinArrayErrorMessage, __LINE__);
        }
        $this->customSearchJoin = $customSearchJoin;
        return $this;
    }
    /**
     * Add item to customSearchJoin value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomSearchRowBasic $item
     * @return \StructType\SalesTaxItemSearchRow
     */
    public function addToCustomSearchJoin(\StructType\CustomSearchRowBasic $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomSearchRowBasic) {
            throw new \InvalidArgumentException(sprintf('The customSearchJoin property can only contain items of type \StructType\CustomSearchRowBasic, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->customSearchJoin[] = $item;
        return $this;
    }
}
