<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RevRecTemplate StructType
 * @subpackage Structs
 */
class RevRecTemplate extends Record
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The amortizationType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $amortizationType;
    /**
     * The recurrenceType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $recurrenceType;
    /**
     * The recogIntervalSrc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $recogIntervalSrc;
    /**
     * The amortizationPeriod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $amortizationPeriod;
    /**
     * The periodOffset
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $periodOffset;
    /**
     * The revRecOffset
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $revRecOffset;
    /**
     * The initialAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $initialAmount;
    /**
     * The isInactive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isInactive;
    /**
     * The recurrenceList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RevRecTemplateRecurrenceList
     */
    public $recurrenceList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for RevRecTemplate
     * @uses RevRecTemplate::setName()
     * @uses RevRecTemplate::setAmortizationType()
     * @uses RevRecTemplate::setRecurrenceType()
     * @uses RevRecTemplate::setRecogIntervalSrc()
     * @uses RevRecTemplate::setAmortizationPeriod()
     * @uses RevRecTemplate::setPeriodOffset()
     * @uses RevRecTemplate::setRevRecOffset()
     * @uses RevRecTemplate::setInitialAmount()
     * @uses RevRecTemplate::setIsInactive()
     * @uses RevRecTemplate::setRecurrenceList()
     * @uses RevRecTemplate::setInternalId()
     * @uses RevRecTemplate::setExternalId()
     * @param string $name
     * @param string $amortizationType
     * @param string $recurrenceType
     * @param string $recogIntervalSrc
     * @param int $amortizationPeriod
     * @param int $periodOffset
     * @param int $revRecOffset
     * @param float $initialAmount
     * @param bool $isInactive
     * @param \StructType\RevRecTemplateRecurrenceList $recurrenceList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct($name = null, $amortizationType = null, $recurrenceType = null, $recogIntervalSrc = null, $amortizationPeriod = null, $periodOffset = null, $revRecOffset = null, $initialAmount = null, $isInactive = null, \StructType\RevRecTemplateRecurrenceList $recurrenceList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setName($name)
            ->setAmortizationType($amortizationType)
            ->setRecurrenceType($recurrenceType)
            ->setRecogIntervalSrc($recogIntervalSrc)
            ->setAmortizationPeriod($amortizationPeriod)
            ->setPeriodOffset($periodOffset)
            ->setRevRecOffset($revRecOffset)
            ->setInitialAmount($initialAmount)
            ->setIsInactive($isInactive)
            ->setRecurrenceList($recurrenceList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\RevRecTemplate
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get amortizationType value
     * @return string|null
     */
    public function getAmortizationType()
    {
        return $this->amortizationType;
    }
    /**
     * Set amortizationType value
     * @uses \EnumType\RevRecScheduleAmortizationType::valueIsValid()
     * @uses \EnumType\RevRecScheduleAmortizationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $amortizationType
     * @return \StructType\RevRecTemplate
     */
    public function setAmortizationType($amortizationType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RevRecScheduleAmortizationType::valueIsValid($amortizationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\RevRecScheduleAmortizationType', is_array($amortizationType) ? implode(', ', $amortizationType) : var_export($amortizationType, true), implode(', ', \EnumType\RevRecScheduleAmortizationType::getValidValues())), __LINE__);
        }
        $this->amortizationType = $amortizationType;
        return $this;
    }
    /**
     * Get recurrenceType value
     * @return string|null
     */
    public function getRecurrenceType()
    {
        return $this->recurrenceType;
    }
    /**
     * Set recurrenceType value
     * @uses \EnumType\RevRecScheduleRecurrenceType::valueIsValid()
     * @uses \EnumType\RevRecScheduleRecurrenceType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $recurrenceType
     * @return \StructType\RevRecTemplate
     */
    public function setRecurrenceType($recurrenceType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RevRecScheduleRecurrenceType::valueIsValid($recurrenceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\RevRecScheduleRecurrenceType', is_array($recurrenceType) ? implode(', ', $recurrenceType) : var_export($recurrenceType, true), implode(', ', \EnumType\RevRecScheduleRecurrenceType::getValidValues())), __LINE__);
        }
        $this->recurrenceType = $recurrenceType;
        return $this;
    }
    /**
     * Get recogIntervalSrc value
     * @return string|null
     */
    public function getRecogIntervalSrc()
    {
        return $this->recogIntervalSrc;
    }
    /**
     * Set recogIntervalSrc value
     * @uses \EnumType\RevRecScheduleRecogIntervalSrc::valueIsValid()
     * @uses \EnumType\RevRecScheduleRecogIntervalSrc::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $recogIntervalSrc
     * @return \StructType\RevRecTemplate
     */
    public function setRecogIntervalSrc($recogIntervalSrc = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RevRecScheduleRecogIntervalSrc::valueIsValid($recogIntervalSrc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\RevRecScheduleRecogIntervalSrc', is_array($recogIntervalSrc) ? implode(', ', $recogIntervalSrc) : var_export($recogIntervalSrc, true), implode(', ', \EnumType\RevRecScheduleRecogIntervalSrc::getValidValues())), __LINE__);
        }
        $this->recogIntervalSrc = $recogIntervalSrc;
        return $this;
    }
    /**
     * Get amortizationPeriod value
     * @return int|null
     */
    public function getAmortizationPeriod()
    {
        return $this->amortizationPeriod;
    }
    /**
     * Set amortizationPeriod value
     * @param int $amortizationPeriod
     * @return \StructType\RevRecTemplate
     */
    public function setAmortizationPeriod($amortizationPeriod = null)
    {
        // validation for constraint: int
        if (!is_null($amortizationPeriod) && !(is_int($amortizationPeriod) || ctype_digit($amortizationPeriod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($amortizationPeriod, true), gettype($amortizationPeriod)), __LINE__);
        }
        $this->amortizationPeriod = $amortizationPeriod;
        return $this;
    }
    /**
     * Get periodOffset value
     * @return int|null
     */
    public function getPeriodOffset()
    {
        return $this->periodOffset;
    }
    /**
     * Set periodOffset value
     * @param int $periodOffset
     * @return \StructType\RevRecTemplate
     */
    public function setPeriodOffset($periodOffset = null)
    {
        // validation for constraint: int
        if (!is_null($periodOffset) && !(is_int($periodOffset) || ctype_digit($periodOffset))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($periodOffset, true), gettype($periodOffset)), __LINE__);
        }
        $this->periodOffset = $periodOffset;
        return $this;
    }
    /**
     * Get revRecOffset value
     * @return int|null
     */
    public function getRevRecOffset()
    {
        return $this->revRecOffset;
    }
    /**
     * Set revRecOffset value
     * @param int $revRecOffset
     * @return \StructType\RevRecTemplate
     */
    public function setRevRecOffset($revRecOffset = null)
    {
        // validation for constraint: int
        if (!is_null($revRecOffset) && !(is_int($revRecOffset) || ctype_digit($revRecOffset))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($revRecOffset, true), gettype($revRecOffset)), __LINE__);
        }
        $this->revRecOffset = $revRecOffset;
        return $this;
    }
    /**
     * Get initialAmount value
     * @return float|null
     */
    public function getInitialAmount()
    {
        return $this->initialAmount;
    }
    /**
     * Set initialAmount value
     * @param float $initialAmount
     * @return \StructType\RevRecTemplate
     */
    public function setInitialAmount($initialAmount = null)
    {
        // validation for constraint: float
        if (!is_null($initialAmount) && !(is_float($initialAmount) || is_numeric($initialAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($initialAmount, true), gettype($initialAmount)), __LINE__);
        }
        $this->initialAmount = $initialAmount;
        return $this;
    }
    /**
     * Get isInactive value
     * @return bool|null
     */
    public function getIsInactive()
    {
        return $this->isInactive;
    }
    /**
     * Set isInactive value
     * @param bool $isInactive
     * @return \StructType\RevRecTemplate
     */
    public function setIsInactive($isInactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInactive) && !is_bool($isInactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInactive, true), gettype($isInactive)), __LINE__);
        }
        $this->isInactive = $isInactive;
        return $this;
    }
    /**
     * Get recurrenceList value
     * @return \StructType\RevRecTemplateRecurrenceList|null
     */
    public function getRecurrenceList()
    {
        return $this->recurrenceList;
    }
    /**
     * Set recurrenceList value
     * @param \StructType\RevRecTemplateRecurrenceList $recurrenceList
     * @return \StructType\RevRecTemplate
     */
    public function setRecurrenceList(\StructType\RevRecTemplateRecurrenceList $recurrenceList = null)
    {
        $this->recurrenceList = $recurrenceList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\RevRecTemplate
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\RevRecTemplate
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
