<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReturnAuthorizationSalesTeam StructType
 * @subpackage Structs
 */
class ReturnAuthorizationSalesTeam extends AbstractStructBase
{
    /**
     * The employee
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $employee;
    /**
     * The salesRole
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $salesRole;
    /**
     * The isPrimary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isPrimary;
    /**
     * The contribution
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $contribution;
    /**
     * Constructor method for ReturnAuthorizationSalesTeam
     * @uses ReturnAuthorizationSalesTeam::setEmployee()
     * @uses ReturnAuthorizationSalesTeam::setSalesRole()
     * @uses ReturnAuthorizationSalesTeam::setIsPrimary()
     * @uses ReturnAuthorizationSalesTeam::setContribution()
     * @param \StructType\RecordRef $employee
     * @param \StructType\RecordRef $salesRole
     * @param bool $isPrimary
     * @param float $contribution
     */
    public function __construct(\StructType\RecordRef $employee = null, \StructType\RecordRef $salesRole = null, $isPrimary = null, $contribution = null)
    {
        $this
            ->setEmployee($employee)
            ->setSalesRole($salesRole)
            ->setIsPrimary($isPrimary)
            ->setContribution($contribution);
    }
    /**
     * Get employee value
     * @return \StructType\RecordRef|null
     */
    public function getEmployee()
    {
        return $this->employee;
    }
    /**
     * Set employee value
     * @param \StructType\RecordRef $employee
     * @return \StructType\ReturnAuthorizationSalesTeam
     */
    public function setEmployee(\StructType\RecordRef $employee = null)
    {
        $this->employee = $employee;
        return $this;
    }
    /**
     * Get salesRole value
     * @return \StructType\RecordRef|null
     */
    public function getSalesRole()
    {
        return $this->salesRole;
    }
    /**
     * Set salesRole value
     * @param \StructType\RecordRef $salesRole
     * @return \StructType\ReturnAuthorizationSalesTeam
     */
    public function setSalesRole(\StructType\RecordRef $salesRole = null)
    {
        $this->salesRole = $salesRole;
        return $this;
    }
    /**
     * Get isPrimary value
     * @return bool|null
     */
    public function getIsPrimary()
    {
        return $this->isPrimary;
    }
    /**
     * Set isPrimary value
     * @param bool $isPrimary
     * @return \StructType\ReturnAuthorizationSalesTeam
     */
    public function setIsPrimary($isPrimary = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrimary) && !is_bool($isPrimary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPrimary, true), gettype($isPrimary)), __LINE__);
        }
        $this->isPrimary = $isPrimary;
        return $this;
    }
    /**
     * Get contribution value
     * @return float|null
     */
    public function getContribution()
    {
        return $this->contribution;
    }
    /**
     * Set contribution value
     * @param float $contribution
     * @return \StructType\ReturnAuthorizationSalesTeam
     */
    public function setContribution($contribution = null)
    {
        // validation for constraint: float
        if (!is_null($contribution) && !(is_float($contribution) || is_numeric($contribution))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($contribution, true), gettype($contribution)), __LINE__);
        }
        $this->contribution = $contribution;
        return $this;
    }
}
