<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RecordRefList StructType
 * @subpackage Structs
 */
class RecordRefList extends AbstractStructBase
{
    /**
     * The recordRef
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RecordRef[]
     */
    public $recordRef;
    /**
     * Constructor method for RecordRefList
     * @uses RecordRefList::setRecordRef()
     * @param \StructType\RecordRef[] $recordRef
     */
    public function __construct(array $recordRef = array())
    {
        $this
            ->setRecordRef($recordRef);
    }
    /**
     * Get recordRef value
     * @return \StructType\RecordRef[]|null
     */
    public function getRecordRef()
    {
        return $this->recordRef;
    }
    /**
     * This method is responsible for validating the values passed to the setRecordRef method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRecordRef method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRecordRefForArrayConstraintsFromSetRecordRef(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $recordRefListRecordRefItem) {
            // validation for constraint: itemType
            if (!$recordRefListRecordRefItem instanceof \StructType\RecordRef) {
                $invalidValues[] = is_object($recordRefListRecordRefItem) ? get_class($recordRefListRecordRefItem) : sprintf('%s(%s)', gettype($recordRefListRecordRefItem), var_export($recordRefListRecordRefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The recordRef property can only contain items of type \StructType\RecordRef, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set recordRef value
     * @throws \InvalidArgumentException
     * @param \StructType\RecordRef[] $recordRef
     * @return \StructType\RecordRefList
     */
    public function setRecordRef(array $recordRef = array())
    {
        // validation for constraint: array
        if ('' !== ($recordRefArrayErrorMessage = self::validateRecordRefForArrayConstraintsFromSetRecordRef($recordRef))) {
            throw new \InvalidArgumentException($recordRefArrayErrorMessage, __LINE__);
        }
        $this->recordRef = $recordRef;
        return $this;
    }
    /**
     * Add item to recordRef value
     * @throws \InvalidArgumentException
     * @param \StructType\RecordRef $item
     * @return \StructType\RecordRefList
     */
    public function addToRecordRef(\StructType\RecordRef $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RecordRef) {
            throw new \InvalidArgumentException(sprintf('The recordRef property can only contain items of type \StructType\RecordRef, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->recordRef[] = $item;
        return $this;
    }
}
