<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReadResponseList StructType
 * @subpackage Structs
 */
class ReadResponseList extends AbstractStructBase
{
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: platformCore:status
     * @var \StructType\Status
     */
    public $status;
    /**
     * The readResponse
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ReadResponse[]
     */
    public $readResponse;
    /**
     * Constructor method for ReadResponseList
     * @uses ReadResponseList::setStatus()
     * @uses ReadResponseList::setReadResponse()
     * @param \StructType\Status $status
     * @param \StructType\ReadResponse[] $readResponse
     */
    public function __construct(\StructType\Status $status = null, array $readResponse = array())
    {
        $this
            ->setStatus($status)
            ->setReadResponse($readResponse);
    }
    /**
     * Get status value
     * @return \StructType\Status|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param \StructType\Status $status
     * @return \StructType\ReadResponseList
     */
    public function setStatus(\StructType\Status $status = null)
    {
        $this->status = $status;
        return $this;
    }
    /**
     * Get readResponse value
     * @return \StructType\ReadResponse[]|null
     */
    public function getReadResponse()
    {
        return $this->readResponse;
    }
    /**
     * This method is responsible for validating the values passed to the setReadResponse method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReadResponse method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReadResponseForArrayConstraintsFromSetReadResponse(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $readResponseListReadResponseItem) {
            // validation for constraint: itemType
            if (!$readResponseListReadResponseItem instanceof \StructType\ReadResponse) {
                $invalidValues[] = is_object($readResponseListReadResponseItem) ? get_class($readResponseListReadResponseItem) : sprintf('%s(%s)', gettype($readResponseListReadResponseItem), var_export($readResponseListReadResponseItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The readResponse property can only contain items of type \StructType\ReadResponse, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set readResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\ReadResponse[] $readResponse
     * @return \StructType\ReadResponseList
     */
    public function setReadResponse(array $readResponse = array())
    {
        // validation for constraint: array
        if ('' !== ($readResponseArrayErrorMessage = self::validateReadResponseForArrayConstraintsFromSetReadResponse($readResponse))) {
            throw new \InvalidArgumentException($readResponseArrayErrorMessage, __LINE__);
        }
        $this->readResponse = $readResponse;
        return $this;
    }
    /**
     * Add item to readResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\ReadResponse $item
     * @return \StructType\ReadResponseList
     */
    public function addToReadResponse(\StructType\ReadResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ReadResponse) {
            throw new \InvalidArgumentException(sprintf('The readResponse property can only contain items of type \StructType\ReadResponse, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->readResponse[] = $item;
        return $this;
    }
}
