<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RateList StructType
 * @subpackage Structs
 */
class RateList extends AbstractStructBase
{
    /**
     * The rate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Rate[]
     */
    public $rate;
    /**
     * Constructor method for RateList
     * @uses RateList::setRate()
     * @param \StructType\Rate[] $rate
     */
    public function __construct(array $rate = array())
    {
        $this
            ->setRate($rate);
    }
    /**
     * Get rate value
     * @return \StructType\Rate[]|null
     */
    public function getRate()
    {
        return $this->rate;
    }
    /**
     * This method is responsible for validating the values passed to the setRate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRateForArrayConstraintsFromSetRate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rateListRateItem) {
            // validation for constraint: itemType
            if (!$rateListRateItem instanceof \StructType\Rate) {
                $invalidValues[] = is_object($rateListRateItem) ? get_class($rateListRateItem) : sprintf('%s(%s)', gettype($rateListRateItem), var_export($rateListRateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The rate property can only contain items of type \StructType\Rate, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set rate value
     * @throws \InvalidArgumentException
     * @param \StructType\Rate[] $rate
     * @return \StructType\RateList
     */
    public function setRate(array $rate = array())
    {
        // validation for constraint: array
        if ('' !== ($rateArrayErrorMessage = self::validateRateForArrayConstraintsFromSetRate($rate))) {
            throw new \InvalidArgumentException($rateArrayErrorMessage, __LINE__);
        }
        $this->rate = $rate;
        return $this;
    }
    /**
     * Add item to rate value
     * @throws \InvalidArgumentException
     * @param \StructType\Rate $item
     * @return \StructType\RateList
     */
    public function addToRate(\StructType\Rate $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Rate) {
            throw new \InvalidArgumentException(sprintf('The rate property can only contain items of type \StructType\Rate, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->rate[] = $item;
        return $this;
    }
}
