<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PurchaseRequisitionItemList StructType
 * @subpackage Structs
 */
class PurchaseRequisitionItemList extends AbstractStructBase
{
    /**
     * The purchaseRequisitionItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PurchaseRequisitionItem[]
     */
    public $purchaseRequisitionItem;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for PurchaseRequisitionItemList
     * @uses PurchaseRequisitionItemList::setPurchaseRequisitionItem()
     * @uses PurchaseRequisitionItemList::setReplaceAll()
     * @param \StructType\PurchaseRequisitionItem[] $purchaseRequisitionItem
     * @param bool $replaceAll
     */
    public function __construct(array $purchaseRequisitionItem = array(), $replaceAll = true)
    {
        $this
            ->setPurchaseRequisitionItem($purchaseRequisitionItem)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get purchaseRequisitionItem value
     * @return \StructType\PurchaseRequisitionItem[]|null
     */
    public function getPurchaseRequisitionItem()
    {
        return $this->purchaseRequisitionItem;
    }
    /**
     * This method is responsible for validating the values passed to the setPurchaseRequisitionItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPurchaseRequisitionItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePurchaseRequisitionItemForArrayConstraintsFromSetPurchaseRequisitionItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchaseRequisitionItemListPurchaseRequisitionItemItem) {
            // validation for constraint: itemType
            if (!$purchaseRequisitionItemListPurchaseRequisitionItemItem instanceof \StructType\PurchaseRequisitionItem) {
                $invalidValues[] = is_object($purchaseRequisitionItemListPurchaseRequisitionItemItem) ? get_class($purchaseRequisitionItemListPurchaseRequisitionItemItem) : sprintf('%s(%s)', gettype($purchaseRequisitionItemListPurchaseRequisitionItemItem), var_export($purchaseRequisitionItemListPurchaseRequisitionItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The purchaseRequisitionItem property can only contain items of type \StructType\PurchaseRequisitionItem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set purchaseRequisitionItem value
     * @throws \InvalidArgumentException
     * @param \StructType\PurchaseRequisitionItem[] $purchaseRequisitionItem
     * @return \StructType\PurchaseRequisitionItemList
     */
    public function setPurchaseRequisitionItem(array $purchaseRequisitionItem = array())
    {
        // validation for constraint: array
        if ('' !== ($purchaseRequisitionItemArrayErrorMessage = self::validatePurchaseRequisitionItemForArrayConstraintsFromSetPurchaseRequisitionItem($purchaseRequisitionItem))) {
            throw new \InvalidArgumentException($purchaseRequisitionItemArrayErrorMessage, __LINE__);
        }
        $this->purchaseRequisitionItem = $purchaseRequisitionItem;
        return $this;
    }
    /**
     * Add item to purchaseRequisitionItem value
     * @throws \InvalidArgumentException
     * @param \StructType\PurchaseRequisitionItem $item
     * @return \StructType\PurchaseRequisitionItemList
     */
    public function addToPurchaseRequisitionItem(\StructType\PurchaseRequisitionItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PurchaseRequisitionItem) {
            throw new \InvalidArgumentException(sprintf('The purchaseRequisitionItem property can only contain items of type \StructType\PurchaseRequisitionItem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->purchaseRequisitionItem[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\PurchaseRequisitionItemList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
