<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PurchaseRequisition StructType
 * @subpackage Structs
 */
class PurchaseRequisition extends Record
{
    /**
     * The createdDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $createdDate;
    /**
     * The lastModifiedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastModifiedDate;
    /**
     * The customForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customForm;
    /**
     * The source
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $source;
    /**
     * The subTotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $subTotal;
    /**
     * The currencyName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $currencyName;
    /**
     * The exchangeRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $exchangeRate;
    /**
     * The vatRegNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $vatRegNum;
    /**
     * The nexus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $nexus;
    /**
     * The taxRegNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $taxRegNum;
    /**
     * The taxRegOverride
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $taxRegOverride;
    /**
     * The estimatedTotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $estimatedTotal;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $currency;
    /**
     * The entity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $entity;
    /**
     * The dueDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dueDate;
    /**
     * The tranDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tranDate;
    /**
     * The tranId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tranId;
    /**
     * The memo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $memo;
    /**
     * The approvalStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $approvalStatus;
    /**
     * The nextApprover
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $nextApprover;
    /**
     * The taxTotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $taxTotal;
    /**
     * The tax2Total
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $tax2Total;
    /**
     * The subsidiary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $subsidiary;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The total
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $total;
    /**
     * The itemList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PurchaseRequisitionItemList
     */
    public $itemList;
    /**
     * The expenseList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PurchaseRequisitionExpenseList
     */
    public $expenseList;
    /**
     * The accountingBookDetailList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AccountingBookDetailList
     */
    public $accountingBookDetailList;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for PurchaseRequisition
     * @uses PurchaseRequisition::setCreatedDate()
     * @uses PurchaseRequisition::setLastModifiedDate()
     * @uses PurchaseRequisition::setCustomForm()
     * @uses PurchaseRequisition::setSource()
     * @uses PurchaseRequisition::setSubTotal()
     * @uses PurchaseRequisition::setCurrencyName()
     * @uses PurchaseRequisition::setExchangeRate()
     * @uses PurchaseRequisition::setVatRegNum()
     * @uses PurchaseRequisition::setNexus()
     * @uses PurchaseRequisition::setTaxRegNum()
     * @uses PurchaseRequisition::setTaxRegOverride()
     * @uses PurchaseRequisition::setEstimatedTotal()
     * @uses PurchaseRequisition::setStatus()
     * @uses PurchaseRequisition::setCurrency()
     * @uses PurchaseRequisition::setEntity()
     * @uses PurchaseRequisition::setDueDate()
     * @uses PurchaseRequisition::setTranDate()
     * @uses PurchaseRequisition::setTranId()
     * @uses PurchaseRequisition::setMemo()
     * @uses PurchaseRequisition::setApprovalStatus()
     * @uses PurchaseRequisition::setNextApprover()
     * @uses PurchaseRequisition::setTaxTotal()
     * @uses PurchaseRequisition::setTax2Total()
     * @uses PurchaseRequisition::setSubsidiary()
     * @uses PurchaseRequisition::setDepartment()
     * @uses PurchaseRequisition::setClass()
     * @uses PurchaseRequisition::setLocation()
     * @uses PurchaseRequisition::setTotal()
     * @uses PurchaseRequisition::setItemList()
     * @uses PurchaseRequisition::setExpenseList()
     * @uses PurchaseRequisition::setAccountingBookDetailList()
     * @uses PurchaseRequisition::setCustomFieldList()
     * @uses PurchaseRequisition::setInternalId()
     * @uses PurchaseRequisition::setExternalId()
     * @param string $createdDate
     * @param string $lastModifiedDate
     * @param \StructType\RecordRef $customForm
     * @param string $source
     * @param float $subTotal
     * @param string $currencyName
     * @param float $exchangeRate
     * @param string $vatRegNum
     * @param \StructType\RecordRef $nexus
     * @param \StructType\RecordRef $taxRegNum
     * @param bool $taxRegOverride
     * @param float $estimatedTotal
     * @param string $status
     * @param \StructType\RecordRef $currency
     * @param \StructType\RecordRef $entity
     * @param string $dueDate
     * @param string $tranDate
     * @param string $tranId
     * @param string $memo
     * @param \StructType\RecordRef $approvalStatus
     * @param \StructType\RecordRef $nextApprover
     * @param float $taxTotal
     * @param float $tax2Total
     * @param \StructType\RecordRef $subsidiary
     * @param \StructType\RecordRef $department
     * @param \StructType\RecordRef $class
     * @param \StructType\RecordRef $location
     * @param float $total
     * @param \StructType\PurchaseRequisitionItemList $itemList
     * @param \StructType\PurchaseRequisitionExpenseList $expenseList
     * @param \StructType\AccountingBookDetailList $accountingBookDetailList
     * @param \StructType\CustomFieldList $customFieldList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct($createdDate = null, $lastModifiedDate = null, \StructType\RecordRef $customForm = null, $source = null, $subTotal = null, $currencyName = null, $exchangeRate = null, $vatRegNum = null, \StructType\RecordRef $nexus = null, \StructType\RecordRef $taxRegNum = null, $taxRegOverride = null, $estimatedTotal = null, $status = null, \StructType\RecordRef $currency = null, \StructType\RecordRef $entity = null, $dueDate = null, $tranDate = null, $tranId = null, $memo = null, \StructType\RecordRef $approvalStatus = null, \StructType\RecordRef $nextApprover = null, $taxTotal = null, $tax2Total = null, \StructType\RecordRef $subsidiary = null, \StructType\RecordRef $department = null, \StructType\RecordRef $class = null, \StructType\RecordRef $location = null, $total = null, \StructType\PurchaseRequisitionItemList $itemList = null, \StructType\PurchaseRequisitionExpenseList $expenseList = null, \StructType\AccountingBookDetailList $accountingBookDetailList = null, \StructType\CustomFieldList $customFieldList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setCreatedDate($createdDate)
            ->setLastModifiedDate($lastModifiedDate)
            ->setCustomForm($customForm)
            ->setSource($source)
            ->setSubTotal($subTotal)
            ->setCurrencyName($currencyName)
            ->setExchangeRate($exchangeRate)
            ->setVatRegNum($vatRegNum)
            ->setNexus($nexus)
            ->setTaxRegNum($taxRegNum)
            ->setTaxRegOverride($taxRegOverride)
            ->setEstimatedTotal($estimatedTotal)
            ->setStatus($status)
            ->setCurrency($currency)
            ->setEntity($entity)
            ->setDueDate($dueDate)
            ->setTranDate($tranDate)
            ->setTranId($tranId)
            ->setMemo($memo)
            ->setApprovalStatus($approvalStatus)
            ->setNextApprover($nextApprover)
            ->setTaxTotal($taxTotal)
            ->setTax2Total($tax2Total)
            ->setSubsidiary($subsidiary)
            ->setDepartment($department)
            ->setClass($class)
            ->setLocation($location)
            ->setTotal($total)
            ->setItemList($itemList)
            ->setExpenseList($expenseList)
            ->setAccountingBookDetailList($accountingBookDetailList)
            ->setCustomFieldList($customFieldList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get createdDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->createdDate;
    }
    /**
     * Set createdDate value
     * @param string $createdDate
     * @return \StructType\PurchaseRequisition
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        $this->createdDate = $createdDate;
        return $this;
    }
    /**
     * Get lastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->lastModifiedDate;
    }
    /**
     * Set lastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\PurchaseRequisition
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->lastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get customForm value
     * @return \StructType\RecordRef|null
     */
    public function getCustomForm()
    {
        return $this->customForm;
    }
    /**
     * Set customForm value
     * @param \StructType\RecordRef $customForm
     * @return \StructType\PurchaseRequisition
     */
    public function setCustomForm(\StructType\RecordRef $customForm = null)
    {
        $this->customForm = $customForm;
        return $this;
    }
    /**
     * Get source value
     * @return string|null
     */
    public function getSource()
    {
        return $this->source;
    }
    /**
     * Set source value
     * @param string $source
     * @return \StructType\PurchaseRequisition
     */
    public function setSource($source = null)
    {
        // validation for constraint: string
        if (!is_null($source) && !is_string($source)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($source, true), gettype($source)), __LINE__);
        }
        $this->source = $source;
        return $this;
    }
    /**
     * Get subTotal value
     * @return float|null
     */
    public function getSubTotal()
    {
        return $this->subTotal;
    }
    /**
     * Set subTotal value
     * @param float $subTotal
     * @return \StructType\PurchaseRequisition
     */
    public function setSubTotal($subTotal = null)
    {
        // validation for constraint: float
        if (!is_null($subTotal) && !(is_float($subTotal) || is_numeric($subTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($subTotal, true), gettype($subTotal)), __LINE__);
        }
        $this->subTotal = $subTotal;
        return $this;
    }
    /**
     * Get currencyName value
     * @return string|null
     */
    public function getCurrencyName()
    {
        return $this->currencyName;
    }
    /**
     * Set currencyName value
     * @param string $currencyName
     * @return \StructType\PurchaseRequisition
     */
    public function setCurrencyName($currencyName = null)
    {
        // validation for constraint: string
        if (!is_null($currencyName) && !is_string($currencyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyName, true), gettype($currencyName)), __LINE__);
        }
        $this->currencyName = $currencyName;
        return $this;
    }
    /**
     * Get exchangeRate value
     * @return float|null
     */
    public function getExchangeRate()
    {
        return $this->exchangeRate;
    }
    /**
     * Set exchangeRate value
     * @param float $exchangeRate
     * @return \StructType\PurchaseRequisition
     */
    public function setExchangeRate($exchangeRate = null)
    {
        // validation for constraint: float
        if (!is_null($exchangeRate) && !(is_float($exchangeRate) || is_numeric($exchangeRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($exchangeRate, true), gettype($exchangeRate)), __LINE__);
        }
        $this->exchangeRate = $exchangeRate;
        return $this;
    }
    /**
     * Get vatRegNum value
     * @return string|null
     */
    public function getVatRegNum()
    {
        return $this->vatRegNum;
    }
    /**
     * Set vatRegNum value
     * @param string $vatRegNum
     * @return \StructType\PurchaseRequisition
     */
    public function setVatRegNum($vatRegNum = null)
    {
        // validation for constraint: string
        if (!is_null($vatRegNum) && !is_string($vatRegNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vatRegNum, true), gettype($vatRegNum)), __LINE__);
        }
        $this->vatRegNum = $vatRegNum;
        return $this;
    }
    /**
     * Get nexus value
     * @return \StructType\RecordRef|null
     */
    public function getNexus()
    {
        return $this->nexus;
    }
    /**
     * Set nexus value
     * @param \StructType\RecordRef $nexus
     * @return \StructType\PurchaseRequisition
     */
    public function setNexus(\StructType\RecordRef $nexus = null)
    {
        $this->nexus = $nexus;
        return $this;
    }
    /**
     * Get taxRegNum value
     * @return \StructType\RecordRef|null
     */
    public function getTaxRegNum()
    {
        return $this->taxRegNum;
    }
    /**
     * Set taxRegNum value
     * @param \StructType\RecordRef $taxRegNum
     * @return \StructType\PurchaseRequisition
     */
    public function setTaxRegNum(\StructType\RecordRef $taxRegNum = null)
    {
        $this->taxRegNum = $taxRegNum;
        return $this;
    }
    /**
     * Get taxRegOverride value
     * @return bool|null
     */
    public function getTaxRegOverride()
    {
        return $this->taxRegOverride;
    }
    /**
     * Set taxRegOverride value
     * @param bool $taxRegOverride
     * @return \StructType\PurchaseRequisition
     */
    public function setTaxRegOverride($taxRegOverride = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxRegOverride) && !is_bool($taxRegOverride)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxRegOverride, true), gettype($taxRegOverride)), __LINE__);
        }
        $this->taxRegOverride = $taxRegOverride;
        return $this;
    }
    /**
     * Get estimatedTotal value
     * @return float|null
     */
    public function getEstimatedTotal()
    {
        return $this->estimatedTotal;
    }
    /**
     * Set estimatedTotal value
     * @param float $estimatedTotal
     * @return \StructType\PurchaseRequisition
     */
    public function setEstimatedTotal($estimatedTotal = null)
    {
        // validation for constraint: float
        if (!is_null($estimatedTotal) && !(is_float($estimatedTotal) || is_numeric($estimatedTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($estimatedTotal, true), gettype($estimatedTotal)), __LINE__);
        }
        $this->estimatedTotal = $estimatedTotal;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\PurchaseRequisition
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get currency value
     * @return \StructType\RecordRef|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param \StructType\RecordRef $currency
     * @return \StructType\PurchaseRequisition
     */
    public function setCurrency(\StructType\RecordRef $currency = null)
    {
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get entity value
     * @return \StructType\RecordRef|null
     */
    public function getEntity()
    {
        return $this->entity;
    }
    /**
     * Set entity value
     * @param \StructType\RecordRef $entity
     * @return \StructType\PurchaseRequisition
     */
    public function setEntity(\StructType\RecordRef $entity = null)
    {
        $this->entity = $entity;
        return $this;
    }
    /**
     * Get dueDate value
     * @return string|null
     */
    public function getDueDate()
    {
        return $this->dueDate;
    }
    /**
     * Set dueDate value
     * @param string $dueDate
     * @return \StructType\PurchaseRequisition
     */
    public function setDueDate($dueDate = null)
    {
        // validation for constraint: string
        if (!is_null($dueDate) && !is_string($dueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dueDate, true), gettype($dueDate)), __LINE__);
        }
        $this->dueDate = $dueDate;
        return $this;
    }
    /**
     * Get tranDate value
     * @return string|null
     */
    public function getTranDate()
    {
        return $this->tranDate;
    }
    /**
     * Set tranDate value
     * @param string $tranDate
     * @return \StructType\PurchaseRequisition
     */
    public function setTranDate($tranDate = null)
    {
        // validation for constraint: string
        if (!is_null($tranDate) && !is_string($tranDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tranDate, true), gettype($tranDate)), __LINE__);
        }
        $this->tranDate = $tranDate;
        return $this;
    }
    /**
     * Get tranId value
     * @return string|null
     */
    public function getTranId()
    {
        return $this->tranId;
    }
    /**
     * Set tranId value
     * @param string $tranId
     * @return \StructType\PurchaseRequisition
     */
    public function setTranId($tranId = null)
    {
        // validation for constraint: string
        if (!is_null($tranId) && !is_string($tranId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tranId, true), gettype($tranId)), __LINE__);
        }
        $this->tranId = $tranId;
        return $this;
    }
    /**
     * Get memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->memo;
    }
    /**
     * Set memo value
     * @param string $memo
     * @return \StructType\PurchaseRequisition
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->memo = $memo;
        return $this;
    }
    /**
     * Get approvalStatus value
     * @return \StructType\RecordRef|null
     */
    public function getApprovalStatus()
    {
        return $this->approvalStatus;
    }
    /**
     * Set approvalStatus value
     * @param \StructType\RecordRef $approvalStatus
     * @return \StructType\PurchaseRequisition
     */
    public function setApprovalStatus(\StructType\RecordRef $approvalStatus = null)
    {
        $this->approvalStatus = $approvalStatus;
        return $this;
    }
    /**
     * Get nextApprover value
     * @return \StructType\RecordRef|null
     */
    public function getNextApprover()
    {
        return $this->nextApprover;
    }
    /**
     * Set nextApprover value
     * @param \StructType\RecordRef $nextApprover
     * @return \StructType\PurchaseRequisition
     */
    public function setNextApprover(\StructType\RecordRef $nextApprover = null)
    {
        $this->nextApprover = $nextApprover;
        return $this;
    }
    /**
     * Get taxTotal value
     * @return float|null
     */
    public function getTaxTotal()
    {
        return $this->taxTotal;
    }
    /**
     * Set taxTotal value
     * @param float $taxTotal
     * @return \StructType\PurchaseRequisition
     */
    public function setTaxTotal($taxTotal = null)
    {
        // validation for constraint: float
        if (!is_null($taxTotal) && !(is_float($taxTotal) || is_numeric($taxTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxTotal, true), gettype($taxTotal)), __LINE__);
        }
        $this->taxTotal = $taxTotal;
        return $this;
    }
    /**
     * Get tax2Total value
     * @return float|null
     */
    public function getTax2Total()
    {
        return $this->tax2Total;
    }
    /**
     * Set tax2Total value
     * @param float $tax2Total
     * @return \StructType\PurchaseRequisition
     */
    public function setTax2Total($tax2Total = null)
    {
        // validation for constraint: float
        if (!is_null($tax2Total) && !(is_float($tax2Total) || is_numeric($tax2Total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tax2Total, true), gettype($tax2Total)), __LINE__);
        }
        $this->tax2Total = $tax2Total;
        return $this;
    }
    /**
     * Get subsidiary value
     * @return \StructType\RecordRef|null
     */
    public function getSubsidiary()
    {
        return $this->subsidiary;
    }
    /**
     * Set subsidiary value
     * @param \StructType\RecordRef $subsidiary
     * @return \StructType\PurchaseRequisition
     */
    public function setSubsidiary(\StructType\RecordRef $subsidiary = null)
    {
        $this->subsidiary = $subsidiary;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\PurchaseRequisition
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\PurchaseRequisition
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\PurchaseRequisition
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get total value
     * @return float|null
     */
    public function getTotal()
    {
        return $this->total;
    }
    /**
     * Set total value
     * @param float $total
     * @return \StructType\PurchaseRequisition
     */
    public function setTotal($total = null)
    {
        // validation for constraint: float
        if (!is_null($total) && !(is_float($total) || is_numeric($total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($total, true), gettype($total)), __LINE__);
        }
        $this->total = $total;
        return $this;
    }
    /**
     * Get itemList value
     * @return \StructType\PurchaseRequisitionItemList|null
     */
    public function getItemList()
    {
        return $this->itemList;
    }
    /**
     * Set itemList value
     * @param \StructType\PurchaseRequisitionItemList $itemList
     * @return \StructType\PurchaseRequisition
     */
    public function setItemList(\StructType\PurchaseRequisitionItemList $itemList = null)
    {
        $this->itemList = $itemList;
        return $this;
    }
    /**
     * Get expenseList value
     * @return \StructType\PurchaseRequisitionExpenseList|null
     */
    public function getExpenseList()
    {
        return $this->expenseList;
    }
    /**
     * Set expenseList value
     * @param \StructType\PurchaseRequisitionExpenseList $expenseList
     * @return \StructType\PurchaseRequisition
     */
    public function setExpenseList(\StructType\PurchaseRequisitionExpenseList $expenseList = null)
    {
        $this->expenseList = $expenseList;
        return $this;
    }
    /**
     * Get accountingBookDetailList value
     * @return \StructType\AccountingBookDetailList|null
     */
    public function getAccountingBookDetailList()
    {
        return $this->accountingBookDetailList;
    }
    /**
     * Set accountingBookDetailList value
     * @param \StructType\AccountingBookDetailList $accountingBookDetailList
     * @return \StructType\PurchaseRequisition
     */
    public function setAccountingBookDetailList(\StructType\AccountingBookDetailList $accountingBookDetailList = null)
    {
        $this->accountingBookDetailList = $accountingBookDetailList;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\PurchaseRequisition
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\PurchaseRequisition
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\PurchaseRequisition
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
