<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PurchaseOrder StructType
 * Meta information extracted from the WSDL
 * - type: tranPurch:PurchaseOrder
 * @subpackage Structs
 */
class PurchaseOrder extends Record
{
    /**
     * The createdDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $createdDate;
    /**
     * The lastModifiedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastModifiedDate;
    /**
     * The nexus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $nexus;
    /**
     * The subsidiaryTaxRegNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $subsidiaryTaxRegNum;
    /**
     * The taxRegOverride
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $taxRegOverride;
    /**
     * The taxDetailsOverride
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $taxDetailsOverride;
    /**
     * The customForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customForm;
    /**
     * The entity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $entity;
    /**
     * The purchaseContract
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $purchaseContract;
    /**
     * The vatRegNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $vatRegNum;
    /**
     * The employee
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $employee;
    /**
     * The supervisorApproval
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $supervisorApproval;
    /**
     * The tranDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tranDate;
    /**
     * The tranId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tranId;
    /**
     * The entityTaxRegNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $entityTaxRegNum;
    /**
     * The taxPointDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $taxPointDate;
    /**
     * The createdFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $createdFrom;
    /**
     * The terms
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $terms;
    /**
     * The dueDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dueDate;
    /**
     * The otherRefNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $otherRefNum;
    /**
     * The availableVendorCredit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $availableVendorCredit;
    /**
     * The memo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $memo;
    /**
     * The approvalStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $approvalStatus;
    /**
     * The exchangeRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $exchangeRate;
    /**
     * The nextApprover
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $nextApprover;
    /**
     * The source
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $source;
    /**
     * The currencyName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $currencyName;
    /**
     * The toBePrinted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $toBePrinted;
    /**
     * The toBeEmailed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $toBeEmailed;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $email;
    /**
     * The toBeFaxed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $toBeFaxed;
    /**
     * The fax
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fax;
    /**
     * The message
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $message;
    /**
     * The billingAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Address
     */
    public $billingAddress;
    /**
     * The billAddressList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $billAddressList;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $currency;
    /**
     * The shipTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $shipTo;
    /**
     * The subTotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $subTotal;
    /**
     * The taxTotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $taxTotal;
    /**
     * The tax2Total
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $tax2Total;
    /**
     * The shippingAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Address
     */
    public $shippingAddress;
    /**
     * The shipIsResidential
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $shipIsResidential;
    /**
     * The shipAddressList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $shipAddressList;
    /**
     * The fob
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fob;
    /**
     * The shipDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shipDate;
    /**
     * The shipMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $shipMethod;
    /**
     * The incoterm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $incoterm;
    /**
     * The trackingNumbers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $trackingNumbers;
    /**
     * The linkedTrackingNumbers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $linkedTrackingNumbers;
    /**
     * The total
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $total;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The subsidiary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $subsidiary;
    /**
     * The intercoTransaction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $intercoTransaction;
    /**
     * The intercoStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $intercoStatus;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The orderStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $orderStatus;
    /**
     * The itemList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PurchaseOrderItemList
     */
    public $itemList;
    /**
     * The accountingBookDetailList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AccountingBookDetailList
     */
    public $accountingBookDetailList;
    /**
     * The expenseList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PurchaseOrderExpenseList
     */
    public $expenseList;
    /**
     * The taxDetailsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TaxDetailsList
     */
    public $taxDetailsList;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for PurchaseOrder
     * @uses PurchaseOrder::setCreatedDate()
     * @uses PurchaseOrder::setLastModifiedDate()
     * @uses PurchaseOrder::setNexus()
     * @uses PurchaseOrder::setSubsidiaryTaxRegNum()
     * @uses PurchaseOrder::setTaxRegOverride()
     * @uses PurchaseOrder::setTaxDetailsOverride()
     * @uses PurchaseOrder::setCustomForm()
     * @uses PurchaseOrder::setEntity()
     * @uses PurchaseOrder::setPurchaseContract()
     * @uses PurchaseOrder::setVatRegNum()
     * @uses PurchaseOrder::setEmployee()
     * @uses PurchaseOrder::setSupervisorApproval()
     * @uses PurchaseOrder::setTranDate()
     * @uses PurchaseOrder::setTranId()
     * @uses PurchaseOrder::setEntityTaxRegNum()
     * @uses PurchaseOrder::setTaxPointDate()
     * @uses PurchaseOrder::setCreatedFrom()
     * @uses PurchaseOrder::setTerms()
     * @uses PurchaseOrder::setDueDate()
     * @uses PurchaseOrder::setOtherRefNum()
     * @uses PurchaseOrder::setAvailableVendorCredit()
     * @uses PurchaseOrder::setMemo()
     * @uses PurchaseOrder::setApprovalStatus()
     * @uses PurchaseOrder::setExchangeRate()
     * @uses PurchaseOrder::setNextApprover()
     * @uses PurchaseOrder::setSource()
     * @uses PurchaseOrder::setCurrencyName()
     * @uses PurchaseOrder::setToBePrinted()
     * @uses PurchaseOrder::setToBeEmailed()
     * @uses PurchaseOrder::setEmail()
     * @uses PurchaseOrder::setToBeFaxed()
     * @uses PurchaseOrder::setFax()
     * @uses PurchaseOrder::setMessage()
     * @uses PurchaseOrder::setBillingAddress()
     * @uses PurchaseOrder::setBillAddressList()
     * @uses PurchaseOrder::setCurrency()
     * @uses PurchaseOrder::setShipTo()
     * @uses PurchaseOrder::setSubTotal()
     * @uses PurchaseOrder::setTaxTotal()
     * @uses PurchaseOrder::setTax2Total()
     * @uses PurchaseOrder::setShippingAddress()
     * @uses PurchaseOrder::setShipIsResidential()
     * @uses PurchaseOrder::setShipAddressList()
     * @uses PurchaseOrder::setFob()
     * @uses PurchaseOrder::setShipDate()
     * @uses PurchaseOrder::setShipMethod()
     * @uses PurchaseOrder::setIncoterm()
     * @uses PurchaseOrder::setTrackingNumbers()
     * @uses PurchaseOrder::setLinkedTrackingNumbers()
     * @uses PurchaseOrder::setTotal()
     * @uses PurchaseOrder::setClass()
     * @uses PurchaseOrder::setDepartment()
     * @uses PurchaseOrder::setLocation()
     * @uses PurchaseOrder::setSubsidiary()
     * @uses PurchaseOrder::setIntercoTransaction()
     * @uses PurchaseOrder::setIntercoStatus()
     * @uses PurchaseOrder::setStatus()
     * @uses PurchaseOrder::setOrderStatus()
     * @uses PurchaseOrder::setItemList()
     * @uses PurchaseOrder::setAccountingBookDetailList()
     * @uses PurchaseOrder::setExpenseList()
     * @uses PurchaseOrder::setTaxDetailsList()
     * @uses PurchaseOrder::setCustomFieldList()
     * @uses PurchaseOrder::setInternalId()
     * @uses PurchaseOrder::setExternalId()
     * @param string $createdDate
     * @param string $lastModifiedDate
     * @param \StructType\RecordRef $nexus
     * @param \StructType\RecordRef $subsidiaryTaxRegNum
     * @param bool $taxRegOverride
     * @param bool $taxDetailsOverride
     * @param \StructType\RecordRef $customForm
     * @param \StructType\RecordRef $entity
     * @param \StructType\RecordRef $purchaseContract
     * @param string $vatRegNum
     * @param \StructType\RecordRef $employee
     * @param bool $supervisorApproval
     * @param string $tranDate
     * @param string $tranId
     * @param \StructType\RecordRef $entityTaxRegNum
     * @param string $taxPointDate
     * @param \StructType\RecordRef $createdFrom
     * @param \StructType\RecordRef $terms
     * @param string $dueDate
     * @param string $otherRefNum
     * @param float $availableVendorCredit
     * @param string $memo
     * @param \StructType\RecordRef $approvalStatus
     * @param float $exchangeRate
     * @param \StructType\RecordRef $nextApprover
     * @param string $source
     * @param string $currencyName
     * @param bool $toBePrinted
     * @param bool $toBeEmailed
     * @param string $email
     * @param bool $toBeFaxed
     * @param string $fax
     * @param string $message
     * @param \StructType\Address $billingAddress
     * @param \StructType\RecordRef $billAddressList
     * @param \StructType\RecordRef $currency
     * @param \StructType\RecordRef $shipTo
     * @param float $subTotal
     * @param float $taxTotal
     * @param float $tax2Total
     * @param \StructType\Address $shippingAddress
     * @param bool $shipIsResidential
     * @param \StructType\RecordRef $shipAddressList
     * @param string $fob
     * @param string $shipDate
     * @param \StructType\RecordRef $shipMethod
     * @param \StructType\RecordRef $incoterm
     * @param string $trackingNumbers
     * @param string $linkedTrackingNumbers
     * @param float $total
     * @param \StructType\RecordRef $class
     * @param \StructType\RecordRef $department
     * @param \StructType\RecordRef $location
     * @param \StructType\RecordRef $subsidiary
     * @param \StructType\RecordRef $intercoTransaction
     * @param string $intercoStatus
     * @param string $status
     * @param string $orderStatus
     * @param \StructType\PurchaseOrderItemList $itemList
     * @param \StructType\AccountingBookDetailList $accountingBookDetailList
     * @param \StructType\PurchaseOrderExpenseList $expenseList
     * @param \StructType\TaxDetailsList $taxDetailsList
     * @param \StructType\CustomFieldList $customFieldList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct($createdDate = null, $lastModifiedDate = null, \StructType\RecordRef $nexus = null, \StructType\RecordRef $subsidiaryTaxRegNum = null, $taxRegOverride = null, $taxDetailsOverride = null, \StructType\RecordRef $customForm = null, \StructType\RecordRef $entity = null, \StructType\RecordRef $purchaseContract = null, $vatRegNum = null, \StructType\RecordRef $employee = null, $supervisorApproval = null, $tranDate = null, $tranId = null, \StructType\RecordRef $entityTaxRegNum = null, $taxPointDate = null, \StructType\RecordRef $createdFrom = null, \StructType\RecordRef $terms = null, $dueDate = null, $otherRefNum = null, $availableVendorCredit = null, $memo = null, \StructType\RecordRef $approvalStatus = null, $exchangeRate = null, \StructType\RecordRef $nextApprover = null, $source = null, $currencyName = null, $toBePrinted = null, $toBeEmailed = null, $email = null, $toBeFaxed = null, $fax = null, $message = null, \StructType\Address $billingAddress = null, \StructType\RecordRef $billAddressList = null, \StructType\RecordRef $currency = null, \StructType\RecordRef $shipTo = null, $subTotal = null, $taxTotal = null, $tax2Total = null, \StructType\Address $shippingAddress = null, $shipIsResidential = null, \StructType\RecordRef $shipAddressList = null, $fob = null, $shipDate = null, \StructType\RecordRef $shipMethod = null, \StructType\RecordRef $incoterm = null, $trackingNumbers = null, $linkedTrackingNumbers = null, $total = null, \StructType\RecordRef $class = null, \StructType\RecordRef $department = null, \StructType\RecordRef $location = null, \StructType\RecordRef $subsidiary = null, \StructType\RecordRef $intercoTransaction = null, $intercoStatus = null, $status = null, $orderStatus = null, \StructType\PurchaseOrderItemList $itemList = null, \StructType\AccountingBookDetailList $accountingBookDetailList = null, \StructType\PurchaseOrderExpenseList $expenseList = null, \StructType\TaxDetailsList $taxDetailsList = null, \StructType\CustomFieldList $customFieldList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setCreatedDate($createdDate)
            ->setLastModifiedDate($lastModifiedDate)
            ->setNexus($nexus)
            ->setSubsidiaryTaxRegNum($subsidiaryTaxRegNum)
            ->setTaxRegOverride($taxRegOverride)
            ->setTaxDetailsOverride($taxDetailsOverride)
            ->setCustomForm($customForm)
            ->setEntity($entity)
            ->setPurchaseContract($purchaseContract)
            ->setVatRegNum($vatRegNum)
            ->setEmployee($employee)
            ->setSupervisorApproval($supervisorApproval)
            ->setTranDate($tranDate)
            ->setTranId($tranId)
            ->setEntityTaxRegNum($entityTaxRegNum)
            ->setTaxPointDate($taxPointDate)
            ->setCreatedFrom($createdFrom)
            ->setTerms($terms)
            ->setDueDate($dueDate)
            ->setOtherRefNum($otherRefNum)
            ->setAvailableVendorCredit($availableVendorCredit)
            ->setMemo($memo)
            ->setApprovalStatus($approvalStatus)
            ->setExchangeRate($exchangeRate)
            ->setNextApprover($nextApprover)
            ->setSource($source)
            ->setCurrencyName($currencyName)
            ->setToBePrinted($toBePrinted)
            ->setToBeEmailed($toBeEmailed)
            ->setEmail($email)
            ->setToBeFaxed($toBeFaxed)
            ->setFax($fax)
            ->setMessage($message)
            ->setBillingAddress($billingAddress)
            ->setBillAddressList($billAddressList)
            ->setCurrency($currency)
            ->setShipTo($shipTo)
            ->setSubTotal($subTotal)
            ->setTaxTotal($taxTotal)
            ->setTax2Total($tax2Total)
            ->setShippingAddress($shippingAddress)
            ->setShipIsResidential($shipIsResidential)
            ->setShipAddressList($shipAddressList)
            ->setFob($fob)
            ->setShipDate($shipDate)
            ->setShipMethod($shipMethod)
            ->setIncoterm($incoterm)
            ->setTrackingNumbers($trackingNumbers)
            ->setLinkedTrackingNumbers($linkedTrackingNumbers)
            ->setTotal($total)
            ->setClass($class)
            ->setDepartment($department)
            ->setLocation($location)
            ->setSubsidiary($subsidiary)
            ->setIntercoTransaction($intercoTransaction)
            ->setIntercoStatus($intercoStatus)
            ->setStatus($status)
            ->setOrderStatus($orderStatus)
            ->setItemList($itemList)
            ->setAccountingBookDetailList($accountingBookDetailList)
            ->setExpenseList($expenseList)
            ->setTaxDetailsList($taxDetailsList)
            ->setCustomFieldList($customFieldList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get createdDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->createdDate;
    }
    /**
     * Set createdDate value
     * @param string $createdDate
     * @return \StructType\PurchaseOrder
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        $this->createdDate = $createdDate;
        return $this;
    }
    /**
     * Get lastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->lastModifiedDate;
    }
    /**
     * Set lastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\PurchaseOrder
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->lastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get nexus value
     * @return \StructType\RecordRef|null
     */
    public function getNexus()
    {
        return $this->nexus;
    }
    /**
     * Set nexus value
     * @param \StructType\RecordRef $nexus
     * @return \StructType\PurchaseOrder
     */
    public function setNexus(\StructType\RecordRef $nexus = null)
    {
        $this->nexus = $nexus;
        return $this;
    }
    /**
     * Get subsidiaryTaxRegNum value
     * @return \StructType\RecordRef|null
     */
    public function getSubsidiaryTaxRegNum()
    {
        return $this->subsidiaryTaxRegNum;
    }
    /**
     * Set subsidiaryTaxRegNum value
     * @param \StructType\RecordRef $subsidiaryTaxRegNum
     * @return \StructType\PurchaseOrder
     */
    public function setSubsidiaryTaxRegNum(\StructType\RecordRef $subsidiaryTaxRegNum = null)
    {
        $this->subsidiaryTaxRegNum = $subsidiaryTaxRegNum;
        return $this;
    }
    /**
     * Get taxRegOverride value
     * @return bool|null
     */
    public function getTaxRegOverride()
    {
        return $this->taxRegOverride;
    }
    /**
     * Set taxRegOverride value
     * @param bool $taxRegOverride
     * @return \StructType\PurchaseOrder
     */
    public function setTaxRegOverride($taxRegOverride = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxRegOverride) && !is_bool($taxRegOverride)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxRegOverride, true), gettype($taxRegOverride)), __LINE__);
        }
        $this->taxRegOverride = $taxRegOverride;
        return $this;
    }
    /**
     * Get taxDetailsOverride value
     * @return bool|null
     */
    public function getTaxDetailsOverride()
    {
        return $this->taxDetailsOverride;
    }
    /**
     * Set taxDetailsOverride value
     * @param bool $taxDetailsOverride
     * @return \StructType\PurchaseOrder
     */
    public function setTaxDetailsOverride($taxDetailsOverride = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxDetailsOverride) && !is_bool($taxDetailsOverride)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxDetailsOverride, true), gettype($taxDetailsOverride)), __LINE__);
        }
        $this->taxDetailsOverride = $taxDetailsOverride;
        return $this;
    }
    /**
     * Get customForm value
     * @return \StructType\RecordRef|null
     */
    public function getCustomForm()
    {
        return $this->customForm;
    }
    /**
     * Set customForm value
     * @param \StructType\RecordRef $customForm
     * @return \StructType\PurchaseOrder
     */
    public function setCustomForm(\StructType\RecordRef $customForm = null)
    {
        $this->customForm = $customForm;
        return $this;
    }
    /**
     * Get entity value
     * @return \StructType\RecordRef|null
     */
    public function getEntity()
    {
        return $this->entity;
    }
    /**
     * Set entity value
     * @param \StructType\RecordRef $entity
     * @return \StructType\PurchaseOrder
     */
    public function setEntity(\StructType\RecordRef $entity = null)
    {
        $this->entity = $entity;
        return $this;
    }
    /**
     * Get purchaseContract value
     * @return \StructType\RecordRef|null
     */
    public function getPurchaseContract()
    {
        return $this->purchaseContract;
    }
    /**
     * Set purchaseContract value
     * @param \StructType\RecordRef $purchaseContract
     * @return \StructType\PurchaseOrder
     */
    public function setPurchaseContract(\StructType\RecordRef $purchaseContract = null)
    {
        $this->purchaseContract = $purchaseContract;
        return $this;
    }
    /**
     * Get vatRegNum value
     * @return string|null
     */
    public function getVatRegNum()
    {
        return $this->vatRegNum;
    }
    /**
     * Set vatRegNum value
     * @param string $vatRegNum
     * @return \StructType\PurchaseOrder
     */
    public function setVatRegNum($vatRegNum = null)
    {
        // validation for constraint: string
        if (!is_null($vatRegNum) && !is_string($vatRegNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vatRegNum, true), gettype($vatRegNum)), __LINE__);
        }
        $this->vatRegNum = $vatRegNum;
        return $this;
    }
    /**
     * Get employee value
     * @return \StructType\RecordRef|null
     */
    public function getEmployee()
    {
        return $this->employee;
    }
    /**
     * Set employee value
     * @param \StructType\RecordRef $employee
     * @return \StructType\PurchaseOrder
     */
    public function setEmployee(\StructType\RecordRef $employee = null)
    {
        $this->employee = $employee;
        return $this;
    }
    /**
     * Get supervisorApproval value
     * @return bool|null
     */
    public function getSupervisorApproval()
    {
        return $this->supervisorApproval;
    }
    /**
     * Set supervisorApproval value
     * @param bool $supervisorApproval
     * @return \StructType\PurchaseOrder
     */
    public function setSupervisorApproval($supervisorApproval = null)
    {
        // validation for constraint: boolean
        if (!is_null($supervisorApproval) && !is_bool($supervisorApproval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($supervisorApproval, true), gettype($supervisorApproval)), __LINE__);
        }
        $this->supervisorApproval = $supervisorApproval;
        return $this;
    }
    /**
     * Get tranDate value
     * @return string|null
     */
    public function getTranDate()
    {
        return $this->tranDate;
    }
    /**
     * Set tranDate value
     * @param string $tranDate
     * @return \StructType\PurchaseOrder
     */
    public function setTranDate($tranDate = null)
    {
        // validation for constraint: string
        if (!is_null($tranDate) && !is_string($tranDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tranDate, true), gettype($tranDate)), __LINE__);
        }
        $this->tranDate = $tranDate;
        return $this;
    }
    /**
     * Get tranId value
     * @return string|null
     */
    public function getTranId()
    {
        return $this->tranId;
    }
    /**
     * Set tranId value
     * @param string $tranId
     * @return \StructType\PurchaseOrder
     */
    public function setTranId($tranId = null)
    {
        // validation for constraint: string
        if (!is_null($tranId) && !is_string($tranId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tranId, true), gettype($tranId)), __LINE__);
        }
        $this->tranId = $tranId;
        return $this;
    }
    /**
     * Get entityTaxRegNum value
     * @return \StructType\RecordRef|null
     */
    public function getEntityTaxRegNum()
    {
        return $this->entityTaxRegNum;
    }
    /**
     * Set entityTaxRegNum value
     * @param \StructType\RecordRef $entityTaxRegNum
     * @return \StructType\PurchaseOrder
     */
    public function setEntityTaxRegNum(\StructType\RecordRef $entityTaxRegNum = null)
    {
        $this->entityTaxRegNum = $entityTaxRegNum;
        return $this;
    }
    /**
     * Get taxPointDate value
     * @return string|null
     */
    public function getTaxPointDate()
    {
        return $this->taxPointDate;
    }
    /**
     * Set taxPointDate value
     * @param string $taxPointDate
     * @return \StructType\PurchaseOrder
     */
    public function setTaxPointDate($taxPointDate = null)
    {
        // validation for constraint: string
        if (!is_null($taxPointDate) && !is_string($taxPointDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxPointDate, true), gettype($taxPointDate)), __LINE__);
        }
        $this->taxPointDate = $taxPointDate;
        return $this;
    }
    /**
     * Get createdFrom value
     * @return \StructType\RecordRef|null
     */
    public function getCreatedFrom()
    {
        return $this->createdFrom;
    }
    /**
     * Set createdFrom value
     * @param \StructType\RecordRef $createdFrom
     * @return \StructType\PurchaseOrder
     */
    public function setCreatedFrom(\StructType\RecordRef $createdFrom = null)
    {
        $this->createdFrom = $createdFrom;
        return $this;
    }
    /**
     * Get terms value
     * @return \StructType\RecordRef|null
     */
    public function getTerms()
    {
        return $this->terms;
    }
    /**
     * Set terms value
     * @param \StructType\RecordRef $terms
     * @return \StructType\PurchaseOrder
     */
    public function setTerms(\StructType\RecordRef $terms = null)
    {
        $this->terms = $terms;
        return $this;
    }
    /**
     * Get dueDate value
     * @return string|null
     */
    public function getDueDate()
    {
        return $this->dueDate;
    }
    /**
     * Set dueDate value
     * @param string $dueDate
     * @return \StructType\PurchaseOrder
     */
    public function setDueDate($dueDate = null)
    {
        // validation for constraint: string
        if (!is_null($dueDate) && !is_string($dueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dueDate, true), gettype($dueDate)), __LINE__);
        }
        $this->dueDate = $dueDate;
        return $this;
    }
    /**
     * Get otherRefNum value
     * @return string|null
     */
    public function getOtherRefNum()
    {
        return $this->otherRefNum;
    }
    /**
     * Set otherRefNum value
     * @param string $otherRefNum
     * @return \StructType\PurchaseOrder
     */
    public function setOtherRefNum($otherRefNum = null)
    {
        // validation for constraint: string
        if (!is_null($otherRefNum) && !is_string($otherRefNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($otherRefNum, true), gettype($otherRefNum)), __LINE__);
        }
        $this->otherRefNum = $otherRefNum;
        return $this;
    }
    /**
     * Get availableVendorCredit value
     * @return float|null
     */
    public function getAvailableVendorCredit()
    {
        return $this->availableVendorCredit;
    }
    /**
     * Set availableVendorCredit value
     * @param float $availableVendorCredit
     * @return \StructType\PurchaseOrder
     */
    public function setAvailableVendorCredit($availableVendorCredit = null)
    {
        // validation for constraint: float
        if (!is_null($availableVendorCredit) && !(is_float($availableVendorCredit) || is_numeric($availableVendorCredit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($availableVendorCredit, true), gettype($availableVendorCredit)), __LINE__);
        }
        $this->availableVendorCredit = $availableVendorCredit;
        return $this;
    }
    /**
     * Get memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->memo;
    }
    /**
     * Set memo value
     * @param string $memo
     * @return \StructType\PurchaseOrder
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->memo = $memo;
        return $this;
    }
    /**
     * Get approvalStatus value
     * @return \StructType\RecordRef|null
     */
    public function getApprovalStatus()
    {
        return $this->approvalStatus;
    }
    /**
     * Set approvalStatus value
     * @param \StructType\RecordRef $approvalStatus
     * @return \StructType\PurchaseOrder
     */
    public function setApprovalStatus(\StructType\RecordRef $approvalStatus = null)
    {
        $this->approvalStatus = $approvalStatus;
        return $this;
    }
    /**
     * Get exchangeRate value
     * @return float|null
     */
    public function getExchangeRate()
    {
        return $this->exchangeRate;
    }
    /**
     * Set exchangeRate value
     * @param float $exchangeRate
     * @return \StructType\PurchaseOrder
     */
    public function setExchangeRate($exchangeRate = null)
    {
        // validation for constraint: float
        if (!is_null($exchangeRate) && !(is_float($exchangeRate) || is_numeric($exchangeRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($exchangeRate, true), gettype($exchangeRate)), __LINE__);
        }
        $this->exchangeRate = $exchangeRate;
        return $this;
    }
    /**
     * Get nextApprover value
     * @return \StructType\RecordRef|null
     */
    public function getNextApprover()
    {
        return $this->nextApprover;
    }
    /**
     * Set nextApprover value
     * @param \StructType\RecordRef $nextApprover
     * @return \StructType\PurchaseOrder
     */
    public function setNextApprover(\StructType\RecordRef $nextApprover = null)
    {
        $this->nextApprover = $nextApprover;
        return $this;
    }
    /**
     * Get source value
     * @return string|null
     */
    public function getSource()
    {
        return $this->source;
    }
    /**
     * Set source value
     * @param string $source
     * @return \StructType\PurchaseOrder
     */
    public function setSource($source = null)
    {
        // validation for constraint: string
        if (!is_null($source) && !is_string($source)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($source, true), gettype($source)), __LINE__);
        }
        $this->source = $source;
        return $this;
    }
    /**
     * Get currencyName value
     * @return string|null
     */
    public function getCurrencyName()
    {
        return $this->currencyName;
    }
    /**
     * Set currencyName value
     * @param string $currencyName
     * @return \StructType\PurchaseOrder
     */
    public function setCurrencyName($currencyName = null)
    {
        // validation for constraint: string
        if (!is_null($currencyName) && !is_string($currencyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyName, true), gettype($currencyName)), __LINE__);
        }
        $this->currencyName = $currencyName;
        return $this;
    }
    /**
     * Get toBePrinted value
     * @return bool|null
     */
    public function getToBePrinted()
    {
        return $this->toBePrinted;
    }
    /**
     * Set toBePrinted value
     * @param bool $toBePrinted
     * @return \StructType\PurchaseOrder
     */
    public function setToBePrinted($toBePrinted = null)
    {
        // validation for constraint: boolean
        if (!is_null($toBePrinted) && !is_bool($toBePrinted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($toBePrinted, true), gettype($toBePrinted)), __LINE__);
        }
        $this->toBePrinted = $toBePrinted;
        return $this;
    }
    /**
     * Get toBeEmailed value
     * @return bool|null
     */
    public function getToBeEmailed()
    {
        return $this->toBeEmailed;
    }
    /**
     * Set toBeEmailed value
     * @param bool $toBeEmailed
     * @return \StructType\PurchaseOrder
     */
    public function setToBeEmailed($toBeEmailed = null)
    {
        // validation for constraint: boolean
        if (!is_null($toBeEmailed) && !is_bool($toBeEmailed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($toBeEmailed, true), gettype($toBeEmailed)), __LINE__);
        }
        $this->toBeEmailed = $toBeEmailed;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\PurchaseOrder
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get toBeFaxed value
     * @return bool|null
     */
    public function getToBeFaxed()
    {
        return $this->toBeFaxed;
    }
    /**
     * Set toBeFaxed value
     * @param bool $toBeFaxed
     * @return \StructType\PurchaseOrder
     */
    public function setToBeFaxed($toBeFaxed = null)
    {
        // validation for constraint: boolean
        if (!is_null($toBeFaxed) && !is_bool($toBeFaxed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($toBeFaxed, true), gettype($toBeFaxed)), __LINE__);
        }
        $this->toBeFaxed = $toBeFaxed;
        return $this;
    }
    /**
     * Get fax value
     * @return string|null
     */
    public function getFax()
    {
        return $this->fax;
    }
    /**
     * Set fax value
     * @param string $fax
     * @return \StructType\PurchaseOrder
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax, true), gettype($fax)), __LINE__);
        }
        $this->fax = $fax;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \StructType\PurchaseOrder
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
    /**
     * Get billingAddress value
     * @return \StructType\Address|null
     */
    public function getBillingAddress()
    {
        return $this->billingAddress;
    }
    /**
     * Set billingAddress value
     * @param \StructType\Address $billingAddress
     * @return \StructType\PurchaseOrder
     */
    public function setBillingAddress(\StructType\Address $billingAddress = null)
    {
        $this->billingAddress = $billingAddress;
        return $this;
    }
    /**
     * Get billAddressList value
     * @return \StructType\RecordRef|null
     */
    public function getBillAddressList()
    {
        return $this->billAddressList;
    }
    /**
     * Set billAddressList value
     * @param \StructType\RecordRef $billAddressList
     * @return \StructType\PurchaseOrder
     */
    public function setBillAddressList(\StructType\RecordRef $billAddressList = null)
    {
        $this->billAddressList = $billAddressList;
        return $this;
    }
    /**
     * Get currency value
     * @return \StructType\RecordRef|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param \StructType\RecordRef $currency
     * @return \StructType\PurchaseOrder
     */
    public function setCurrency(\StructType\RecordRef $currency = null)
    {
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get shipTo value
     * @return \StructType\RecordRef|null
     */
    public function getShipTo()
    {
        return $this->shipTo;
    }
    /**
     * Set shipTo value
     * @param \StructType\RecordRef $shipTo
     * @return \StructType\PurchaseOrder
     */
    public function setShipTo(\StructType\RecordRef $shipTo = null)
    {
        $this->shipTo = $shipTo;
        return $this;
    }
    /**
     * Get subTotal value
     * @return float|null
     */
    public function getSubTotal()
    {
        return $this->subTotal;
    }
    /**
     * Set subTotal value
     * @param float $subTotal
     * @return \StructType\PurchaseOrder
     */
    public function setSubTotal($subTotal = null)
    {
        // validation for constraint: float
        if (!is_null($subTotal) && !(is_float($subTotal) || is_numeric($subTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($subTotal, true), gettype($subTotal)), __LINE__);
        }
        $this->subTotal = $subTotal;
        return $this;
    }
    /**
     * Get taxTotal value
     * @return float|null
     */
    public function getTaxTotal()
    {
        return $this->taxTotal;
    }
    /**
     * Set taxTotal value
     * @param float $taxTotal
     * @return \StructType\PurchaseOrder
     */
    public function setTaxTotal($taxTotal = null)
    {
        // validation for constraint: float
        if (!is_null($taxTotal) && !(is_float($taxTotal) || is_numeric($taxTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxTotal, true), gettype($taxTotal)), __LINE__);
        }
        $this->taxTotal = $taxTotal;
        return $this;
    }
    /**
     * Get tax2Total value
     * @return float|null
     */
    public function getTax2Total()
    {
        return $this->tax2Total;
    }
    /**
     * Set tax2Total value
     * @param float $tax2Total
     * @return \StructType\PurchaseOrder
     */
    public function setTax2Total($tax2Total = null)
    {
        // validation for constraint: float
        if (!is_null($tax2Total) && !(is_float($tax2Total) || is_numeric($tax2Total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tax2Total, true), gettype($tax2Total)), __LINE__);
        }
        $this->tax2Total = $tax2Total;
        return $this;
    }
    /**
     * Get shippingAddress value
     * @return \StructType\Address|null
     */
    public function getShippingAddress()
    {
        return $this->shippingAddress;
    }
    /**
     * Set shippingAddress value
     * @param \StructType\Address $shippingAddress
     * @return \StructType\PurchaseOrder
     */
    public function setShippingAddress(\StructType\Address $shippingAddress = null)
    {
        $this->shippingAddress = $shippingAddress;
        return $this;
    }
    /**
     * Get shipIsResidential value
     * @return bool|null
     */
    public function getShipIsResidential()
    {
        return $this->shipIsResidential;
    }
    /**
     * Set shipIsResidential value
     * @param bool $shipIsResidential
     * @return \StructType\PurchaseOrder
     */
    public function setShipIsResidential($shipIsResidential = null)
    {
        // validation for constraint: boolean
        if (!is_null($shipIsResidential) && !is_bool($shipIsResidential)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($shipIsResidential, true), gettype($shipIsResidential)), __LINE__);
        }
        $this->shipIsResidential = $shipIsResidential;
        return $this;
    }
    /**
     * Get shipAddressList value
     * @return \StructType\RecordRef|null
     */
    public function getShipAddressList()
    {
        return $this->shipAddressList;
    }
    /**
     * Set shipAddressList value
     * @param \StructType\RecordRef $shipAddressList
     * @return \StructType\PurchaseOrder
     */
    public function setShipAddressList(\StructType\RecordRef $shipAddressList = null)
    {
        $this->shipAddressList = $shipAddressList;
        return $this;
    }
    /**
     * Get fob value
     * @return string|null
     */
    public function getFob()
    {
        return $this->fob;
    }
    /**
     * Set fob value
     * @param string $fob
     * @return \StructType\PurchaseOrder
     */
    public function setFob($fob = null)
    {
        // validation for constraint: string
        if (!is_null($fob) && !is_string($fob)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fob, true), gettype($fob)), __LINE__);
        }
        $this->fob = $fob;
        return $this;
    }
    /**
     * Get shipDate value
     * @return string|null
     */
    public function getShipDate()
    {
        return $this->shipDate;
    }
    /**
     * Set shipDate value
     * @param string $shipDate
     * @return \StructType\PurchaseOrder
     */
    public function setShipDate($shipDate = null)
    {
        // validation for constraint: string
        if (!is_null($shipDate) && !is_string($shipDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipDate, true), gettype($shipDate)), __LINE__);
        }
        $this->shipDate = $shipDate;
        return $this;
    }
    /**
     * Get shipMethod value
     * @return \StructType\RecordRef|null
     */
    public function getShipMethod()
    {
        return $this->shipMethod;
    }
    /**
     * Set shipMethod value
     * @param \StructType\RecordRef $shipMethod
     * @return \StructType\PurchaseOrder
     */
    public function setShipMethod(\StructType\RecordRef $shipMethod = null)
    {
        $this->shipMethod = $shipMethod;
        return $this;
    }
    /**
     * Get incoterm value
     * @return \StructType\RecordRef|null
     */
    public function getIncoterm()
    {
        return $this->incoterm;
    }
    /**
     * Set incoterm value
     * @param \StructType\RecordRef $incoterm
     * @return \StructType\PurchaseOrder
     */
    public function setIncoterm(\StructType\RecordRef $incoterm = null)
    {
        $this->incoterm = $incoterm;
        return $this;
    }
    /**
     * Get trackingNumbers value
     * @return string|null
     */
    public function getTrackingNumbers()
    {
        return $this->trackingNumbers;
    }
    /**
     * Set trackingNumbers value
     * @param string $trackingNumbers
     * @return \StructType\PurchaseOrder
     */
    public function setTrackingNumbers($trackingNumbers = null)
    {
        // validation for constraint: string
        if (!is_null($trackingNumbers) && !is_string($trackingNumbers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackingNumbers, true), gettype($trackingNumbers)), __LINE__);
        }
        $this->trackingNumbers = $trackingNumbers;
        return $this;
    }
    /**
     * Get linkedTrackingNumbers value
     * @return string|null
     */
    public function getLinkedTrackingNumbers()
    {
        return $this->linkedTrackingNumbers;
    }
    /**
     * Set linkedTrackingNumbers value
     * @param string $linkedTrackingNumbers
     * @return \StructType\PurchaseOrder
     */
    public function setLinkedTrackingNumbers($linkedTrackingNumbers = null)
    {
        // validation for constraint: string
        if (!is_null($linkedTrackingNumbers) && !is_string($linkedTrackingNumbers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($linkedTrackingNumbers, true), gettype($linkedTrackingNumbers)), __LINE__);
        }
        $this->linkedTrackingNumbers = $linkedTrackingNumbers;
        return $this;
    }
    /**
     * Get total value
     * @return float|null
     */
    public function getTotal()
    {
        return $this->total;
    }
    /**
     * Set total value
     * @param float $total
     * @return \StructType\PurchaseOrder
     */
    public function setTotal($total = null)
    {
        // validation for constraint: float
        if (!is_null($total) && !(is_float($total) || is_numeric($total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($total, true), gettype($total)), __LINE__);
        }
        $this->total = $total;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\PurchaseOrder
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\PurchaseOrder
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\PurchaseOrder
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get subsidiary value
     * @return \StructType\RecordRef|null
     */
    public function getSubsidiary()
    {
        return $this->subsidiary;
    }
    /**
     * Set subsidiary value
     * @param \StructType\RecordRef $subsidiary
     * @return \StructType\PurchaseOrder
     */
    public function setSubsidiary(\StructType\RecordRef $subsidiary = null)
    {
        $this->subsidiary = $subsidiary;
        return $this;
    }
    /**
     * Get intercoTransaction value
     * @return \StructType\RecordRef|null
     */
    public function getIntercoTransaction()
    {
        return $this->intercoTransaction;
    }
    /**
     * Set intercoTransaction value
     * @param \StructType\RecordRef $intercoTransaction
     * @return \StructType\PurchaseOrder
     */
    public function setIntercoTransaction(\StructType\RecordRef $intercoTransaction = null)
    {
        $this->intercoTransaction = $intercoTransaction;
        return $this;
    }
    /**
     * Get intercoStatus value
     * @return string|null
     */
    public function getIntercoStatus()
    {
        return $this->intercoStatus;
    }
    /**
     * Set intercoStatus value
     * @uses \EnumType\IntercoStatus::valueIsValid()
     * @uses \EnumType\IntercoStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $intercoStatus
     * @return \StructType\PurchaseOrder
     */
    public function setIntercoStatus($intercoStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\IntercoStatus::valueIsValid($intercoStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\IntercoStatus', is_array($intercoStatus) ? implode(', ', $intercoStatus) : var_export($intercoStatus, true), implode(', ', \EnumType\IntercoStatus::getValidValues())), __LINE__);
        }
        $this->intercoStatus = $intercoStatus;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\PurchaseOrder
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get orderStatus value
     * @return string|null
     */
    public function getOrderStatus()
    {
        return $this->orderStatus;
    }
    /**
     * Set orderStatus value
     * @uses \EnumType\PurchaseOrderOrderStatus::valueIsValid()
     * @uses \EnumType\PurchaseOrderOrderStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $orderStatus
     * @return \StructType\PurchaseOrder
     */
    public function setOrderStatus($orderStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PurchaseOrderOrderStatus::valueIsValid($orderStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PurchaseOrderOrderStatus', is_array($orderStatus) ? implode(', ', $orderStatus) : var_export($orderStatus, true), implode(', ', \EnumType\PurchaseOrderOrderStatus::getValidValues())), __LINE__);
        }
        $this->orderStatus = $orderStatus;
        return $this;
    }
    /**
     * Get itemList value
     * @return \StructType\PurchaseOrderItemList|null
     */
    public function getItemList()
    {
        return $this->itemList;
    }
    /**
     * Set itemList value
     * @param \StructType\PurchaseOrderItemList $itemList
     * @return \StructType\PurchaseOrder
     */
    public function setItemList(\StructType\PurchaseOrderItemList $itemList = null)
    {
        $this->itemList = $itemList;
        return $this;
    }
    /**
     * Get accountingBookDetailList value
     * @return \StructType\AccountingBookDetailList|null
     */
    public function getAccountingBookDetailList()
    {
        return $this->accountingBookDetailList;
    }
    /**
     * Set accountingBookDetailList value
     * @param \StructType\AccountingBookDetailList $accountingBookDetailList
     * @return \StructType\PurchaseOrder
     */
    public function setAccountingBookDetailList(\StructType\AccountingBookDetailList $accountingBookDetailList = null)
    {
        $this->accountingBookDetailList = $accountingBookDetailList;
        return $this;
    }
    /**
     * Get expenseList value
     * @return \StructType\PurchaseOrderExpenseList|null
     */
    public function getExpenseList()
    {
        return $this->expenseList;
    }
    /**
     * Set expenseList value
     * @param \StructType\PurchaseOrderExpenseList $expenseList
     * @return \StructType\PurchaseOrder
     */
    public function setExpenseList(\StructType\PurchaseOrderExpenseList $expenseList = null)
    {
        $this->expenseList = $expenseList;
        return $this;
    }
    /**
     * Get taxDetailsList value
     * @return \StructType\TaxDetailsList|null
     */
    public function getTaxDetailsList()
    {
        return $this->taxDetailsList;
    }
    /**
     * Set taxDetailsList value
     * @param \StructType\TaxDetailsList $taxDetailsList
     * @return \StructType\PurchaseOrder
     */
    public function setTaxDetailsList(\StructType\TaxDetailsList $taxDetailsList = null)
    {
        $this->taxDetailsList = $taxDetailsList;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\PurchaseOrder
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\PurchaseOrder
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\PurchaseOrder
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
