<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PostingTransactionSummary StructType
 * @subpackage Structs
 */
class PostingTransactionSummary extends AbstractStructBase
{
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $amount;
    /**
     * The period
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $period;
    /**
     * The account
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $account;
    /**
     * The parentItem
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $parentItem;
    /**
     * The item
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $item;
    /**
     * The entity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $entity;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The subsidiary
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $subsidiary;
    /**
     * The book
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $book;
    /**
     * Constructor method for PostingTransactionSummary
     * @uses PostingTransactionSummary::setAmount()
     * @uses PostingTransactionSummary::setPeriod()
     * @uses PostingTransactionSummary::setAccount()
     * @uses PostingTransactionSummary::setParentItem()
     * @uses PostingTransactionSummary::setItem()
     * @uses PostingTransactionSummary::setEntity()
     * @uses PostingTransactionSummary::setDepartment()
     * @uses PostingTransactionSummary::setClass()
     * @uses PostingTransactionSummary::setLocation()
     * @uses PostingTransactionSummary::setSubsidiary()
     * @uses PostingTransactionSummary::setBook()
     * @param float $amount
     * @param \StructType\RecordRef $period
     * @param \StructType\RecordRef $account
     * @param \StructType\RecordRef $parentItem
     * @param \StructType\RecordRef $item
     * @param \StructType\RecordRef $entity
     * @param \StructType\RecordRef $department
     * @param \StructType\RecordRef $class
     * @param \StructType\RecordRef $location
     * @param \StructType\RecordRef $subsidiary
     * @param \StructType\RecordRef $book
     */
    public function __construct($amount = null, \StructType\RecordRef $period = null, \StructType\RecordRef $account = null, \StructType\RecordRef $parentItem = null, \StructType\RecordRef $item = null, \StructType\RecordRef $entity = null, \StructType\RecordRef $department = null, \StructType\RecordRef $class = null, \StructType\RecordRef $location = null, \StructType\RecordRef $subsidiary = null, \StructType\RecordRef $book = null)
    {
        $this
            ->setAmount($amount)
            ->setPeriod($period)
            ->setAccount($account)
            ->setParentItem($parentItem)
            ->setItem($item)
            ->setEntity($entity)
            ->setDepartment($department)
            ->setClass($class)
            ->setLocation($location)
            ->setSubsidiary($subsidiary)
            ->setBook($book);
    }
    /**
     * Get amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \StructType\PostingTransactionSummary
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get period value
     * @return \StructType\RecordRef|null
     */
    public function getPeriod()
    {
        return $this->period;
    }
    /**
     * Set period value
     * @param \StructType\RecordRef $period
     * @return \StructType\PostingTransactionSummary
     */
    public function setPeriod(\StructType\RecordRef $period = null)
    {
        $this->period = $period;
        return $this;
    }
    /**
     * Get account value
     * @return \StructType\RecordRef|null
     */
    public function getAccount()
    {
        return $this->account;
    }
    /**
     * Set account value
     * @param \StructType\RecordRef $account
     * @return \StructType\PostingTransactionSummary
     */
    public function setAccount(\StructType\RecordRef $account = null)
    {
        $this->account = $account;
        return $this;
    }
    /**
     * Get parentItem value
     * @return \StructType\RecordRef|null
     */
    public function getParentItem()
    {
        return $this->parentItem;
    }
    /**
     * Set parentItem value
     * @param \StructType\RecordRef $parentItem
     * @return \StructType\PostingTransactionSummary
     */
    public function setParentItem(\StructType\RecordRef $parentItem = null)
    {
        $this->parentItem = $parentItem;
        return $this;
    }
    /**
     * Get item value
     * @return \StructType\RecordRef|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * Set item value
     * @param \StructType\RecordRef $item
     * @return \StructType\PostingTransactionSummary
     */
    public function setItem(\StructType\RecordRef $item = null)
    {
        $this->item = $item;
        return $this;
    }
    /**
     * Get entity value
     * @return \StructType\RecordRef|null
     */
    public function getEntity()
    {
        return $this->entity;
    }
    /**
     * Set entity value
     * @param \StructType\RecordRef $entity
     * @return \StructType\PostingTransactionSummary
     */
    public function setEntity(\StructType\RecordRef $entity = null)
    {
        $this->entity = $entity;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\PostingTransactionSummary
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\PostingTransactionSummary
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\PostingTransactionSummary
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get subsidiary value
     * @return \StructType\RecordRef|null
     */
    public function getSubsidiary()
    {
        return $this->subsidiary;
    }
    /**
     * Set subsidiary value
     * @param \StructType\RecordRef $subsidiary
     * @return \StructType\PostingTransactionSummary
     */
    public function setSubsidiary(\StructType\RecordRef $subsidiary = null)
    {
        $this->subsidiary = $subsidiary;
        return $this;
    }
    /**
     * Get book value
     * @return \StructType\RecordRef|null
     */
    public function getBook()
    {
        return $this->book;
    }
    /**
     * Set book value
     * @param \StructType\RecordRef $book
     * @return \StructType\PostingTransactionSummary
     */
    public function setBook(\StructType\RecordRef $book = null)
    {
        $this->book = $book;
        return $this;
    }
}
