<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PhoneCallContact StructType
 * @subpackage Structs
 */
class PhoneCallContact extends AbstractStructBase
{
    /**
     * The company
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $company;
    /**
     * The contact
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $contact;
    /**
     * The phone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $phone;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $email;
    /**
     * Constructor method for PhoneCallContact
     * @uses PhoneCallContact::setCompany()
     * @uses PhoneCallContact::setContact()
     * @uses PhoneCallContact::setPhone()
     * @uses PhoneCallContact::setEmail()
     * @param \StructType\RecordRef $company
     * @param \StructType\RecordRef $contact
     * @param string $phone
     * @param string $email
     */
    public function __construct(\StructType\RecordRef $company = null, \StructType\RecordRef $contact = null, $phone = null, $email = null)
    {
        $this
            ->setCompany($company)
            ->setContact($contact)
            ->setPhone($phone)
            ->setEmail($email);
    }
    /**
     * Get company value
     * @return \StructType\RecordRef|null
     */
    public function getCompany()
    {
        return $this->company;
    }
    /**
     * Set company value
     * @param \StructType\RecordRef $company
     * @return \StructType\PhoneCallContact
     */
    public function setCompany(\StructType\RecordRef $company = null)
    {
        $this->company = $company;
        return $this;
    }
    /**
     * Get contact value
     * @return \StructType\RecordRef|null
     */
    public function getContact()
    {
        return $this->contact;
    }
    /**
     * Set contact value
     * @param \StructType\RecordRef $contact
     * @return \StructType\PhoneCallContact
     */
    public function setContact(\StructType\RecordRef $contact = null)
    {
        $this->contact = $contact;
        return $this;
    }
    /**
     * Get phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->phone;
    }
    /**
     * Set phone value
     * @param string $phone
     * @return \StructType\PhoneCallContact
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        $this->phone = $phone;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\PhoneCallContact
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
}
