<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PayrollItemSearchBasic StructType
 * @subpackage Structs
 */
class PayrollItemSearchBasic extends SearchRecordBasic
{
    /**
     * The expenseAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $expenseAccount;
    /**
     * The externalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $externalId;
    /**
     * The externalIdString
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchStringField
     */
    public $externalIdString;
    /**
     * The internalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $internalId;
    /**
     * The internalIdNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchLongField
     */
    public $internalIdNumber;
    /**
     * The itemTypeNoHierarchy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchEnumMultiSelectField
     */
    public $itemTypeNoHierarchy;
    /**
     * The liabilityAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $liabilityAccount;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchStringField
     */
    public $name;
    /**
     * The subsidiary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $subsidiary;
    /**
     * The vendor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $vendor;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchCustomFieldList
     */
    public $customFieldList;
    /**
     * Constructor method for PayrollItemSearchBasic
     * @uses PayrollItemSearchBasic::setExpenseAccount()
     * @uses PayrollItemSearchBasic::setExternalId()
     * @uses PayrollItemSearchBasic::setExternalIdString()
     * @uses PayrollItemSearchBasic::setInternalId()
     * @uses PayrollItemSearchBasic::setInternalIdNumber()
     * @uses PayrollItemSearchBasic::setItemTypeNoHierarchy()
     * @uses PayrollItemSearchBasic::setLiabilityAccount()
     * @uses PayrollItemSearchBasic::setName()
     * @uses PayrollItemSearchBasic::setSubsidiary()
     * @uses PayrollItemSearchBasic::setVendor()
     * @uses PayrollItemSearchBasic::setCustomFieldList()
     * @param \StructType\SearchMultiSelectField $expenseAccount
     * @param \StructType\SearchMultiSelectField $externalId
     * @param \StructType\SearchStringField $externalIdString
     * @param \StructType\SearchMultiSelectField $internalId
     * @param \StructType\SearchLongField $internalIdNumber
     * @param \StructType\SearchEnumMultiSelectField $itemTypeNoHierarchy
     * @param \StructType\SearchMultiSelectField $liabilityAccount
     * @param \StructType\SearchStringField $name
     * @param \StructType\SearchMultiSelectField $subsidiary
     * @param \StructType\SearchMultiSelectField $vendor
     * @param \StructType\SearchCustomFieldList $customFieldList
     */
    public function __construct(\StructType\SearchMultiSelectField $expenseAccount = null, \StructType\SearchMultiSelectField $externalId = null, \StructType\SearchStringField $externalIdString = null, \StructType\SearchMultiSelectField $internalId = null, \StructType\SearchLongField $internalIdNumber = null, \StructType\SearchEnumMultiSelectField $itemTypeNoHierarchy = null, \StructType\SearchMultiSelectField $liabilityAccount = null, \StructType\SearchStringField $name = null, \StructType\SearchMultiSelectField $subsidiary = null, \StructType\SearchMultiSelectField $vendor = null, \StructType\SearchCustomFieldList $customFieldList = null)
    {
        $this
            ->setExpenseAccount($expenseAccount)
            ->setExternalId($externalId)
            ->setExternalIdString($externalIdString)
            ->setInternalId($internalId)
            ->setInternalIdNumber($internalIdNumber)
            ->setItemTypeNoHierarchy($itemTypeNoHierarchy)
            ->setLiabilityAccount($liabilityAccount)
            ->setName($name)
            ->setSubsidiary($subsidiary)
            ->setVendor($vendor)
            ->setCustomFieldList($customFieldList);
    }
    /**
     * Get expenseAccount value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getExpenseAccount()
    {
        return $this->expenseAccount;
    }
    /**
     * Set expenseAccount value
     * @param \StructType\SearchMultiSelectField $expenseAccount
     * @return \StructType\PayrollItemSearchBasic
     */
    public function setExpenseAccount(\StructType\SearchMultiSelectField $expenseAccount = null)
    {
        $this->expenseAccount = $expenseAccount;
        return $this;
    }
    /**
     * Get externalId value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param \StructType\SearchMultiSelectField $externalId
     * @return \StructType\PayrollItemSearchBasic
     */
    public function setExternalId(\StructType\SearchMultiSelectField $externalId = null)
    {
        $this->externalId = $externalId;
        return $this;
    }
    /**
     * Get externalIdString value
     * @return \StructType\SearchStringField|null
     */
    public function getExternalIdString()
    {
        return $this->externalIdString;
    }
    /**
     * Set externalIdString value
     * @param \StructType\SearchStringField $externalIdString
     * @return \StructType\PayrollItemSearchBasic
     */
    public function setExternalIdString(\StructType\SearchStringField $externalIdString = null)
    {
        $this->externalIdString = $externalIdString;
        return $this;
    }
    /**
     * Get internalId value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param \StructType\SearchMultiSelectField $internalId
     * @return \StructType\PayrollItemSearchBasic
     */
    public function setInternalId(\StructType\SearchMultiSelectField $internalId = null)
    {
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get internalIdNumber value
     * @return \StructType\SearchLongField|null
     */
    public function getInternalIdNumber()
    {
        return $this->internalIdNumber;
    }
    /**
     * Set internalIdNumber value
     * @param \StructType\SearchLongField $internalIdNumber
     * @return \StructType\PayrollItemSearchBasic
     */
    public function setInternalIdNumber(\StructType\SearchLongField $internalIdNumber = null)
    {
        $this->internalIdNumber = $internalIdNumber;
        return $this;
    }
    /**
     * Get itemTypeNoHierarchy value
     * @return \StructType\SearchEnumMultiSelectField|null
     */
    public function getItemTypeNoHierarchy()
    {
        return $this->itemTypeNoHierarchy;
    }
    /**
     * Set itemTypeNoHierarchy value
     * @param \StructType\SearchEnumMultiSelectField $itemTypeNoHierarchy
     * @return \StructType\PayrollItemSearchBasic
     */
    public function setItemTypeNoHierarchy(\StructType\SearchEnumMultiSelectField $itemTypeNoHierarchy = null)
    {
        $this->itemTypeNoHierarchy = $itemTypeNoHierarchy;
        return $this;
    }
    /**
     * Get liabilityAccount value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getLiabilityAccount()
    {
        return $this->liabilityAccount;
    }
    /**
     * Set liabilityAccount value
     * @param \StructType\SearchMultiSelectField $liabilityAccount
     * @return \StructType\PayrollItemSearchBasic
     */
    public function setLiabilityAccount(\StructType\SearchMultiSelectField $liabilityAccount = null)
    {
        $this->liabilityAccount = $liabilityAccount;
        return $this;
    }
    /**
     * Get name value
     * @return \StructType\SearchStringField|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param \StructType\SearchStringField $name
     * @return \StructType\PayrollItemSearchBasic
     */
    public function setName(\StructType\SearchStringField $name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get subsidiary value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getSubsidiary()
    {
        return $this->subsidiary;
    }
    /**
     * Set subsidiary value
     * @param \StructType\SearchMultiSelectField $subsidiary
     * @return \StructType\PayrollItemSearchBasic
     */
    public function setSubsidiary(\StructType\SearchMultiSelectField $subsidiary = null)
    {
        $this->subsidiary = $subsidiary;
        return $this;
    }
    /**
     * Get vendor value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getVendor()
    {
        return $this->vendor;
    }
    /**
     * Set vendor value
     * @param \StructType\SearchMultiSelectField $vendor
     * @return \StructType\PayrollItemSearchBasic
     */
    public function setVendor(\StructType\SearchMultiSelectField $vendor = null)
    {
        $this->vendor = $vendor;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\SearchCustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\SearchCustomFieldList $customFieldList
     * @return \StructType\PayrollItemSearchBasic
     */
    public function setCustomFieldList(\StructType\SearchCustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
}
