<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentMethodVisualsList StructType
 * @subpackage Structs
 */
class PaymentMethodVisualsList extends AbstractStructBase
{
    /**
     * The paymentMethodVisuals
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PaymentMethodVisuals[]
     */
    public $paymentMethodVisuals;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for PaymentMethodVisualsList
     * @uses PaymentMethodVisualsList::setPaymentMethodVisuals()
     * @uses PaymentMethodVisualsList::setReplaceAll()
     * @param \StructType\PaymentMethodVisuals[] $paymentMethodVisuals
     * @param bool $replaceAll
     */
    public function __construct(array $paymentMethodVisuals = array(), $replaceAll = true)
    {
        $this
            ->setPaymentMethodVisuals($paymentMethodVisuals)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get paymentMethodVisuals value
     * @return \StructType\PaymentMethodVisuals[]|null
     */
    public function getPaymentMethodVisuals()
    {
        return $this->paymentMethodVisuals;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentMethodVisuals method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentMethodVisuals method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentMethodVisualsForArrayConstraintsFromSetPaymentMethodVisuals(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentMethodVisualsListPaymentMethodVisualsItem) {
            // validation for constraint: itemType
            if (!$paymentMethodVisualsListPaymentMethodVisualsItem instanceof \StructType\PaymentMethodVisuals) {
                $invalidValues[] = is_object($paymentMethodVisualsListPaymentMethodVisualsItem) ? get_class($paymentMethodVisualsListPaymentMethodVisualsItem) : sprintf('%s(%s)', gettype($paymentMethodVisualsListPaymentMethodVisualsItem), var_export($paymentMethodVisualsListPaymentMethodVisualsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The paymentMethodVisuals property can only contain items of type \StructType\PaymentMethodVisuals, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set paymentMethodVisuals value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentMethodVisuals[] $paymentMethodVisuals
     * @return \StructType\PaymentMethodVisualsList
     */
    public function setPaymentMethodVisuals(array $paymentMethodVisuals = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentMethodVisualsArrayErrorMessage = self::validatePaymentMethodVisualsForArrayConstraintsFromSetPaymentMethodVisuals($paymentMethodVisuals))) {
            throw new \InvalidArgumentException($paymentMethodVisualsArrayErrorMessage, __LINE__);
        }
        $this->paymentMethodVisuals = $paymentMethodVisuals;
        return $this;
    }
    /**
     * Add item to paymentMethodVisuals value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentMethodVisuals $item
     * @return \StructType\PaymentMethodVisualsList
     */
    public function addToPaymentMethodVisuals(\StructType\PaymentMethodVisuals $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaymentMethodVisuals) {
            throw new \InvalidArgumentException(sprintf('The paymentMethodVisuals property can only contain items of type \StructType\PaymentMethodVisuals, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->paymentMethodVisuals[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\PaymentMethodVisualsList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
