<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentMethod StructType
 * Meta information extracted from the WSDL
 * - type: listAcct:PaymentMethod
 * @subpackage Structs
 */
class PaymentMethod extends Record
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The creditCard
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $creditCard;
    /**
     * The undepFunds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $undepFunds;
    /**
     * The account
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $account;
    /**
     * The isInactive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isInactive;
    /**
     * The isOnline
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isOnline;
    /**
     * The visualsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PaymentMethodVisualsList
     */
    public $visualsList;
    /**
     * The isDebitCard
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isDebitCard;
    /**
     * The merchantAccountsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRefList
     */
    public $merchantAccountsList;
    /**
     * The payPalEmailAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $payPalEmailAddress;
    /**
     * The expressCheckoutArrangement
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $expressCheckoutArrangement;
    /**
     * The useExpressCheckout
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $useExpressCheckout;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for PaymentMethod
     * @uses PaymentMethod::setName()
     * @uses PaymentMethod::setCreditCard()
     * @uses PaymentMethod::setUndepFunds()
     * @uses PaymentMethod::setAccount()
     * @uses PaymentMethod::setIsInactive()
     * @uses PaymentMethod::setIsOnline()
     * @uses PaymentMethod::setVisualsList()
     * @uses PaymentMethod::setIsDebitCard()
     * @uses PaymentMethod::setMerchantAccountsList()
     * @uses PaymentMethod::setPayPalEmailAddress()
     * @uses PaymentMethod::setExpressCheckoutArrangement()
     * @uses PaymentMethod::setUseExpressCheckout()
     * @uses PaymentMethod::setInternalId()
     * @uses PaymentMethod::setExternalId()
     * @param string $name
     * @param bool $creditCard
     * @param bool $undepFunds
     * @param \StructType\RecordRef $account
     * @param bool $isInactive
     * @param bool $isOnline
     * @param \StructType\PaymentMethodVisualsList $visualsList
     * @param bool $isDebitCard
     * @param \StructType\RecordRefList $merchantAccountsList
     * @param string $payPalEmailAddress
     * @param string $expressCheckoutArrangement
     * @param bool $useExpressCheckout
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct($name = null, $creditCard = null, $undepFunds = null, \StructType\RecordRef $account = null, $isInactive = null, $isOnline = null, \StructType\PaymentMethodVisualsList $visualsList = null, $isDebitCard = null, \StructType\RecordRefList $merchantAccountsList = null, $payPalEmailAddress = null, $expressCheckoutArrangement = null, $useExpressCheckout = null, $internalId = null, $externalId = null)
    {
        $this
            ->setName($name)
            ->setCreditCard($creditCard)
            ->setUndepFunds($undepFunds)
            ->setAccount($account)
            ->setIsInactive($isInactive)
            ->setIsOnline($isOnline)
            ->setVisualsList($visualsList)
            ->setIsDebitCard($isDebitCard)
            ->setMerchantAccountsList($merchantAccountsList)
            ->setPayPalEmailAddress($payPalEmailAddress)
            ->setExpressCheckoutArrangement($expressCheckoutArrangement)
            ->setUseExpressCheckout($useExpressCheckout)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\PaymentMethod
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get creditCard value
     * @return bool|null
     */
    public function getCreditCard()
    {
        return $this->creditCard;
    }
    /**
     * Set creditCard value
     * @param bool $creditCard
     * @return \StructType\PaymentMethod
     */
    public function setCreditCard($creditCard = null)
    {
        // validation for constraint: boolean
        if (!is_null($creditCard) && !is_bool($creditCard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($creditCard, true), gettype($creditCard)), __LINE__);
        }
        $this->creditCard = $creditCard;
        return $this;
    }
    /**
     * Get undepFunds value
     * @return bool|null
     */
    public function getUndepFunds()
    {
        return $this->undepFunds;
    }
    /**
     * Set undepFunds value
     * @param bool $undepFunds
     * @return \StructType\PaymentMethod
     */
    public function setUndepFunds($undepFunds = null)
    {
        // validation for constraint: boolean
        if (!is_null($undepFunds) && !is_bool($undepFunds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($undepFunds, true), gettype($undepFunds)), __LINE__);
        }
        $this->undepFunds = $undepFunds;
        return $this;
    }
    /**
     * Get account value
     * @return \StructType\RecordRef|null
     */
    public function getAccount()
    {
        return $this->account;
    }
    /**
     * Set account value
     * @param \StructType\RecordRef $account
     * @return \StructType\PaymentMethod
     */
    public function setAccount(\StructType\RecordRef $account = null)
    {
        $this->account = $account;
        return $this;
    }
    /**
     * Get isInactive value
     * @return bool|null
     */
    public function getIsInactive()
    {
        return $this->isInactive;
    }
    /**
     * Set isInactive value
     * @param bool $isInactive
     * @return \StructType\PaymentMethod
     */
    public function setIsInactive($isInactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInactive) && !is_bool($isInactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInactive, true), gettype($isInactive)), __LINE__);
        }
        $this->isInactive = $isInactive;
        return $this;
    }
    /**
     * Get isOnline value
     * @return bool|null
     */
    public function getIsOnline()
    {
        return $this->isOnline;
    }
    /**
     * Set isOnline value
     * @param bool $isOnline
     * @return \StructType\PaymentMethod
     */
    public function setIsOnline($isOnline = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOnline) && !is_bool($isOnline)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isOnline, true), gettype($isOnline)), __LINE__);
        }
        $this->isOnline = $isOnline;
        return $this;
    }
    /**
     * Get visualsList value
     * @return \StructType\PaymentMethodVisualsList|null
     */
    public function getVisualsList()
    {
        return $this->visualsList;
    }
    /**
     * Set visualsList value
     * @param \StructType\PaymentMethodVisualsList $visualsList
     * @return \StructType\PaymentMethod
     */
    public function setVisualsList(\StructType\PaymentMethodVisualsList $visualsList = null)
    {
        $this->visualsList = $visualsList;
        return $this;
    }
    /**
     * Get isDebitCard value
     * @return bool|null
     */
    public function getIsDebitCard()
    {
        return $this->isDebitCard;
    }
    /**
     * Set isDebitCard value
     * @param bool $isDebitCard
     * @return \StructType\PaymentMethod
     */
    public function setIsDebitCard($isDebitCard = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDebitCard) && !is_bool($isDebitCard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDebitCard, true), gettype($isDebitCard)), __LINE__);
        }
        $this->isDebitCard = $isDebitCard;
        return $this;
    }
    /**
     * Get merchantAccountsList value
     * @return \StructType\RecordRefList|null
     */
    public function getMerchantAccountsList()
    {
        return $this->merchantAccountsList;
    }
    /**
     * Set merchantAccountsList value
     * @param \StructType\RecordRefList $merchantAccountsList
     * @return \StructType\PaymentMethod
     */
    public function setMerchantAccountsList(\StructType\RecordRefList $merchantAccountsList = null)
    {
        $this->merchantAccountsList = $merchantAccountsList;
        return $this;
    }
    /**
     * Get payPalEmailAddress value
     * @return string|null
     */
    public function getPayPalEmailAddress()
    {
        return $this->payPalEmailAddress;
    }
    /**
     * Set payPalEmailAddress value
     * @param string $payPalEmailAddress
     * @return \StructType\PaymentMethod
     */
    public function setPayPalEmailAddress($payPalEmailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($payPalEmailAddress) && !is_string($payPalEmailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payPalEmailAddress, true), gettype($payPalEmailAddress)), __LINE__);
        }
        $this->payPalEmailAddress = $payPalEmailAddress;
        return $this;
    }
    /**
     * Get expressCheckoutArrangement value
     * @return string|null
     */
    public function getExpressCheckoutArrangement()
    {
        return $this->expressCheckoutArrangement;
    }
    /**
     * Set expressCheckoutArrangement value
     * @param string $expressCheckoutArrangement
     * @return \StructType\PaymentMethod
     */
    public function setExpressCheckoutArrangement($expressCheckoutArrangement = null)
    {
        // validation for constraint: string
        if (!is_null($expressCheckoutArrangement) && !is_string($expressCheckoutArrangement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expressCheckoutArrangement, true), gettype($expressCheckoutArrangement)), __LINE__);
        }
        $this->expressCheckoutArrangement = $expressCheckoutArrangement;
        return $this;
    }
    /**
     * Get useExpressCheckout value
     * @return bool|null
     */
    public function getUseExpressCheckout()
    {
        return $this->useExpressCheckout;
    }
    /**
     * Set useExpressCheckout value
     * @param bool $useExpressCheckout
     * @return \StructType\PaymentMethod
     */
    public function setUseExpressCheckout($useExpressCheckout = null)
    {
        // validation for constraint: boolean
        if (!is_null($useExpressCheckout) && !is_bool($useExpressCheckout)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useExpressCheckout, true), gettype($useExpressCheckout)), __LINE__);
        }
        $this->useExpressCheckout = $useExpressCheckout;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\PaymentMethod
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\PaymentMethod
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
