<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaycheckSearchBasic StructType
 * @subpackage Structs
 */
class PaycheckSearchBasic extends SearchRecordBasic
{
    /**
     * The account
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $account;
    /**
     * The batchNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchLongField
     */
    public $batchNumber;
    /**
     * The checkDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchDateField
     */
    public $checkDate;
    /**
     * The employee
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $employee;
    /**
     * The externalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $externalId;
    /**
     * The externalIdString
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchStringField
     */
    public $externalIdString;
    /**
     * The hasGLImpact
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchBooleanField
     */
    public $hasGLImpact;
    /**
     * The internalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $internalId;
    /**
     * The internalIdNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchLongField
     */
    public $internalIdNumber;
    /**
     * The payrollItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $payrollItem;
    /**
     * The payrollItemType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $payrollItemType;
    /**
     * Constructor method for PaycheckSearchBasic
     * @uses PaycheckSearchBasic::setAccount()
     * @uses PaycheckSearchBasic::setBatchNumber()
     * @uses PaycheckSearchBasic::setCheckDate()
     * @uses PaycheckSearchBasic::setEmployee()
     * @uses PaycheckSearchBasic::setExternalId()
     * @uses PaycheckSearchBasic::setExternalIdString()
     * @uses PaycheckSearchBasic::setHasGLImpact()
     * @uses PaycheckSearchBasic::setInternalId()
     * @uses PaycheckSearchBasic::setInternalIdNumber()
     * @uses PaycheckSearchBasic::setPayrollItem()
     * @uses PaycheckSearchBasic::setPayrollItemType()
     * @param \StructType\SearchMultiSelectField $account
     * @param \StructType\SearchLongField $batchNumber
     * @param \StructType\SearchDateField $checkDate
     * @param \StructType\SearchMultiSelectField $employee
     * @param \StructType\SearchMultiSelectField $externalId
     * @param \StructType\SearchStringField $externalIdString
     * @param \StructType\SearchBooleanField $hasGLImpact
     * @param \StructType\SearchMultiSelectField $internalId
     * @param \StructType\SearchLongField $internalIdNumber
     * @param \StructType\SearchMultiSelectField $payrollItem
     * @param \StructType\SearchMultiSelectField $payrollItemType
     */
    public function __construct(\StructType\SearchMultiSelectField $account = null, \StructType\SearchLongField $batchNumber = null, \StructType\SearchDateField $checkDate = null, \StructType\SearchMultiSelectField $employee = null, \StructType\SearchMultiSelectField $externalId = null, \StructType\SearchStringField $externalIdString = null, \StructType\SearchBooleanField $hasGLImpact = null, \StructType\SearchMultiSelectField $internalId = null, \StructType\SearchLongField $internalIdNumber = null, \StructType\SearchMultiSelectField $payrollItem = null, \StructType\SearchMultiSelectField $payrollItemType = null)
    {
        $this
            ->setAccount($account)
            ->setBatchNumber($batchNumber)
            ->setCheckDate($checkDate)
            ->setEmployee($employee)
            ->setExternalId($externalId)
            ->setExternalIdString($externalIdString)
            ->setHasGLImpact($hasGLImpact)
            ->setInternalId($internalId)
            ->setInternalIdNumber($internalIdNumber)
            ->setPayrollItem($payrollItem)
            ->setPayrollItemType($payrollItemType);
    }
    /**
     * Get account value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getAccount()
    {
        return $this->account;
    }
    /**
     * Set account value
     * @param \StructType\SearchMultiSelectField $account
     * @return \StructType\PaycheckSearchBasic
     */
    public function setAccount(\StructType\SearchMultiSelectField $account = null)
    {
        $this->account = $account;
        return $this;
    }
    /**
     * Get batchNumber value
     * @return \StructType\SearchLongField|null
     */
    public function getBatchNumber()
    {
        return $this->batchNumber;
    }
    /**
     * Set batchNumber value
     * @param \StructType\SearchLongField $batchNumber
     * @return \StructType\PaycheckSearchBasic
     */
    public function setBatchNumber(\StructType\SearchLongField $batchNumber = null)
    {
        $this->batchNumber = $batchNumber;
        return $this;
    }
    /**
     * Get checkDate value
     * @return \StructType\SearchDateField|null
     */
    public function getCheckDate()
    {
        return $this->checkDate;
    }
    /**
     * Set checkDate value
     * @param \StructType\SearchDateField $checkDate
     * @return \StructType\PaycheckSearchBasic
     */
    public function setCheckDate(\StructType\SearchDateField $checkDate = null)
    {
        $this->checkDate = $checkDate;
        return $this;
    }
    /**
     * Get employee value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getEmployee()
    {
        return $this->employee;
    }
    /**
     * Set employee value
     * @param \StructType\SearchMultiSelectField $employee
     * @return \StructType\PaycheckSearchBasic
     */
    public function setEmployee(\StructType\SearchMultiSelectField $employee = null)
    {
        $this->employee = $employee;
        return $this;
    }
    /**
     * Get externalId value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param \StructType\SearchMultiSelectField $externalId
     * @return \StructType\PaycheckSearchBasic
     */
    public function setExternalId(\StructType\SearchMultiSelectField $externalId = null)
    {
        $this->externalId = $externalId;
        return $this;
    }
    /**
     * Get externalIdString value
     * @return \StructType\SearchStringField|null
     */
    public function getExternalIdString()
    {
        return $this->externalIdString;
    }
    /**
     * Set externalIdString value
     * @param \StructType\SearchStringField $externalIdString
     * @return \StructType\PaycheckSearchBasic
     */
    public function setExternalIdString(\StructType\SearchStringField $externalIdString = null)
    {
        $this->externalIdString = $externalIdString;
        return $this;
    }
    /**
     * Get hasGLImpact value
     * @return \StructType\SearchBooleanField|null
     */
    public function getHasGLImpact()
    {
        return $this->hasGLImpact;
    }
    /**
     * Set hasGLImpact value
     * @param \StructType\SearchBooleanField $hasGLImpact
     * @return \StructType\PaycheckSearchBasic
     */
    public function setHasGLImpact(\StructType\SearchBooleanField $hasGLImpact = null)
    {
        $this->hasGLImpact = $hasGLImpact;
        return $this;
    }
    /**
     * Get internalId value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param \StructType\SearchMultiSelectField $internalId
     * @return \StructType\PaycheckSearchBasic
     */
    public function setInternalId(\StructType\SearchMultiSelectField $internalId = null)
    {
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get internalIdNumber value
     * @return \StructType\SearchLongField|null
     */
    public function getInternalIdNumber()
    {
        return $this->internalIdNumber;
    }
    /**
     * Set internalIdNumber value
     * @param \StructType\SearchLongField $internalIdNumber
     * @return \StructType\PaycheckSearchBasic
     */
    public function setInternalIdNumber(\StructType\SearchLongField $internalIdNumber = null)
    {
        $this->internalIdNumber = $internalIdNumber;
        return $this;
    }
    /**
     * Get payrollItem value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getPayrollItem()
    {
        return $this->payrollItem;
    }
    /**
     * Set payrollItem value
     * @param \StructType\SearchMultiSelectField $payrollItem
     * @return \StructType\PaycheckSearchBasic
     */
    public function setPayrollItem(\StructType\SearchMultiSelectField $payrollItem = null)
    {
        $this->payrollItem = $payrollItem;
        return $this;
    }
    /**
     * Get payrollItemType value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getPayrollItemType()
    {
        return $this->payrollItemType;
    }
    /**
     * Set payrollItemType value
     * @param \StructType\SearchMultiSelectField $payrollItemType
     * @return \StructType\PaycheckSearchBasic
     */
    public function setPayrollItemType(\StructType\SearchMultiSelectField $payrollItemType = null)
    {
        $this->payrollItemType = $payrollItemType;
        return $this;
    }
}
