<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaycheckPayTime StructType
 * @subpackage Structs
 */
class PaycheckPayTime extends AbstractStructBase
{
    /**
     * The apply
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $apply;
    /**
     * The line
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $line;
    /**
     * The payItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $payItem;
    /**
     * The payItemName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $payItemName;
    /**
     * The ddate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ddate;
    /**
     * The custJob
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $custJob;
    /**
     * The serviceItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $serviceItem;
    /**
     * The count
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $count;
    /**
     * The rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $rate;
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $amount;
    /**
     * Constructor method for PaycheckPayTime
     * @uses PaycheckPayTime::setApply()
     * @uses PaycheckPayTime::setLine()
     * @uses PaycheckPayTime::setPayItem()
     * @uses PaycheckPayTime::setPayItemName()
     * @uses PaycheckPayTime::setDdate()
     * @uses PaycheckPayTime::setCustJob()
     * @uses PaycheckPayTime::setServiceItem()
     * @uses PaycheckPayTime::setCount()
     * @uses PaycheckPayTime::setRate()
     * @uses PaycheckPayTime::setAmount()
     * @param bool $apply
     * @param int $line
     * @param int $payItem
     * @param string $payItemName
     * @param string $ddate
     * @param string $custJob
     * @param string $serviceItem
     * @param float $count
     * @param float $rate
     * @param float $amount
     */
    public function __construct($apply = null, $line = null, $payItem = null, $payItemName = null, $ddate = null, $custJob = null, $serviceItem = null, $count = null, $rate = null, $amount = null)
    {
        $this
            ->setApply($apply)
            ->setLine($line)
            ->setPayItem($payItem)
            ->setPayItemName($payItemName)
            ->setDdate($ddate)
            ->setCustJob($custJob)
            ->setServiceItem($serviceItem)
            ->setCount($count)
            ->setRate($rate)
            ->setAmount($amount);
    }
    /**
     * Get apply value
     * @return bool|null
     */
    public function getApply()
    {
        return $this->apply;
    }
    /**
     * Set apply value
     * @param bool $apply
     * @return \StructType\PaycheckPayTime
     */
    public function setApply($apply = null)
    {
        // validation for constraint: boolean
        if (!is_null($apply) && !is_bool($apply)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($apply, true), gettype($apply)), __LINE__);
        }
        $this->apply = $apply;
        return $this;
    }
    /**
     * Get line value
     * @return int|null
     */
    public function getLine()
    {
        return $this->line;
    }
    /**
     * Set line value
     * @param int $line
     * @return \StructType\PaycheckPayTime
     */
    public function setLine($line = null)
    {
        // validation for constraint: int
        if (!is_null($line) && !(is_int($line) || ctype_digit($line))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($line, true), gettype($line)), __LINE__);
        }
        $this->line = $line;
        return $this;
    }
    /**
     * Get payItem value
     * @return int|null
     */
    public function getPayItem()
    {
        return $this->payItem;
    }
    /**
     * Set payItem value
     * @param int $payItem
     * @return \StructType\PaycheckPayTime
     */
    public function setPayItem($payItem = null)
    {
        // validation for constraint: int
        if (!is_null($payItem) && !(is_int($payItem) || ctype_digit($payItem))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($payItem, true), gettype($payItem)), __LINE__);
        }
        $this->payItem = $payItem;
        return $this;
    }
    /**
     * Get payItemName value
     * @return string|null
     */
    public function getPayItemName()
    {
        return $this->payItemName;
    }
    /**
     * Set payItemName value
     * @param string $payItemName
     * @return \StructType\PaycheckPayTime
     */
    public function setPayItemName($payItemName = null)
    {
        // validation for constraint: string
        if (!is_null($payItemName) && !is_string($payItemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payItemName, true), gettype($payItemName)), __LINE__);
        }
        $this->payItemName = $payItemName;
        return $this;
    }
    /**
     * Get ddate value
     * @return string|null
     */
    public function getDdate()
    {
        return $this->ddate;
    }
    /**
     * Set ddate value
     * @param string $ddate
     * @return \StructType\PaycheckPayTime
     */
    public function setDdate($ddate = null)
    {
        // validation for constraint: string
        if (!is_null($ddate) && !is_string($ddate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ddate, true), gettype($ddate)), __LINE__);
        }
        $this->ddate = $ddate;
        return $this;
    }
    /**
     * Get custJob value
     * @return string|null
     */
    public function getCustJob()
    {
        return $this->custJob;
    }
    /**
     * Set custJob value
     * @param string $custJob
     * @return \StructType\PaycheckPayTime
     */
    public function setCustJob($custJob = null)
    {
        // validation for constraint: string
        if (!is_null($custJob) && !is_string($custJob)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($custJob, true), gettype($custJob)), __LINE__);
        }
        $this->custJob = $custJob;
        return $this;
    }
    /**
     * Get serviceItem value
     * @return string|null
     */
    public function getServiceItem()
    {
        return $this->serviceItem;
    }
    /**
     * Set serviceItem value
     * @param string $serviceItem
     * @return \StructType\PaycheckPayTime
     */
    public function setServiceItem($serviceItem = null)
    {
        // validation for constraint: string
        if (!is_null($serviceItem) && !is_string($serviceItem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceItem, true), gettype($serviceItem)), __LINE__);
        }
        $this->serviceItem = $serviceItem;
        return $this;
    }
    /**
     * Get count value
     * @return float|null
     */
    public function getCount()
    {
        return $this->count;
    }
    /**
     * Set count value
     * @param float $count
     * @return \StructType\PaycheckPayTime
     */
    public function setCount($count = null)
    {
        // validation for constraint: float
        if (!is_null($count) && !(is_float($count) || is_numeric($count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($count, true), gettype($count)), __LINE__);
        }
        $this->count = $count;
        return $this;
    }
    /**
     * Get rate value
     * @return float|null
     */
    public function getRate()
    {
        return $this->rate;
    }
    /**
     * Set rate value
     * @param float $rate
     * @return \StructType\PaycheckPayTime
     */
    public function setRate($rate = null)
    {
        // validation for constraint: float
        if (!is_null($rate) && !(is_float($rate) || is_numeric($rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rate, true), gettype($rate)), __LINE__);
        }
        $this->rate = $rate;
        return $this;
    }
    /**
     * Get amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \StructType\PaycheckPayTime
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
}
