<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaycheckPayPto StructType
 * @subpackage Structs
 */
class PaycheckPayPto extends AbstractStructBase
{
    /**
     * The payItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $payItem;
    /**
     * The payItemName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $payItemName;
    /**
     * The hoursAccrued
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $hoursAccrued;
    /**
     * The hoursUsed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $hoursUsed;
    /**
     * The hoursBalance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $hoursBalance;
    /**
     * Constructor method for PaycheckPayPto
     * @uses PaycheckPayPto::setPayItem()
     * @uses PaycheckPayPto::setPayItemName()
     * @uses PaycheckPayPto::setHoursAccrued()
     * @uses PaycheckPayPto::setHoursUsed()
     * @uses PaycheckPayPto::setHoursBalance()
     * @param int $payItem
     * @param string $payItemName
     * @param float $hoursAccrued
     * @param float $hoursUsed
     * @param float $hoursBalance
     */
    public function __construct($payItem = null, $payItemName = null, $hoursAccrued = null, $hoursUsed = null, $hoursBalance = null)
    {
        $this
            ->setPayItem($payItem)
            ->setPayItemName($payItemName)
            ->setHoursAccrued($hoursAccrued)
            ->setHoursUsed($hoursUsed)
            ->setHoursBalance($hoursBalance);
    }
    /**
     * Get payItem value
     * @return int|null
     */
    public function getPayItem()
    {
        return $this->payItem;
    }
    /**
     * Set payItem value
     * @param int $payItem
     * @return \StructType\PaycheckPayPto
     */
    public function setPayItem($payItem = null)
    {
        // validation for constraint: int
        if (!is_null($payItem) && !(is_int($payItem) || ctype_digit($payItem))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($payItem, true), gettype($payItem)), __LINE__);
        }
        $this->payItem = $payItem;
        return $this;
    }
    /**
     * Get payItemName value
     * @return string|null
     */
    public function getPayItemName()
    {
        return $this->payItemName;
    }
    /**
     * Set payItemName value
     * @param string $payItemName
     * @return \StructType\PaycheckPayPto
     */
    public function setPayItemName($payItemName = null)
    {
        // validation for constraint: string
        if (!is_null($payItemName) && !is_string($payItemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payItemName, true), gettype($payItemName)), __LINE__);
        }
        $this->payItemName = $payItemName;
        return $this;
    }
    /**
     * Get hoursAccrued value
     * @return float|null
     */
    public function getHoursAccrued()
    {
        return $this->hoursAccrued;
    }
    /**
     * Set hoursAccrued value
     * @param float $hoursAccrued
     * @return \StructType\PaycheckPayPto
     */
    public function setHoursAccrued($hoursAccrued = null)
    {
        // validation for constraint: float
        if (!is_null($hoursAccrued) && !(is_float($hoursAccrued) || is_numeric($hoursAccrued))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($hoursAccrued, true), gettype($hoursAccrued)), __LINE__);
        }
        $this->hoursAccrued = $hoursAccrued;
        return $this;
    }
    /**
     * Get hoursUsed value
     * @return float|null
     */
    public function getHoursUsed()
    {
        return $this->hoursUsed;
    }
    /**
     * Set hoursUsed value
     * @param float $hoursUsed
     * @return \StructType\PaycheckPayPto
     */
    public function setHoursUsed($hoursUsed = null)
    {
        // validation for constraint: float
        if (!is_null($hoursUsed) && !(is_float($hoursUsed) || is_numeric($hoursUsed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($hoursUsed, true), gettype($hoursUsed)), __LINE__);
        }
        $this->hoursUsed = $hoursUsed;
        return $this;
    }
    /**
     * Get hoursBalance value
     * @return float|null
     */
    public function getHoursBalance()
    {
        return $this->hoursBalance;
    }
    /**
     * Set hoursBalance value
     * @param float $hoursBalance
     * @return \StructType\PaycheckPayPto
     */
    public function setHoursBalance($hoursBalance = null)
    {
        // validation for constraint: float
        if (!is_null($hoursBalance) && !(is_float($hoursBalance) || is_numeric($hoursBalance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($hoursBalance, true), gettype($hoursBalance)), __LINE__);
        }
        $this->hoursBalance = $hoursBalance;
        return $this;
    }
}
