<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaycheckPayContrib StructType
 * @subpackage Structs
 */
class PaycheckPayContrib extends AbstractStructBase
{
    /**
     * The payItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $payItem;
    /**
     * The line
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $line;
    /**
     * The wageBase
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $wageBase;
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $amount;
    /**
     * The manualEntry
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $manualEntry;
    /**
     * Constructor method for PaycheckPayContrib
     * @uses PaycheckPayContrib::setPayItem()
     * @uses PaycheckPayContrib::setLine()
     * @uses PaycheckPayContrib::setWageBase()
     * @uses PaycheckPayContrib::setAmount()
     * @uses PaycheckPayContrib::setManualEntry()
     * @param \StructType\RecordRef $payItem
     * @param int $line
     * @param float $wageBase
     * @param float $amount
     * @param bool $manualEntry
     */
    public function __construct(\StructType\RecordRef $payItem = null, $line = null, $wageBase = null, $amount = null, $manualEntry = null)
    {
        $this
            ->setPayItem($payItem)
            ->setLine($line)
            ->setWageBase($wageBase)
            ->setAmount($amount)
            ->setManualEntry($manualEntry);
    }
    /**
     * Get payItem value
     * @return \StructType\RecordRef|null
     */
    public function getPayItem()
    {
        return $this->payItem;
    }
    /**
     * Set payItem value
     * @param \StructType\RecordRef $payItem
     * @return \StructType\PaycheckPayContrib
     */
    public function setPayItem(\StructType\RecordRef $payItem = null)
    {
        $this->payItem = $payItem;
        return $this;
    }
    /**
     * Get line value
     * @return int|null
     */
    public function getLine()
    {
        return $this->line;
    }
    /**
     * Set line value
     * @param int $line
     * @return \StructType\PaycheckPayContrib
     */
    public function setLine($line = null)
    {
        // validation for constraint: int
        if (!is_null($line) && !(is_int($line) || ctype_digit($line))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($line, true), gettype($line)), __LINE__);
        }
        $this->line = $line;
        return $this;
    }
    /**
     * Get wageBase value
     * @return float|null
     */
    public function getWageBase()
    {
        return $this->wageBase;
    }
    /**
     * Set wageBase value
     * @param float $wageBase
     * @return \StructType\PaycheckPayContrib
     */
    public function setWageBase($wageBase = null)
    {
        // validation for constraint: float
        if (!is_null($wageBase) && !(is_float($wageBase) || is_numeric($wageBase))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($wageBase, true), gettype($wageBase)), __LINE__);
        }
        $this->wageBase = $wageBase;
        return $this;
    }
    /**
     * Get amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \StructType\PaycheckPayContrib
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get manualEntry value
     * @return bool|null
     */
    public function getManualEntry()
    {
        return $this->manualEntry;
    }
    /**
     * Set manualEntry value
     * @param bool $manualEntry
     * @return \StructType\PaycheckPayContrib
     */
    public function setManualEntry($manualEntry = null)
    {
        // validation for constraint: boolean
        if (!is_null($manualEntry) && !is_bool($manualEntry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($manualEntry, true), gettype($manualEntry)), __LINE__);
        }
        $this->manualEntry = $manualEntry;
        return $this;
    }
}
