<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Passport StructType
 * @subpackage Structs
 */
class Passport extends AbstractStructBase
{
    /**
     * The email
     * @var string
     */
    public $email;
    /**
     * The password
     * @var string
     */
    public $password;
    /**
     * The account
     * @var string
     */
    public $account;
    /**
     * The role
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $role;
    /**
     * Constructor method for Passport
     * @uses Passport::setEmail()
     * @uses Passport::setPassword()
     * @uses Passport::setAccount()
     * @uses Passport::setRole()
     * @param string $email
     * @param string $password
     * @param string $account
     * @param \StructType\RecordRef $role
     */
    public function __construct($email = null, $password = null, $account = null, \StructType\RecordRef $role = null)
    {
        $this
            ->setEmail($email)
            ->setPassword($password)
            ->setAccount($account)
            ->setRole($role);
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\Passport
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\Passport
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get account value
     * @return string|null
     */
    public function getAccount()
    {
        return $this->account;
    }
    /**
     * Set account value
     * @param string $account
     * @return \StructType\Passport
     */
    public function setAccount($account = null)
    {
        // validation for constraint: string
        if (!is_null($account) && !is_string($account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($account, true), gettype($account)), __LINE__);
        }
        $this->account = $account;
        return $this;
    }
    /**
     * Get role value
     * @return \StructType\RecordRef|null
     */
    public function getRole()
    {
        return $this->role;
    }
    /**
     * Set role value
     * @param \StructType\RecordRef $role
     * @return \StructType\Passport
     */
    public function setRole(\StructType\RecordRef $role = null)
    {
        $this->role = $role;
        return $this;
    }
}
