<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OtherChargeSaleItem StructType
 * Meta information extracted from the WSDL
 * - type: listAcct:OtherChargeSaleItem
 * @subpackage Structs
 */
class OtherChargeSaleItem extends Record
{
    /**
     * The createdDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $createdDate;
    /**
     * The lastModifiedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastModifiedDate;
    /**
     * The salesDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $salesDescription;
    /**
     * The includeChildren
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $includeChildren;
    /**
     * The incomeAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $incomeAccount;
    /**
     * The isTaxable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isTaxable;
    /**
     * The matrixType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $matrixType;
    /**
     * The taxSchedule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $taxSchedule;
    /**
     * The costEstimateType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $costEstimateType;
    /**
     * The costEstimate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $costEstimate;
    /**
     * The unitsType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $unitsType;
    /**
     * The saleUnit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $saleUnit;
    /**
     * The issueProduct
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $issueProduct;
    /**
     * The costEstimateUnits
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $costEstimateUnits;
    /**
     * The billingSchedule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $billingSchedule;
    /**
     * The deferredRevenueAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $deferredRevenueAccount;
    /**
     * The revRecSchedule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $revRecSchedule;
    /**
     * The minimumQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $minimumQuantity;
    /**
     * The minimumQuantityUnits
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $minimumQuantityUnits;
    /**
     * The enforceMinQtyInternally
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $enforceMinQtyInternally;
    /**
     * The maximumQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $maximumQuantity;
    /**
     * The softDescriptor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $softDescriptor;
    /**
     * The isFulfillable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isFulfillable;
    /**
     * The costCategory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $costCategory;
    /**
     * The pricesIncludeTax
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $pricesIncludeTax;
    /**
     * The quantityPricingSchedule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $quantityPricingSchedule;
    /**
     * The useMarginalRates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $useMarginalRates;
    /**
     * The overallQuantityPricingType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $overallQuantityPricingType;
    /**
     * The pricingGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $pricingGroup;
    /**
     * The customForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customForm;
    /**
     * The itemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $itemId;
    /**
     * The upcCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $upcCode;
    /**
     * The displayName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $displayName;
    /**
     * The parent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $parent;
    /**
     * The isOnline
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isOnline;
    /**
     * The isGcoCompliant
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isGcoCompliant;
    /**
     * The offerSupport
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $offerSupport;
    /**
     * The isInactive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $isInactive;
    /**
     * The matrixItemNameTemplate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $matrixItemNameTemplate;
    /**
     * The availableToPartners
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $availableToPartners;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The vsoePrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $vsoePrice;
    /**
     * The vsoeSopGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $vsoeSopGroup;
    /**
     * The vsoeDeferral
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $vsoeDeferral;
    /**
     * The vsoePermitDiscount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $vsoePermitDiscount;
    /**
     * The vsoeDelivered
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $vsoeDelivered;
    /**
     * The itemRevenueCategory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $itemRevenueCategory;
    /**
     * The deferRevRec
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $deferRevRec;
    /**
     * The revenueRecognitionRule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $revenueRecognitionRule;
    /**
     * The revRecForecastRule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $revRecForecastRule;
    /**
     * The revenueAllocationGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $revenueAllocationGroup;
    /**
     * The createRevenuePlansOn
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $createRevenuePlansOn;
    /**
     * The directRevenuePosting
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $directRevenuePosting;
    /**
     * The contingentRevenueHandling
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $contingentRevenueHandling;
    /**
     * The revReclassFXAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $revReclassFXAccount;
    /**
     * The subsidiaryList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRefList
     */
    public $subsidiaryList;
    /**
     * The itemOptionsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ItemOptionsList
     */
    public $itemOptionsList;
    /**
     * The matrixOptionList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MatrixOptionList
     */
    public $matrixOptionList;
    /**
     * The pricingMatrix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PricingMatrix
     */
    public $pricingMatrix;
    /**
     * The accountingBookDetailList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ItemAccountingBookDetailList
     */
    public $accountingBookDetailList;
    /**
     * The purchaseTaxCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $purchaseTaxCode;
    /**
     * The rate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $rate;
    /**
     * The salesTaxCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $salesTaxCode;
    /**
     * The translationsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TranslationList
     */
    public $translationsList;
    /**
     * The hierarchyVersionsList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\OtherChargeSaleItemHierarchyVersionsList
     */
    public $hierarchyVersionsList;
    /**
     * The consumptionUnit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $consumptionUnit;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for OtherChargeSaleItem
     * @uses OtherChargeSaleItem::setCreatedDate()
     * @uses OtherChargeSaleItem::setLastModifiedDate()
     * @uses OtherChargeSaleItem::setSalesDescription()
     * @uses OtherChargeSaleItem::setIncludeChildren()
     * @uses OtherChargeSaleItem::setIncomeAccount()
     * @uses OtherChargeSaleItem::setIsTaxable()
     * @uses OtherChargeSaleItem::setMatrixType()
     * @uses OtherChargeSaleItem::setTaxSchedule()
     * @uses OtherChargeSaleItem::setCostEstimateType()
     * @uses OtherChargeSaleItem::setCostEstimate()
     * @uses OtherChargeSaleItem::setUnitsType()
     * @uses OtherChargeSaleItem::setSaleUnit()
     * @uses OtherChargeSaleItem::setIssueProduct()
     * @uses OtherChargeSaleItem::setCostEstimateUnits()
     * @uses OtherChargeSaleItem::setBillingSchedule()
     * @uses OtherChargeSaleItem::setDeferredRevenueAccount()
     * @uses OtherChargeSaleItem::setRevRecSchedule()
     * @uses OtherChargeSaleItem::setMinimumQuantity()
     * @uses OtherChargeSaleItem::setMinimumQuantityUnits()
     * @uses OtherChargeSaleItem::setEnforceMinQtyInternally()
     * @uses OtherChargeSaleItem::setMaximumQuantity()
     * @uses OtherChargeSaleItem::setSoftDescriptor()
     * @uses OtherChargeSaleItem::setIsFulfillable()
     * @uses OtherChargeSaleItem::setCostCategory()
     * @uses OtherChargeSaleItem::setPricesIncludeTax()
     * @uses OtherChargeSaleItem::setQuantityPricingSchedule()
     * @uses OtherChargeSaleItem::setUseMarginalRates()
     * @uses OtherChargeSaleItem::setOverallQuantityPricingType()
     * @uses OtherChargeSaleItem::setPricingGroup()
     * @uses OtherChargeSaleItem::setCustomForm()
     * @uses OtherChargeSaleItem::setItemId()
     * @uses OtherChargeSaleItem::setUpcCode()
     * @uses OtherChargeSaleItem::setDisplayName()
     * @uses OtherChargeSaleItem::setParent()
     * @uses OtherChargeSaleItem::setIsOnline()
     * @uses OtherChargeSaleItem::setIsGcoCompliant()
     * @uses OtherChargeSaleItem::setOfferSupport()
     * @uses OtherChargeSaleItem::setIsInactive()
     * @uses OtherChargeSaleItem::setMatrixItemNameTemplate()
     * @uses OtherChargeSaleItem::setAvailableToPartners()
     * @uses OtherChargeSaleItem::setDepartment()
     * @uses OtherChargeSaleItem::setClass()
     * @uses OtherChargeSaleItem::setLocation()
     * @uses OtherChargeSaleItem::setVsoePrice()
     * @uses OtherChargeSaleItem::setVsoeSopGroup()
     * @uses OtherChargeSaleItem::setVsoeDeferral()
     * @uses OtherChargeSaleItem::setVsoePermitDiscount()
     * @uses OtherChargeSaleItem::setVsoeDelivered()
     * @uses OtherChargeSaleItem::setItemRevenueCategory()
     * @uses OtherChargeSaleItem::setDeferRevRec()
     * @uses OtherChargeSaleItem::setRevenueRecognitionRule()
     * @uses OtherChargeSaleItem::setRevRecForecastRule()
     * @uses OtherChargeSaleItem::setRevenueAllocationGroup()
     * @uses OtherChargeSaleItem::setCreateRevenuePlansOn()
     * @uses OtherChargeSaleItem::setDirectRevenuePosting()
     * @uses OtherChargeSaleItem::setContingentRevenueHandling()
     * @uses OtherChargeSaleItem::setRevReclassFXAccount()
     * @uses OtherChargeSaleItem::setSubsidiaryList()
     * @uses OtherChargeSaleItem::setItemOptionsList()
     * @uses OtherChargeSaleItem::setMatrixOptionList()
     * @uses OtherChargeSaleItem::setPricingMatrix()
     * @uses OtherChargeSaleItem::setAccountingBookDetailList()
     * @uses OtherChargeSaleItem::setPurchaseTaxCode()
     * @uses OtherChargeSaleItem::setRate()
     * @uses OtherChargeSaleItem::setSalesTaxCode()
     * @uses OtherChargeSaleItem::setTranslationsList()
     * @uses OtherChargeSaleItem::setHierarchyVersionsList()
     * @uses OtherChargeSaleItem::setConsumptionUnit()
     * @uses OtherChargeSaleItem::setCustomFieldList()
     * @uses OtherChargeSaleItem::setInternalId()
     * @uses OtherChargeSaleItem::setExternalId()
     * @param string $createdDate
     * @param string $lastModifiedDate
     * @param string $salesDescription
     * @param bool $includeChildren
     * @param \StructType\RecordRef $incomeAccount
     * @param bool $isTaxable
     * @param string $matrixType
     * @param \StructType\RecordRef $taxSchedule
     * @param string $costEstimateType
     * @param float $costEstimate
     * @param \StructType\RecordRef $unitsType
     * @param \StructType\RecordRef $saleUnit
     * @param \StructType\RecordRef $issueProduct
     * @param string $costEstimateUnits
     * @param \StructType\RecordRef $billingSchedule
     * @param \StructType\RecordRef $deferredRevenueAccount
     * @param \StructType\RecordRef $revRecSchedule
     * @param int $minimumQuantity
     * @param string $minimumQuantityUnits
     * @param bool $enforceMinQtyInternally
     * @param int $maximumQuantity
     * @param string $softDescriptor
     * @param bool $isFulfillable
     * @param \StructType\RecordRef $costCategory
     * @param bool $pricesIncludeTax
     * @param \StructType\RecordRef $quantityPricingSchedule
     * @param bool $useMarginalRates
     * @param string $overallQuantityPricingType
     * @param \StructType\RecordRef $pricingGroup
     * @param \StructType\RecordRef $customForm
     * @param string $itemId
     * @param string $upcCode
     * @param string $displayName
     * @param \StructType\RecordRef $parent
     * @param bool $isOnline
     * @param bool $isGcoCompliant
     * @param bool $offerSupport
     * @param bool $isInactive
     * @param string $matrixItemNameTemplate
     * @param bool $availableToPartners
     * @param \StructType\RecordRef $department
     * @param \StructType\RecordRef $class
     * @param \StructType\RecordRef $location
     * @param float $vsoePrice
     * @param string $vsoeSopGroup
     * @param string $vsoeDeferral
     * @param string $vsoePermitDiscount
     * @param bool $vsoeDelivered
     * @param \StructType\RecordRef $itemRevenueCategory
     * @param bool $deferRevRec
     * @param \StructType\RecordRef $revenueRecognitionRule
     * @param \StructType\RecordRef $revRecForecastRule
     * @param \StructType\RecordRef $revenueAllocationGroup
     * @param \StructType\RecordRef $createRevenuePlansOn
     * @param bool $directRevenuePosting
     * @param bool $contingentRevenueHandling
     * @param \StructType\RecordRef $revReclassFXAccount
     * @param \StructType\RecordRefList $subsidiaryList
     * @param \StructType\ItemOptionsList $itemOptionsList
     * @param \StructType\MatrixOptionList $matrixOptionList
     * @param \StructType\PricingMatrix $pricingMatrix
     * @param \StructType\ItemAccountingBookDetailList $accountingBookDetailList
     * @param \StructType\RecordRef $purchaseTaxCode
     * @param float $rate
     * @param \StructType\RecordRef $salesTaxCode
     * @param \StructType\TranslationList $translationsList
     * @param \StructType\OtherChargeSaleItemHierarchyVersionsList $hierarchyVersionsList
     * @param \StructType\RecordRef $consumptionUnit
     * @param \StructType\CustomFieldList $customFieldList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct($createdDate = null, $lastModifiedDate = null, $salesDescription = null, $includeChildren = null, \StructType\RecordRef $incomeAccount = null, $isTaxable = null, $matrixType = null, \StructType\RecordRef $taxSchedule = null, $costEstimateType = null, $costEstimate = null, \StructType\RecordRef $unitsType = null, \StructType\RecordRef $saleUnit = null, \StructType\RecordRef $issueProduct = null, $costEstimateUnits = null, \StructType\RecordRef $billingSchedule = null, \StructType\RecordRef $deferredRevenueAccount = null, \StructType\RecordRef $revRecSchedule = null, $minimumQuantity = null, $minimumQuantityUnits = null, $enforceMinQtyInternally = null, $maximumQuantity = null, $softDescriptor = null, $isFulfillable = null, \StructType\RecordRef $costCategory = null, $pricesIncludeTax = null, \StructType\RecordRef $quantityPricingSchedule = null, $useMarginalRates = null, $overallQuantityPricingType = null, \StructType\RecordRef $pricingGroup = null, \StructType\RecordRef $customForm = null, $itemId = null, $upcCode = null, $displayName = null, \StructType\RecordRef $parent = null, $isOnline = null, $isGcoCompliant = null, $offerSupport = null, $isInactive = null, $matrixItemNameTemplate = null, $availableToPartners = null, \StructType\RecordRef $department = null, \StructType\RecordRef $class = null, \StructType\RecordRef $location = null, $vsoePrice = null, $vsoeSopGroup = null, $vsoeDeferral = null, $vsoePermitDiscount = null, $vsoeDelivered = null, \StructType\RecordRef $itemRevenueCategory = null, $deferRevRec = null, \StructType\RecordRef $revenueRecognitionRule = null, \StructType\RecordRef $revRecForecastRule = null, \StructType\RecordRef $revenueAllocationGroup = null, \StructType\RecordRef $createRevenuePlansOn = null, $directRevenuePosting = null, $contingentRevenueHandling = null, \StructType\RecordRef $revReclassFXAccount = null, \StructType\RecordRefList $subsidiaryList = null, \StructType\ItemOptionsList $itemOptionsList = null, \StructType\MatrixOptionList $matrixOptionList = null, \StructType\PricingMatrix $pricingMatrix = null, \StructType\ItemAccountingBookDetailList $accountingBookDetailList = null, \StructType\RecordRef $purchaseTaxCode = null, $rate = null, \StructType\RecordRef $salesTaxCode = null, \StructType\TranslationList $translationsList = null, \StructType\OtherChargeSaleItemHierarchyVersionsList $hierarchyVersionsList = null, \StructType\RecordRef $consumptionUnit = null, \StructType\CustomFieldList $customFieldList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setCreatedDate($createdDate)
            ->setLastModifiedDate($lastModifiedDate)
            ->setSalesDescription($salesDescription)
            ->setIncludeChildren($includeChildren)
            ->setIncomeAccount($incomeAccount)
            ->setIsTaxable($isTaxable)
            ->setMatrixType($matrixType)
            ->setTaxSchedule($taxSchedule)
            ->setCostEstimateType($costEstimateType)
            ->setCostEstimate($costEstimate)
            ->setUnitsType($unitsType)
            ->setSaleUnit($saleUnit)
            ->setIssueProduct($issueProduct)
            ->setCostEstimateUnits($costEstimateUnits)
            ->setBillingSchedule($billingSchedule)
            ->setDeferredRevenueAccount($deferredRevenueAccount)
            ->setRevRecSchedule($revRecSchedule)
            ->setMinimumQuantity($minimumQuantity)
            ->setMinimumQuantityUnits($minimumQuantityUnits)
            ->setEnforceMinQtyInternally($enforceMinQtyInternally)
            ->setMaximumQuantity($maximumQuantity)
            ->setSoftDescriptor($softDescriptor)
            ->setIsFulfillable($isFulfillable)
            ->setCostCategory($costCategory)
            ->setPricesIncludeTax($pricesIncludeTax)
            ->setQuantityPricingSchedule($quantityPricingSchedule)
            ->setUseMarginalRates($useMarginalRates)
            ->setOverallQuantityPricingType($overallQuantityPricingType)
            ->setPricingGroup($pricingGroup)
            ->setCustomForm($customForm)
            ->setItemId($itemId)
            ->setUpcCode($upcCode)
            ->setDisplayName($displayName)
            ->setParent($parent)
            ->setIsOnline($isOnline)
            ->setIsGcoCompliant($isGcoCompliant)
            ->setOfferSupport($offerSupport)
            ->setIsInactive($isInactive)
            ->setMatrixItemNameTemplate($matrixItemNameTemplate)
            ->setAvailableToPartners($availableToPartners)
            ->setDepartment($department)
            ->setClass($class)
            ->setLocation($location)
            ->setVsoePrice($vsoePrice)
            ->setVsoeSopGroup($vsoeSopGroup)
            ->setVsoeDeferral($vsoeDeferral)
            ->setVsoePermitDiscount($vsoePermitDiscount)
            ->setVsoeDelivered($vsoeDelivered)
            ->setItemRevenueCategory($itemRevenueCategory)
            ->setDeferRevRec($deferRevRec)
            ->setRevenueRecognitionRule($revenueRecognitionRule)
            ->setRevRecForecastRule($revRecForecastRule)
            ->setRevenueAllocationGroup($revenueAllocationGroup)
            ->setCreateRevenuePlansOn($createRevenuePlansOn)
            ->setDirectRevenuePosting($directRevenuePosting)
            ->setContingentRevenueHandling($contingentRevenueHandling)
            ->setRevReclassFXAccount($revReclassFXAccount)
            ->setSubsidiaryList($subsidiaryList)
            ->setItemOptionsList($itemOptionsList)
            ->setMatrixOptionList($matrixOptionList)
            ->setPricingMatrix($pricingMatrix)
            ->setAccountingBookDetailList($accountingBookDetailList)
            ->setPurchaseTaxCode($purchaseTaxCode)
            ->setRate($rate)
            ->setSalesTaxCode($salesTaxCode)
            ->setTranslationsList($translationsList)
            ->setHierarchyVersionsList($hierarchyVersionsList)
            ->setConsumptionUnit($consumptionUnit)
            ->setCustomFieldList($customFieldList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get createdDate value
     * @return string|null
     */
    public function getCreatedDate()
    {
        return $this->createdDate;
    }
    /**
     * Set createdDate value
     * @param string $createdDate
     * @return \StructType\OtherChargeSaleItem
     */
    public function setCreatedDate($createdDate = null)
    {
        // validation for constraint: string
        if (!is_null($createdDate) && !is_string($createdDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdDate, true), gettype($createdDate)), __LINE__);
        }
        $this->createdDate = $createdDate;
        return $this;
    }
    /**
     * Get lastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->lastModifiedDate;
    }
    /**
     * Set lastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\OtherChargeSaleItem
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->lastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get salesDescription value
     * @return string|null
     */
    public function getSalesDescription()
    {
        return $this->salesDescription;
    }
    /**
     * Set salesDescription value
     * @param string $salesDescription
     * @return \StructType\OtherChargeSaleItem
     */
    public function setSalesDescription($salesDescription = null)
    {
        // validation for constraint: string
        if (!is_null($salesDescription) && !is_string($salesDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesDescription, true), gettype($salesDescription)), __LINE__);
        }
        $this->salesDescription = $salesDescription;
        return $this;
    }
    /**
     * Get includeChildren value
     * @return bool|null
     */
    public function getIncludeChildren()
    {
        return $this->includeChildren;
    }
    /**
     * Set includeChildren value
     * @param bool $includeChildren
     * @return \StructType\OtherChargeSaleItem
     */
    public function setIncludeChildren($includeChildren = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeChildren) && !is_bool($includeChildren)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeChildren, true), gettype($includeChildren)), __LINE__);
        }
        $this->includeChildren = $includeChildren;
        return $this;
    }
    /**
     * Get incomeAccount value
     * @return \StructType\RecordRef|null
     */
    public function getIncomeAccount()
    {
        return $this->incomeAccount;
    }
    /**
     * Set incomeAccount value
     * @param \StructType\RecordRef $incomeAccount
     * @return \StructType\OtherChargeSaleItem
     */
    public function setIncomeAccount(\StructType\RecordRef $incomeAccount = null)
    {
        $this->incomeAccount = $incomeAccount;
        return $this;
    }
    /**
     * Get isTaxable value
     * @return bool|null
     */
    public function getIsTaxable()
    {
        return $this->isTaxable;
    }
    /**
     * Set isTaxable value
     * @param bool $isTaxable
     * @return \StructType\OtherChargeSaleItem
     */
    public function setIsTaxable($isTaxable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTaxable) && !is_bool($isTaxable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTaxable, true), gettype($isTaxable)), __LINE__);
        }
        $this->isTaxable = $isTaxable;
        return $this;
    }
    /**
     * Get matrixType value
     * @return string|null
     */
    public function getMatrixType()
    {
        return $this->matrixType;
    }
    /**
     * Set matrixType value
     * @uses \EnumType\ItemMatrixType::valueIsValid()
     * @uses \EnumType\ItemMatrixType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $matrixType
     * @return \StructType\OtherChargeSaleItem
     */
    public function setMatrixType($matrixType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ItemMatrixType::valueIsValid($matrixType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ItemMatrixType', is_array($matrixType) ? implode(', ', $matrixType) : var_export($matrixType, true), implode(', ', \EnumType\ItemMatrixType::getValidValues())), __LINE__);
        }
        $this->matrixType = $matrixType;
        return $this;
    }
    /**
     * Get taxSchedule value
     * @return \StructType\RecordRef|null
     */
    public function getTaxSchedule()
    {
        return $this->taxSchedule;
    }
    /**
     * Set taxSchedule value
     * @param \StructType\RecordRef $taxSchedule
     * @return \StructType\OtherChargeSaleItem
     */
    public function setTaxSchedule(\StructType\RecordRef $taxSchedule = null)
    {
        $this->taxSchedule = $taxSchedule;
        return $this;
    }
    /**
     * Get costEstimateType value
     * @return string|null
     */
    public function getCostEstimateType()
    {
        return $this->costEstimateType;
    }
    /**
     * Set costEstimateType value
     * @uses \EnumType\ItemCostEstimateType::valueIsValid()
     * @uses \EnumType\ItemCostEstimateType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $costEstimateType
     * @return \StructType\OtherChargeSaleItem
     */
    public function setCostEstimateType($costEstimateType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ItemCostEstimateType::valueIsValid($costEstimateType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ItemCostEstimateType', is_array($costEstimateType) ? implode(', ', $costEstimateType) : var_export($costEstimateType, true), implode(', ', \EnumType\ItemCostEstimateType::getValidValues())), __LINE__);
        }
        $this->costEstimateType = $costEstimateType;
        return $this;
    }
    /**
     * Get costEstimate value
     * @return float|null
     */
    public function getCostEstimate()
    {
        return $this->costEstimate;
    }
    /**
     * Set costEstimate value
     * @param float $costEstimate
     * @return \StructType\OtherChargeSaleItem
     */
    public function setCostEstimate($costEstimate = null)
    {
        // validation for constraint: float
        if (!is_null($costEstimate) && !(is_float($costEstimate) || is_numeric($costEstimate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($costEstimate, true), gettype($costEstimate)), __LINE__);
        }
        $this->costEstimate = $costEstimate;
        return $this;
    }
    /**
     * Get unitsType value
     * @return \StructType\RecordRef|null
     */
    public function getUnitsType()
    {
        return $this->unitsType;
    }
    /**
     * Set unitsType value
     * @param \StructType\RecordRef $unitsType
     * @return \StructType\OtherChargeSaleItem
     */
    public function setUnitsType(\StructType\RecordRef $unitsType = null)
    {
        $this->unitsType = $unitsType;
        return $this;
    }
    /**
     * Get saleUnit value
     * @return \StructType\RecordRef|null
     */
    public function getSaleUnit()
    {
        return $this->saleUnit;
    }
    /**
     * Set saleUnit value
     * @param \StructType\RecordRef $saleUnit
     * @return \StructType\OtherChargeSaleItem
     */
    public function setSaleUnit(\StructType\RecordRef $saleUnit = null)
    {
        $this->saleUnit = $saleUnit;
        return $this;
    }
    /**
     * Get issueProduct value
     * @return \StructType\RecordRef|null
     */
    public function getIssueProduct()
    {
        return $this->issueProduct;
    }
    /**
     * Set issueProduct value
     * @param \StructType\RecordRef $issueProduct
     * @return \StructType\OtherChargeSaleItem
     */
    public function setIssueProduct(\StructType\RecordRef $issueProduct = null)
    {
        $this->issueProduct = $issueProduct;
        return $this;
    }
    /**
     * Get costEstimateUnits value
     * @return string|null
     */
    public function getCostEstimateUnits()
    {
        return $this->costEstimateUnits;
    }
    /**
     * Set costEstimateUnits value
     * @param string $costEstimateUnits
     * @return \StructType\OtherChargeSaleItem
     */
    public function setCostEstimateUnits($costEstimateUnits = null)
    {
        // validation for constraint: string
        if (!is_null($costEstimateUnits) && !is_string($costEstimateUnits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($costEstimateUnits, true), gettype($costEstimateUnits)), __LINE__);
        }
        $this->costEstimateUnits = $costEstimateUnits;
        return $this;
    }
    /**
     * Get billingSchedule value
     * @return \StructType\RecordRef|null
     */
    public function getBillingSchedule()
    {
        return $this->billingSchedule;
    }
    /**
     * Set billingSchedule value
     * @param \StructType\RecordRef $billingSchedule
     * @return \StructType\OtherChargeSaleItem
     */
    public function setBillingSchedule(\StructType\RecordRef $billingSchedule = null)
    {
        $this->billingSchedule = $billingSchedule;
        return $this;
    }
    /**
     * Get deferredRevenueAccount value
     * @return \StructType\RecordRef|null
     */
    public function getDeferredRevenueAccount()
    {
        return $this->deferredRevenueAccount;
    }
    /**
     * Set deferredRevenueAccount value
     * @param \StructType\RecordRef $deferredRevenueAccount
     * @return \StructType\OtherChargeSaleItem
     */
    public function setDeferredRevenueAccount(\StructType\RecordRef $deferredRevenueAccount = null)
    {
        $this->deferredRevenueAccount = $deferredRevenueAccount;
        return $this;
    }
    /**
     * Get revRecSchedule value
     * @return \StructType\RecordRef|null
     */
    public function getRevRecSchedule()
    {
        return $this->revRecSchedule;
    }
    /**
     * Set revRecSchedule value
     * @param \StructType\RecordRef $revRecSchedule
     * @return \StructType\OtherChargeSaleItem
     */
    public function setRevRecSchedule(\StructType\RecordRef $revRecSchedule = null)
    {
        $this->revRecSchedule = $revRecSchedule;
        return $this;
    }
    /**
     * Get minimumQuantity value
     * @return int|null
     */
    public function getMinimumQuantity()
    {
        return $this->minimumQuantity;
    }
    /**
     * Set minimumQuantity value
     * @param int $minimumQuantity
     * @return \StructType\OtherChargeSaleItem
     */
    public function setMinimumQuantity($minimumQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($minimumQuantity) && !(is_int($minimumQuantity) || ctype_digit($minimumQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minimumQuantity, true), gettype($minimumQuantity)), __LINE__);
        }
        $this->minimumQuantity = $minimumQuantity;
        return $this;
    }
    /**
     * Get minimumQuantityUnits value
     * @return string|null
     */
    public function getMinimumQuantityUnits()
    {
        return $this->minimumQuantityUnits;
    }
    /**
     * Set minimumQuantityUnits value
     * @param string $minimumQuantityUnits
     * @return \StructType\OtherChargeSaleItem
     */
    public function setMinimumQuantityUnits($minimumQuantityUnits = null)
    {
        // validation for constraint: string
        if (!is_null($minimumQuantityUnits) && !is_string($minimumQuantityUnits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minimumQuantityUnits, true), gettype($minimumQuantityUnits)), __LINE__);
        }
        $this->minimumQuantityUnits = $minimumQuantityUnits;
        return $this;
    }
    /**
     * Get enforceMinQtyInternally value
     * @return bool|null
     */
    public function getEnforceMinQtyInternally()
    {
        return $this->enforceMinQtyInternally;
    }
    /**
     * Set enforceMinQtyInternally value
     * @param bool $enforceMinQtyInternally
     * @return \StructType\OtherChargeSaleItem
     */
    public function setEnforceMinQtyInternally($enforceMinQtyInternally = null)
    {
        // validation for constraint: boolean
        if (!is_null($enforceMinQtyInternally) && !is_bool($enforceMinQtyInternally)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enforceMinQtyInternally, true), gettype($enforceMinQtyInternally)), __LINE__);
        }
        $this->enforceMinQtyInternally = $enforceMinQtyInternally;
        return $this;
    }
    /**
     * Get maximumQuantity value
     * @return int|null
     */
    public function getMaximumQuantity()
    {
        return $this->maximumQuantity;
    }
    /**
     * Set maximumQuantity value
     * @param int $maximumQuantity
     * @return \StructType\OtherChargeSaleItem
     */
    public function setMaximumQuantity($maximumQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($maximumQuantity) && !(is_int($maximumQuantity) || ctype_digit($maximumQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maximumQuantity, true), gettype($maximumQuantity)), __LINE__);
        }
        $this->maximumQuantity = $maximumQuantity;
        return $this;
    }
    /**
     * Get softDescriptor value
     * @return string|null
     */
    public function getSoftDescriptor()
    {
        return $this->softDescriptor;
    }
    /**
     * Set softDescriptor value
     * @param string $softDescriptor
     * @return \StructType\OtherChargeSaleItem
     */
    public function setSoftDescriptor($softDescriptor = null)
    {
        // validation for constraint: string
        if (!is_null($softDescriptor) && !is_string($softDescriptor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($softDescriptor, true), gettype($softDescriptor)), __LINE__);
        }
        $this->softDescriptor = $softDescriptor;
        return $this;
    }
    /**
     * Get isFulfillable value
     * @return bool|null
     */
    public function getIsFulfillable()
    {
        return $this->isFulfillable;
    }
    /**
     * Set isFulfillable value
     * @param bool $isFulfillable
     * @return \StructType\OtherChargeSaleItem
     */
    public function setIsFulfillable($isFulfillable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFulfillable) && !is_bool($isFulfillable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFulfillable, true), gettype($isFulfillable)), __LINE__);
        }
        $this->isFulfillable = $isFulfillable;
        return $this;
    }
    /**
     * Get costCategory value
     * @return \StructType\RecordRef|null
     */
    public function getCostCategory()
    {
        return $this->costCategory;
    }
    /**
     * Set costCategory value
     * @param \StructType\RecordRef $costCategory
     * @return \StructType\OtherChargeSaleItem
     */
    public function setCostCategory(\StructType\RecordRef $costCategory = null)
    {
        $this->costCategory = $costCategory;
        return $this;
    }
    /**
     * Get pricesIncludeTax value
     * @return bool|null
     */
    public function getPricesIncludeTax()
    {
        return $this->pricesIncludeTax;
    }
    /**
     * Set pricesIncludeTax value
     * @param bool $pricesIncludeTax
     * @return \StructType\OtherChargeSaleItem
     */
    public function setPricesIncludeTax($pricesIncludeTax = null)
    {
        // validation for constraint: boolean
        if (!is_null($pricesIncludeTax) && !is_bool($pricesIncludeTax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($pricesIncludeTax, true), gettype($pricesIncludeTax)), __LINE__);
        }
        $this->pricesIncludeTax = $pricesIncludeTax;
        return $this;
    }
    /**
     * Get quantityPricingSchedule value
     * @return \StructType\RecordRef|null
     */
    public function getQuantityPricingSchedule()
    {
        return $this->quantityPricingSchedule;
    }
    /**
     * Set quantityPricingSchedule value
     * @param \StructType\RecordRef $quantityPricingSchedule
     * @return \StructType\OtherChargeSaleItem
     */
    public function setQuantityPricingSchedule(\StructType\RecordRef $quantityPricingSchedule = null)
    {
        $this->quantityPricingSchedule = $quantityPricingSchedule;
        return $this;
    }
    /**
     * Get useMarginalRates value
     * @return bool|null
     */
    public function getUseMarginalRates()
    {
        return $this->useMarginalRates;
    }
    /**
     * Set useMarginalRates value
     * @param bool $useMarginalRates
     * @return \StructType\OtherChargeSaleItem
     */
    public function setUseMarginalRates($useMarginalRates = null)
    {
        // validation for constraint: boolean
        if (!is_null($useMarginalRates) && !is_bool($useMarginalRates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useMarginalRates, true), gettype($useMarginalRates)), __LINE__);
        }
        $this->useMarginalRates = $useMarginalRates;
        return $this;
    }
    /**
     * Get overallQuantityPricingType value
     * @return string|null
     */
    public function getOverallQuantityPricingType()
    {
        return $this->overallQuantityPricingType;
    }
    /**
     * Set overallQuantityPricingType value
     * @uses \EnumType\ItemOverallQuantityPricingType::valueIsValid()
     * @uses \EnumType\ItemOverallQuantityPricingType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $overallQuantityPricingType
     * @return \StructType\OtherChargeSaleItem
     */
    public function setOverallQuantityPricingType($overallQuantityPricingType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ItemOverallQuantityPricingType::valueIsValid($overallQuantityPricingType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ItemOverallQuantityPricingType', is_array($overallQuantityPricingType) ? implode(', ', $overallQuantityPricingType) : var_export($overallQuantityPricingType, true), implode(', ', \EnumType\ItemOverallQuantityPricingType::getValidValues())), __LINE__);
        }
        $this->overallQuantityPricingType = $overallQuantityPricingType;
        return $this;
    }
    /**
     * Get pricingGroup value
     * @return \StructType\RecordRef|null
     */
    public function getPricingGroup()
    {
        return $this->pricingGroup;
    }
    /**
     * Set pricingGroup value
     * @param \StructType\RecordRef $pricingGroup
     * @return \StructType\OtherChargeSaleItem
     */
    public function setPricingGroup(\StructType\RecordRef $pricingGroup = null)
    {
        $this->pricingGroup = $pricingGroup;
        return $this;
    }
    /**
     * Get customForm value
     * @return \StructType\RecordRef|null
     */
    public function getCustomForm()
    {
        return $this->customForm;
    }
    /**
     * Set customForm value
     * @param \StructType\RecordRef $customForm
     * @return \StructType\OtherChargeSaleItem
     */
    public function setCustomForm(\StructType\RecordRef $customForm = null)
    {
        $this->customForm = $customForm;
        return $this;
    }
    /**
     * Get itemId value
     * @return string|null
     */
    public function getItemId()
    {
        return $this->itemId;
    }
    /**
     * Set itemId value
     * @param string $itemId
     * @return \StructType\OtherChargeSaleItem
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: string
        if (!is_null($itemId) && !is_string($itemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        $this->itemId = $itemId;
        return $this;
    }
    /**
     * Get upcCode value
     * @return string|null
     */
    public function getUpcCode()
    {
        return $this->upcCode;
    }
    /**
     * Set upcCode value
     * @param string $upcCode
     * @return \StructType\OtherChargeSaleItem
     */
    public function setUpcCode($upcCode = null)
    {
        // validation for constraint: string
        if (!is_null($upcCode) && !is_string($upcCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($upcCode, true), gettype($upcCode)), __LINE__);
        }
        $this->upcCode = $upcCode;
        return $this;
    }
    /**
     * Get displayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->displayName;
    }
    /**
     * Set displayName value
     * @param string $displayName
     * @return \StructType\OtherChargeSaleItem
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->displayName = $displayName;
        return $this;
    }
    /**
     * Get parent value
     * @return \StructType\RecordRef|null
     */
    public function getParent()
    {
        return $this->parent;
    }
    /**
     * Set parent value
     * @param \StructType\RecordRef $parent
     * @return \StructType\OtherChargeSaleItem
     */
    public function setParent(\StructType\RecordRef $parent = null)
    {
        $this->parent = $parent;
        return $this;
    }
    /**
     * Get isOnline value
     * @return bool|null
     */
    public function getIsOnline()
    {
        return $this->isOnline;
    }
    /**
     * Set isOnline value
     * @param bool $isOnline
     * @return \StructType\OtherChargeSaleItem
     */
    public function setIsOnline($isOnline = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOnline) && !is_bool($isOnline)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isOnline, true), gettype($isOnline)), __LINE__);
        }
        $this->isOnline = $isOnline;
        return $this;
    }
    /**
     * Get isGcoCompliant value
     * @return bool|null
     */
    public function getIsGcoCompliant()
    {
        return $this->isGcoCompliant;
    }
    /**
     * Set isGcoCompliant value
     * @param bool $isGcoCompliant
     * @return \StructType\OtherChargeSaleItem
     */
    public function setIsGcoCompliant($isGcoCompliant = null)
    {
        // validation for constraint: boolean
        if (!is_null($isGcoCompliant) && !is_bool($isGcoCompliant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isGcoCompliant, true), gettype($isGcoCompliant)), __LINE__);
        }
        $this->isGcoCompliant = $isGcoCompliant;
        return $this;
    }
    /**
     * Get offerSupport value
     * @return bool|null
     */
    public function getOfferSupport()
    {
        return $this->offerSupport;
    }
    /**
     * Set offerSupport value
     * @param bool $offerSupport
     * @return \StructType\OtherChargeSaleItem
     */
    public function setOfferSupport($offerSupport = null)
    {
        // validation for constraint: boolean
        if (!is_null($offerSupport) && !is_bool($offerSupport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($offerSupport, true), gettype($offerSupport)), __LINE__);
        }
        $this->offerSupport = $offerSupport;
        return $this;
    }
    /**
     * Get isInactive value
     * @return bool|null
     */
    public function getIsInactive()
    {
        return $this->isInactive;
    }
    /**
     * Set isInactive value
     * @param bool $isInactive
     * @return \StructType\OtherChargeSaleItem
     */
    public function setIsInactive($isInactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInactive) && !is_bool($isInactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInactive, true), gettype($isInactive)), __LINE__);
        }
        $this->isInactive = $isInactive;
        return $this;
    }
    /**
     * Get matrixItemNameTemplate value
     * @return string|null
     */
    public function getMatrixItemNameTemplate()
    {
        return $this->matrixItemNameTemplate;
    }
    /**
     * Set matrixItemNameTemplate value
     * @param string $matrixItemNameTemplate
     * @return \StructType\OtherChargeSaleItem
     */
    public function setMatrixItemNameTemplate($matrixItemNameTemplate = null)
    {
        // validation for constraint: string
        if (!is_null($matrixItemNameTemplate) && !is_string($matrixItemNameTemplate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($matrixItemNameTemplate, true), gettype($matrixItemNameTemplate)), __LINE__);
        }
        $this->matrixItemNameTemplate = $matrixItemNameTemplate;
        return $this;
    }
    /**
     * Get availableToPartners value
     * @return bool|null
     */
    public function getAvailableToPartners()
    {
        return $this->availableToPartners;
    }
    /**
     * Set availableToPartners value
     * @param bool $availableToPartners
     * @return \StructType\OtherChargeSaleItem
     */
    public function setAvailableToPartners($availableToPartners = null)
    {
        // validation for constraint: boolean
        if (!is_null($availableToPartners) && !is_bool($availableToPartners)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($availableToPartners, true), gettype($availableToPartners)), __LINE__);
        }
        $this->availableToPartners = $availableToPartners;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\OtherChargeSaleItem
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\OtherChargeSaleItem
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\OtherChargeSaleItem
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get vsoePrice value
     * @return float|null
     */
    public function getVsoePrice()
    {
        return $this->vsoePrice;
    }
    /**
     * Set vsoePrice value
     * @param float $vsoePrice
     * @return \StructType\OtherChargeSaleItem
     */
    public function setVsoePrice($vsoePrice = null)
    {
        // validation for constraint: float
        if (!is_null($vsoePrice) && !(is_float($vsoePrice) || is_numeric($vsoePrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($vsoePrice, true), gettype($vsoePrice)), __LINE__);
        }
        $this->vsoePrice = $vsoePrice;
        return $this;
    }
    /**
     * Get vsoeSopGroup value
     * @return string|null
     */
    public function getVsoeSopGroup()
    {
        return $this->vsoeSopGroup;
    }
    /**
     * Set vsoeSopGroup value
     * @uses \EnumType\VsoeSopGroup::valueIsValid()
     * @uses \EnumType\VsoeSopGroup::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vsoeSopGroup
     * @return \StructType\OtherChargeSaleItem
     */
    public function setVsoeSopGroup($vsoeSopGroup = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VsoeSopGroup::valueIsValid($vsoeSopGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\VsoeSopGroup', is_array($vsoeSopGroup) ? implode(', ', $vsoeSopGroup) : var_export($vsoeSopGroup, true), implode(', ', \EnumType\VsoeSopGroup::getValidValues())), __LINE__);
        }
        $this->vsoeSopGroup = $vsoeSopGroup;
        return $this;
    }
    /**
     * Get vsoeDeferral value
     * @return string|null
     */
    public function getVsoeDeferral()
    {
        return $this->vsoeDeferral;
    }
    /**
     * Set vsoeDeferral value
     * @uses \EnumType\VsoeDeferral::valueIsValid()
     * @uses \EnumType\VsoeDeferral::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vsoeDeferral
     * @return \StructType\OtherChargeSaleItem
     */
    public function setVsoeDeferral($vsoeDeferral = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VsoeDeferral::valueIsValid($vsoeDeferral)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\VsoeDeferral', is_array($vsoeDeferral) ? implode(', ', $vsoeDeferral) : var_export($vsoeDeferral, true), implode(', ', \EnumType\VsoeDeferral::getValidValues())), __LINE__);
        }
        $this->vsoeDeferral = $vsoeDeferral;
        return $this;
    }
    /**
     * Get vsoePermitDiscount value
     * @return string|null
     */
    public function getVsoePermitDiscount()
    {
        return $this->vsoePermitDiscount;
    }
    /**
     * Set vsoePermitDiscount value
     * @uses \EnumType\VsoePermitDiscount::valueIsValid()
     * @uses \EnumType\VsoePermitDiscount::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vsoePermitDiscount
     * @return \StructType\OtherChargeSaleItem
     */
    public function setVsoePermitDiscount($vsoePermitDiscount = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VsoePermitDiscount::valueIsValid($vsoePermitDiscount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\VsoePermitDiscount', is_array($vsoePermitDiscount) ? implode(', ', $vsoePermitDiscount) : var_export($vsoePermitDiscount, true), implode(', ', \EnumType\VsoePermitDiscount::getValidValues())), __LINE__);
        }
        $this->vsoePermitDiscount = $vsoePermitDiscount;
        return $this;
    }
    /**
     * Get vsoeDelivered value
     * @return bool|null
     */
    public function getVsoeDelivered()
    {
        return $this->vsoeDelivered;
    }
    /**
     * Set vsoeDelivered value
     * @param bool $vsoeDelivered
     * @return \StructType\OtherChargeSaleItem
     */
    public function setVsoeDelivered($vsoeDelivered = null)
    {
        // validation for constraint: boolean
        if (!is_null($vsoeDelivered) && !is_bool($vsoeDelivered)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($vsoeDelivered, true), gettype($vsoeDelivered)), __LINE__);
        }
        $this->vsoeDelivered = $vsoeDelivered;
        return $this;
    }
    /**
     * Get itemRevenueCategory value
     * @return \StructType\RecordRef|null
     */
    public function getItemRevenueCategory()
    {
        return $this->itemRevenueCategory;
    }
    /**
     * Set itemRevenueCategory value
     * @param \StructType\RecordRef $itemRevenueCategory
     * @return \StructType\OtherChargeSaleItem
     */
    public function setItemRevenueCategory(\StructType\RecordRef $itemRevenueCategory = null)
    {
        $this->itemRevenueCategory = $itemRevenueCategory;
        return $this;
    }
    /**
     * Get deferRevRec value
     * @return bool|null
     */
    public function getDeferRevRec()
    {
        return $this->deferRevRec;
    }
    /**
     * Set deferRevRec value
     * @param bool $deferRevRec
     * @return \StructType\OtherChargeSaleItem
     */
    public function setDeferRevRec($deferRevRec = null)
    {
        // validation for constraint: boolean
        if (!is_null($deferRevRec) && !is_bool($deferRevRec)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($deferRevRec, true), gettype($deferRevRec)), __LINE__);
        }
        $this->deferRevRec = $deferRevRec;
        return $this;
    }
    /**
     * Get revenueRecognitionRule value
     * @return \StructType\RecordRef|null
     */
    public function getRevenueRecognitionRule()
    {
        return $this->revenueRecognitionRule;
    }
    /**
     * Set revenueRecognitionRule value
     * @param \StructType\RecordRef $revenueRecognitionRule
     * @return \StructType\OtherChargeSaleItem
     */
    public function setRevenueRecognitionRule(\StructType\RecordRef $revenueRecognitionRule = null)
    {
        $this->revenueRecognitionRule = $revenueRecognitionRule;
        return $this;
    }
    /**
     * Get revRecForecastRule value
     * @return \StructType\RecordRef|null
     */
    public function getRevRecForecastRule()
    {
        return $this->revRecForecastRule;
    }
    /**
     * Set revRecForecastRule value
     * @param \StructType\RecordRef $revRecForecastRule
     * @return \StructType\OtherChargeSaleItem
     */
    public function setRevRecForecastRule(\StructType\RecordRef $revRecForecastRule = null)
    {
        $this->revRecForecastRule = $revRecForecastRule;
        return $this;
    }
    /**
     * Get revenueAllocationGroup value
     * @return \StructType\RecordRef|null
     */
    public function getRevenueAllocationGroup()
    {
        return $this->revenueAllocationGroup;
    }
    /**
     * Set revenueAllocationGroup value
     * @param \StructType\RecordRef $revenueAllocationGroup
     * @return \StructType\OtherChargeSaleItem
     */
    public function setRevenueAllocationGroup(\StructType\RecordRef $revenueAllocationGroup = null)
    {
        $this->revenueAllocationGroup = $revenueAllocationGroup;
        return $this;
    }
    /**
     * Get createRevenuePlansOn value
     * @return \StructType\RecordRef|null
     */
    public function getCreateRevenuePlansOn()
    {
        return $this->createRevenuePlansOn;
    }
    /**
     * Set createRevenuePlansOn value
     * @param \StructType\RecordRef $createRevenuePlansOn
     * @return \StructType\OtherChargeSaleItem
     */
    public function setCreateRevenuePlansOn(\StructType\RecordRef $createRevenuePlansOn = null)
    {
        $this->createRevenuePlansOn = $createRevenuePlansOn;
        return $this;
    }
    /**
     * Get directRevenuePosting value
     * @return bool|null
     */
    public function getDirectRevenuePosting()
    {
        return $this->directRevenuePosting;
    }
    /**
     * Set directRevenuePosting value
     * @param bool $directRevenuePosting
     * @return \StructType\OtherChargeSaleItem
     */
    public function setDirectRevenuePosting($directRevenuePosting = null)
    {
        // validation for constraint: boolean
        if (!is_null($directRevenuePosting) && !is_bool($directRevenuePosting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($directRevenuePosting, true), gettype($directRevenuePosting)), __LINE__);
        }
        $this->directRevenuePosting = $directRevenuePosting;
        return $this;
    }
    /**
     * Get contingentRevenueHandling value
     * @return bool|null
     */
    public function getContingentRevenueHandling()
    {
        return $this->contingentRevenueHandling;
    }
    /**
     * Set contingentRevenueHandling value
     * @param bool $contingentRevenueHandling
     * @return \StructType\OtherChargeSaleItem
     */
    public function setContingentRevenueHandling($contingentRevenueHandling = null)
    {
        // validation for constraint: boolean
        if (!is_null($contingentRevenueHandling) && !is_bool($contingentRevenueHandling)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($contingentRevenueHandling, true), gettype($contingentRevenueHandling)), __LINE__);
        }
        $this->contingentRevenueHandling = $contingentRevenueHandling;
        return $this;
    }
    /**
     * Get revReclassFXAccount value
     * @return \StructType\RecordRef|null
     */
    public function getRevReclassFXAccount()
    {
        return $this->revReclassFXAccount;
    }
    /**
     * Set revReclassFXAccount value
     * @param \StructType\RecordRef $revReclassFXAccount
     * @return \StructType\OtherChargeSaleItem
     */
    public function setRevReclassFXAccount(\StructType\RecordRef $revReclassFXAccount = null)
    {
        $this->revReclassFXAccount = $revReclassFXAccount;
        return $this;
    }
    /**
     * Get subsidiaryList value
     * @return \StructType\RecordRefList|null
     */
    public function getSubsidiaryList()
    {
        return $this->subsidiaryList;
    }
    /**
     * Set subsidiaryList value
     * @param \StructType\RecordRefList $subsidiaryList
     * @return \StructType\OtherChargeSaleItem
     */
    public function setSubsidiaryList(\StructType\RecordRefList $subsidiaryList = null)
    {
        $this->subsidiaryList = $subsidiaryList;
        return $this;
    }
    /**
     * Get itemOptionsList value
     * @return \StructType\ItemOptionsList|null
     */
    public function getItemOptionsList()
    {
        return $this->itemOptionsList;
    }
    /**
     * Set itemOptionsList value
     * @param \StructType\ItemOptionsList $itemOptionsList
     * @return \StructType\OtherChargeSaleItem
     */
    public function setItemOptionsList(\StructType\ItemOptionsList $itemOptionsList = null)
    {
        $this->itemOptionsList = $itemOptionsList;
        return $this;
    }
    /**
     * Get matrixOptionList value
     * @return \StructType\MatrixOptionList|null
     */
    public function getMatrixOptionList()
    {
        return $this->matrixOptionList;
    }
    /**
     * Set matrixOptionList value
     * @param \StructType\MatrixOptionList $matrixOptionList
     * @return \StructType\OtherChargeSaleItem
     */
    public function setMatrixOptionList(\StructType\MatrixOptionList $matrixOptionList = null)
    {
        $this->matrixOptionList = $matrixOptionList;
        return $this;
    }
    /**
     * Get pricingMatrix value
     * @return \StructType\PricingMatrix|null
     */
    public function getPricingMatrix()
    {
        return $this->pricingMatrix;
    }
    /**
     * Set pricingMatrix value
     * @param \StructType\PricingMatrix $pricingMatrix
     * @return \StructType\OtherChargeSaleItem
     */
    public function setPricingMatrix(\StructType\PricingMatrix $pricingMatrix = null)
    {
        $this->pricingMatrix = $pricingMatrix;
        return $this;
    }
    /**
     * Get accountingBookDetailList value
     * @return \StructType\ItemAccountingBookDetailList|null
     */
    public function getAccountingBookDetailList()
    {
        return $this->accountingBookDetailList;
    }
    /**
     * Set accountingBookDetailList value
     * @param \StructType\ItemAccountingBookDetailList $accountingBookDetailList
     * @return \StructType\OtherChargeSaleItem
     */
    public function setAccountingBookDetailList(\StructType\ItemAccountingBookDetailList $accountingBookDetailList = null)
    {
        $this->accountingBookDetailList = $accountingBookDetailList;
        return $this;
    }
    /**
     * Get purchaseTaxCode value
     * @return \StructType\RecordRef|null
     */
    public function getPurchaseTaxCode()
    {
        return $this->purchaseTaxCode;
    }
    /**
     * Set purchaseTaxCode value
     * @param \StructType\RecordRef $purchaseTaxCode
     * @return \StructType\OtherChargeSaleItem
     */
    public function setPurchaseTaxCode(\StructType\RecordRef $purchaseTaxCode = null)
    {
        $this->purchaseTaxCode = $purchaseTaxCode;
        return $this;
    }
    /**
     * Get rate value
     * @return float|null
     */
    public function getRate()
    {
        return $this->rate;
    }
    /**
     * Set rate value
     * @param float $rate
     * @return \StructType\OtherChargeSaleItem
     */
    public function setRate($rate = null)
    {
        // validation for constraint: float
        if (!is_null($rate) && !(is_float($rate) || is_numeric($rate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($rate, true), gettype($rate)), __LINE__);
        }
        $this->rate = $rate;
        return $this;
    }
    /**
     * Get salesTaxCode value
     * @return \StructType\RecordRef|null
     */
    public function getSalesTaxCode()
    {
        return $this->salesTaxCode;
    }
    /**
     * Set salesTaxCode value
     * @param \StructType\RecordRef $salesTaxCode
     * @return \StructType\OtherChargeSaleItem
     */
    public function setSalesTaxCode(\StructType\RecordRef $salesTaxCode = null)
    {
        $this->salesTaxCode = $salesTaxCode;
        return $this;
    }
    /**
     * Get translationsList value
     * @return \StructType\TranslationList|null
     */
    public function getTranslationsList()
    {
        return $this->translationsList;
    }
    /**
     * Set translationsList value
     * @param \StructType\TranslationList $translationsList
     * @return \StructType\OtherChargeSaleItem
     */
    public function setTranslationsList(\StructType\TranslationList $translationsList = null)
    {
        $this->translationsList = $translationsList;
        return $this;
    }
    /**
     * Get hierarchyVersionsList value
     * @return \StructType\OtherChargeSaleItemHierarchyVersionsList|null
     */
    public function getHierarchyVersionsList()
    {
        return $this->hierarchyVersionsList;
    }
    /**
     * Set hierarchyVersionsList value
     * @param \StructType\OtherChargeSaleItemHierarchyVersionsList $hierarchyVersionsList
     * @return \StructType\OtherChargeSaleItem
     */
    public function setHierarchyVersionsList(\StructType\OtherChargeSaleItemHierarchyVersionsList $hierarchyVersionsList = null)
    {
        $this->hierarchyVersionsList = $hierarchyVersionsList;
        return $this;
    }
    /**
     * Get consumptionUnit value
     * @return \StructType\RecordRef|null
     */
    public function getConsumptionUnit()
    {
        return $this->consumptionUnit;
    }
    /**
     * Set consumptionUnit value
     * @param \StructType\RecordRef $consumptionUnit
     * @return \StructType\OtherChargeSaleItem
     */
    public function setConsumptionUnit(\StructType\RecordRef $consumptionUnit = null)
    {
        $this->consumptionUnit = $consumptionUnit;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\OtherChargeSaleItem
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\OtherChargeSaleItem
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\OtherChargeSaleItem
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
