<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OpportunityCompetitors StructType
 * @subpackage Structs
 */
class OpportunityCompetitors extends AbstractStructBase
{
    /**
     * The competitor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $competitor;
    /**
     * The url
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $url;
    /**
     * The notes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $notes;
    /**
     * The strategy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $strategy;
    /**
     * The winner
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $winner;
    /**
     * Constructor method for OpportunityCompetitors
     * @uses OpportunityCompetitors::setCompetitor()
     * @uses OpportunityCompetitors::setUrl()
     * @uses OpportunityCompetitors::setNotes()
     * @uses OpportunityCompetitors::setStrategy()
     * @uses OpportunityCompetitors::setWinner()
     * @param \StructType\RecordRef $competitor
     * @param string $url
     * @param string $notes
     * @param string $strategy
     * @param bool $winner
     */
    public function __construct(\StructType\RecordRef $competitor = null, $url = null, $notes = null, $strategy = null, $winner = null)
    {
        $this
            ->setCompetitor($competitor)
            ->setUrl($url)
            ->setNotes($notes)
            ->setStrategy($strategy)
            ->setWinner($winner);
    }
    /**
     * Get competitor value
     * @return \StructType\RecordRef|null
     */
    public function getCompetitor()
    {
        return $this->competitor;
    }
    /**
     * Set competitor value
     * @param \StructType\RecordRef $competitor
     * @return \StructType\OpportunityCompetitors
     */
    public function setCompetitor(\StructType\RecordRef $competitor = null)
    {
        $this->competitor = $competitor;
        return $this;
    }
    /**
     * Get url value
     * @return string|null
     */
    public function getUrl()
    {
        return $this->url;
    }
    /**
     * Set url value
     * @param string $url
     * @return \StructType\OpportunityCompetitors
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($url, true), gettype($url)), __LINE__);
        }
        $this->url = $url;
        return $this;
    }
    /**
     * Get notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->notes;
    }
    /**
     * Set notes value
     * @param string $notes
     * @return \StructType\OpportunityCompetitors
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notes, true), gettype($notes)), __LINE__);
        }
        $this->notes = $notes;
        return $this;
    }
    /**
     * Get strategy value
     * @return string|null
     */
    public function getStrategy()
    {
        return $this->strategy;
    }
    /**
     * Set strategy value
     * @param string $strategy
     * @return \StructType\OpportunityCompetitors
     */
    public function setStrategy($strategy = null)
    {
        // validation for constraint: string
        if (!is_null($strategy) && !is_string($strategy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($strategy, true), gettype($strategy)), __LINE__);
        }
        $this->strategy = $strategy;
        return $this;
    }
    /**
     * Get winner value
     * @return bool|null
     */
    public function getWinner()
    {
        return $this->winner;
    }
    /**
     * Set winner value
     * @param bool $winner
     * @return \StructType\OpportunityCompetitors
     */
    public function setWinner($winner = null)
    {
        // validation for constraint: boolean
        if (!is_null($winner) && !is_bool($winner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($winner, true), gettype($winner)), __LINE__);
        }
        $this->winner = $winner;
        return $this;
    }
}
