<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Note StructType
 * Meta information extracted from the WSDL
 * - type: generalComm:Note
 * @subpackage Structs
 */
class Note extends Record
{
    /**
     * The title
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $title;
    /**
     * The noteType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $noteType;
    /**
     * The direction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $direction;
    /**
     * The noteDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $noteDate;
    /**
     * The note
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $note;
    /**
     * The lastModifiedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lastModifiedDate;
    /**
     * The activity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $activity;
    /**
     * The author
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $author;
    /**
     * The entity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $entity;
    /**
     * The folder
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $folder;
    /**
     * The item
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $item;
    /**
     * The media
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $media;
    /**
     * The record
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $record;
    /**
     * The recordType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $recordType;
    /**
     * The topic
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $topic;
    /**
     * The transaction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $transaction;
    /**
     * The customForm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $customForm;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * The internalId
     * @var string
     */
    public $internalId;
    /**
     * The externalId
     * @var string
     */
    public $externalId;
    /**
     * Constructor method for Note
     * @uses Note::setTitle()
     * @uses Note::setNoteType()
     * @uses Note::setDirection()
     * @uses Note::setNoteDate()
     * @uses Note::setNote()
     * @uses Note::setLastModifiedDate()
     * @uses Note::setActivity()
     * @uses Note::setAuthor()
     * @uses Note::setEntity()
     * @uses Note::setFolder()
     * @uses Note::setItem()
     * @uses Note::setMedia()
     * @uses Note::setRecord()
     * @uses Note::setRecordType()
     * @uses Note::setTopic()
     * @uses Note::setTransaction()
     * @uses Note::setCustomForm()
     * @uses Note::setCustomFieldList()
     * @uses Note::setInternalId()
     * @uses Note::setExternalId()
     * @param string $title
     * @param \StructType\RecordRef $noteType
     * @param string $direction
     * @param string $noteDate
     * @param string $note
     * @param string $lastModifiedDate
     * @param \StructType\RecordRef $activity
     * @param \StructType\RecordRef $author
     * @param \StructType\RecordRef $entity
     * @param \StructType\RecordRef $folder
     * @param \StructType\RecordRef $item
     * @param \StructType\RecordRef $media
     * @param \StructType\RecordRef $record
     * @param \StructType\RecordRef $recordType
     * @param \StructType\RecordRef $topic
     * @param \StructType\RecordRef $transaction
     * @param \StructType\RecordRef $customForm
     * @param \StructType\CustomFieldList $customFieldList
     * @param string $internalId
     * @param string $externalId
     */
    public function __construct($title = null, \StructType\RecordRef $noteType = null, $direction = null, $noteDate = null, $note = null, $lastModifiedDate = null, \StructType\RecordRef $activity = null, \StructType\RecordRef $author = null, \StructType\RecordRef $entity = null, \StructType\RecordRef $folder = null, \StructType\RecordRef $item = null, \StructType\RecordRef $media = null, \StructType\RecordRef $record = null, \StructType\RecordRef $recordType = null, \StructType\RecordRef $topic = null, \StructType\RecordRef $transaction = null, \StructType\RecordRef $customForm = null, \StructType\CustomFieldList $customFieldList = null, $internalId = null, $externalId = null)
    {
        $this
            ->setTitle($title)
            ->setNoteType($noteType)
            ->setDirection($direction)
            ->setNoteDate($noteDate)
            ->setNote($note)
            ->setLastModifiedDate($lastModifiedDate)
            ->setActivity($activity)
            ->setAuthor($author)
            ->setEntity($entity)
            ->setFolder($folder)
            ->setItem($item)
            ->setMedia($media)
            ->setRecord($record)
            ->setRecordType($recordType)
            ->setTopic($topic)
            ->setTransaction($transaction)
            ->setCustomForm($customForm)
            ->setCustomFieldList($customFieldList)
            ->setInternalId($internalId)
            ->setExternalId($externalId);
    }
    /**
     * Get title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \StructType\Note
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get noteType value
     * @return \StructType\RecordRef|null
     */
    public function getNoteType()
    {
        return $this->noteType;
    }
    /**
     * Set noteType value
     * @param \StructType\RecordRef $noteType
     * @return \StructType\Note
     */
    public function setNoteType(\StructType\RecordRef $noteType = null)
    {
        $this->noteType = $noteType;
        return $this;
    }
    /**
     * Get direction value
     * @return string|null
     */
    public function getDirection()
    {
        return $this->direction;
    }
    /**
     * Set direction value
     * @uses \EnumType\NoteDirection::valueIsValid()
     * @uses \EnumType\NoteDirection::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $direction
     * @return \StructType\Note
     */
    public function setDirection($direction = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\NoteDirection::valueIsValid($direction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\NoteDirection', is_array($direction) ? implode(', ', $direction) : var_export($direction, true), implode(', ', \EnumType\NoteDirection::getValidValues())), __LINE__);
        }
        $this->direction = $direction;
        return $this;
    }
    /**
     * Get noteDate value
     * @return string|null
     */
    public function getNoteDate()
    {
        return $this->noteDate;
    }
    /**
     * Set noteDate value
     * @param string $noteDate
     * @return \StructType\Note
     */
    public function setNoteDate($noteDate = null)
    {
        // validation for constraint: string
        if (!is_null($noteDate) && !is_string($noteDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($noteDate, true), gettype($noteDate)), __LINE__);
        }
        $this->noteDate = $noteDate;
        return $this;
    }
    /**
     * Get note value
     * @return string|null
     */
    public function getNote()
    {
        return $this->note;
    }
    /**
     * Set note value
     * @param string $note
     * @return \StructType\Note
     */
    public function setNote($note = null)
    {
        // validation for constraint: string
        if (!is_null($note) && !is_string($note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($note, true), gettype($note)), __LINE__);
        }
        $this->note = $note;
        return $this;
    }
    /**
     * Get lastModifiedDate value
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return $this->lastModifiedDate;
    }
    /**
     * Set lastModifiedDate value
     * @param string $lastModifiedDate
     * @return \StructType\Note
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        $this->lastModifiedDate = $lastModifiedDate;
        return $this;
    }
    /**
     * Get activity value
     * @return \StructType\RecordRef|null
     */
    public function getActivity()
    {
        return $this->activity;
    }
    /**
     * Set activity value
     * @param \StructType\RecordRef $activity
     * @return \StructType\Note
     */
    public function setActivity(\StructType\RecordRef $activity = null)
    {
        $this->activity = $activity;
        return $this;
    }
    /**
     * Get author value
     * @return \StructType\RecordRef|null
     */
    public function getAuthor()
    {
        return $this->author;
    }
    /**
     * Set author value
     * @param \StructType\RecordRef $author
     * @return \StructType\Note
     */
    public function setAuthor(\StructType\RecordRef $author = null)
    {
        $this->author = $author;
        return $this;
    }
    /**
     * Get entity value
     * @return \StructType\RecordRef|null
     */
    public function getEntity()
    {
        return $this->entity;
    }
    /**
     * Set entity value
     * @param \StructType\RecordRef $entity
     * @return \StructType\Note
     */
    public function setEntity(\StructType\RecordRef $entity = null)
    {
        $this->entity = $entity;
        return $this;
    }
    /**
     * Get folder value
     * @return \StructType\RecordRef|null
     */
    public function getFolder()
    {
        return $this->folder;
    }
    /**
     * Set folder value
     * @param \StructType\RecordRef $folder
     * @return \StructType\Note
     */
    public function setFolder(\StructType\RecordRef $folder = null)
    {
        $this->folder = $folder;
        return $this;
    }
    /**
     * Get item value
     * @return \StructType\RecordRef|null
     */
    public function getItem()
    {
        return $this->item;
    }
    /**
     * Set item value
     * @param \StructType\RecordRef $item
     * @return \StructType\Note
     */
    public function setItem(\StructType\RecordRef $item = null)
    {
        $this->item = $item;
        return $this;
    }
    /**
     * Get media value
     * @return \StructType\RecordRef|null
     */
    public function getMedia()
    {
        return $this->media;
    }
    /**
     * Set media value
     * @param \StructType\RecordRef $media
     * @return \StructType\Note
     */
    public function setMedia(\StructType\RecordRef $media = null)
    {
        $this->media = $media;
        return $this;
    }
    /**
     * Get record value
     * @return \StructType\RecordRef|null
     */
    public function getRecord()
    {
        return $this->record;
    }
    /**
     * Set record value
     * @param \StructType\RecordRef $record
     * @return \StructType\Note
     */
    public function setRecord(\StructType\RecordRef $record = null)
    {
        $this->record = $record;
        return $this;
    }
    /**
     * Get recordType value
     * @return \StructType\RecordRef|null
     */
    public function getRecordType()
    {
        return $this->recordType;
    }
    /**
     * Set recordType value
     * @param \StructType\RecordRef $recordType
     * @return \StructType\Note
     */
    public function setRecordType(\StructType\RecordRef $recordType = null)
    {
        $this->recordType = $recordType;
        return $this;
    }
    /**
     * Get topic value
     * @return \StructType\RecordRef|null
     */
    public function getTopic()
    {
        return $this->topic;
    }
    /**
     * Set topic value
     * @param \StructType\RecordRef $topic
     * @return \StructType\Note
     */
    public function setTopic(\StructType\RecordRef $topic = null)
    {
        $this->topic = $topic;
        return $this;
    }
    /**
     * Get transaction value
     * @return \StructType\RecordRef|null
     */
    public function getTransaction()
    {
        return $this->transaction;
    }
    /**
     * Set transaction value
     * @param \StructType\RecordRef $transaction
     * @return \StructType\Note
     */
    public function setTransaction(\StructType\RecordRef $transaction = null)
    {
        $this->transaction = $transaction;
        return $this;
    }
    /**
     * Get customForm value
     * @return \StructType\RecordRef|null
     */
    public function getCustomForm()
    {
        return $this->customForm;
    }
    /**
     * Set customForm value
     * @param \StructType\RecordRef $customForm
     * @return \StructType\Note
     */
    public function setCustomForm(\StructType\RecordRef $customForm = null)
    {
        $this->customForm = $customForm;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\Note
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
    /**
     * Get internalId value
     * @return string|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param string $internalId
     * @return \StructType\Note
     */
    public function setInternalId($internalId = null)
    {
        // validation for constraint: string
        if (!is_null($internalId) && !is_string($internalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalId, true), gettype($internalId)), __LINE__);
        }
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get externalId value
     * @return string|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param string $externalId
     * @return \StructType\Note
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        $this->externalId = $externalId;
        return $this;
    }
}
