<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MultiSelectCustomFieldRef StructType
 * @subpackage Structs
 */
class MultiSelectCustomFieldRef extends CustomFieldRef
{
    /**
     * The value
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\ListOrRecordRef[]
     */
    public $value;
    /**
     * Constructor method for MultiSelectCustomFieldRef
     * @uses MultiSelectCustomFieldRef::setValue()
     * @param \StructType\ListOrRecordRef[] $value
     */
    public function __construct(array $value = array())
    {
        $this
            ->setValue($value);
    }
    /**
     * Get value value
     * @return \StructType\ListOrRecordRef[]|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * This method is responsible for validating the values passed to the setValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setValue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateValueForArrayConstraintsFromSetValue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $multiSelectCustomFieldRefValueItem) {
            // validation for constraint: itemType
            if (!$multiSelectCustomFieldRefValueItem instanceof \StructType\ListOrRecordRef) {
                $invalidValues[] = is_object($multiSelectCustomFieldRefValueItem) ? get_class($multiSelectCustomFieldRefValueItem) : sprintf('%s(%s)', gettype($multiSelectCustomFieldRefValueItem), var_export($multiSelectCustomFieldRefValueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The value property can only contain items of type \StructType\ListOrRecordRef, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set value value
     * @throws \InvalidArgumentException
     * @param \StructType\ListOrRecordRef[] $value
     * @return \StructType\MultiSelectCustomFieldRef
     */
    public function setValue(array $value = array())
    {
        // validation for constraint: array
        if ('' !== ($valueArrayErrorMessage = self::validateValueForArrayConstraintsFromSetValue($value))) {
            throw new \InvalidArgumentException($valueArrayErrorMessage, __LINE__);
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Add item to value value
     * @throws \InvalidArgumentException
     * @param \StructType\ListOrRecordRef $item
     * @return \StructType\MultiSelectCustomFieldRef
     */
    public function addToValue(\StructType\ListOrRecordRef $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ListOrRecordRef) {
            throw new \InvalidArgumentException(sprintf('The value property can only contain items of type \StructType\ListOrRecordRef, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->value[] = $item;
        return $this;
    }
}
