<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MessageMediaItemList StructType
 * @subpackage Structs
 */
class MessageMediaItemList extends AbstractStructBase
{
    /**
     * The mediaItem
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\File[]
     */
    public $mediaItem;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for MessageMediaItemList
     * @uses MessageMediaItemList::setMediaItem()
     * @uses MessageMediaItemList::setReplaceAll()
     * @param \StructType\File[] $mediaItem
     * @param bool $replaceAll
     */
    public function __construct(array $mediaItem = array(), $replaceAll = true)
    {
        $this
            ->setMediaItem($mediaItem)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get mediaItem value
     * @return \StructType\File[]|null
     */
    public function getMediaItem()
    {
        return $this->mediaItem;
    }
    /**
     * This method is responsible for validating the values passed to the setMediaItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMediaItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMediaItemForArrayConstraintsFromSetMediaItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $messageMediaItemListMediaItemItem) {
            // validation for constraint: itemType
            if (!$messageMediaItemListMediaItemItem instanceof \StructType\File) {
                $invalidValues[] = is_object($messageMediaItemListMediaItemItem) ? get_class($messageMediaItemListMediaItemItem) : sprintf('%s(%s)', gettype($messageMediaItemListMediaItemItem), var_export($messageMediaItemListMediaItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The mediaItem property can only contain items of type \StructType\File, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set mediaItem value
     * @throws \InvalidArgumentException
     * @param \StructType\File[] $mediaItem
     * @return \StructType\MessageMediaItemList
     */
    public function setMediaItem(array $mediaItem = array())
    {
        // validation for constraint: array
        if ('' !== ($mediaItemArrayErrorMessage = self::validateMediaItemForArrayConstraintsFromSetMediaItem($mediaItem))) {
            throw new \InvalidArgumentException($mediaItemArrayErrorMessage, __LINE__);
        }
        $this->mediaItem = $mediaItem;
        return $this;
    }
    /**
     * Add item to mediaItem value
     * @throws \InvalidArgumentException
     * @param \StructType\File $item
     * @return \StructType\MessageMediaItemList
     */
    public function addToMediaItem(\StructType\File $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\File) {
            throw new \InvalidArgumentException(sprintf('The mediaItem property can only contain items of type \StructType\File, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->mediaItem[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\MessageMediaItemList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
