<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ManufacturingOperationTaskPredecessor StructType
 * @subpackage Structs
 */
class ManufacturingOperationTaskPredecessor extends AbstractStructBase
{
    /**
     * The task
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $task;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $type;
    /**
     * The startDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $startDate;
    /**
     * The endDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $endDate;
    /**
     * The lagType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lagType;
    /**
     * The lagAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $lagAmount;
    /**
     * The lagUnits
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lagUnits;
    /**
     * Constructor method for ManufacturingOperationTaskPredecessor
     * @uses ManufacturingOperationTaskPredecessor::setTask()
     * @uses ManufacturingOperationTaskPredecessor::setType()
     * @uses ManufacturingOperationTaskPredecessor::setStartDate()
     * @uses ManufacturingOperationTaskPredecessor::setEndDate()
     * @uses ManufacturingOperationTaskPredecessor::setLagType()
     * @uses ManufacturingOperationTaskPredecessor::setLagAmount()
     * @uses ManufacturingOperationTaskPredecessor::setLagUnits()
     * @param \StructType\RecordRef $task
     * @param string $type
     * @param string $startDate
     * @param string $endDate
     * @param string $lagType
     * @param int $lagAmount
     * @param string $lagUnits
     */
    public function __construct(\StructType\RecordRef $task = null, $type = null, $startDate = null, $endDate = null, $lagType = null, $lagAmount = null, $lagUnits = null)
    {
        $this
            ->setTask($task)
            ->setType($type)
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setLagType($lagType)
            ->setLagAmount($lagAmount)
            ->setLagUnits($lagUnits);
    }
    /**
     * Get task value
     * @return \StructType\RecordRef|null
     */
    public function getTask()
    {
        return $this->task;
    }
    /**
     * Set task value
     * @param \StructType\RecordRef $task
     * @return \StructType\ManufacturingOperationTaskPredecessor
     */
    public function setTask(\StructType\RecordRef $task = null)
    {
        $this->task = $task;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\ManufacturingOperationTaskPredecessorPredecessorType::valueIsValid()
     * @uses \EnumType\ManufacturingOperationTaskPredecessorPredecessorType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\ManufacturingOperationTaskPredecessor
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ManufacturingOperationTaskPredecessorPredecessorType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ManufacturingOperationTaskPredecessorPredecessorType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \EnumType\ManufacturingOperationTaskPredecessorPredecessorType::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get startDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \StructType\ManufacturingOperationTaskPredecessor
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \StructType\ManufacturingOperationTaskPredecessor
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Get lagType value
     * @return string|null
     */
    public function getLagType()
    {
        return $this->lagType;
    }
    /**
     * Set lagType value
     * @uses \EnumType\ManufacturingLagType::valueIsValid()
     * @uses \EnumType\ManufacturingLagType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $lagType
     * @return \StructType\ManufacturingOperationTaskPredecessor
     */
    public function setLagType($lagType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ManufacturingLagType::valueIsValid($lagType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ManufacturingLagType', is_array($lagType) ? implode(', ', $lagType) : var_export($lagType, true), implode(', ', \EnumType\ManufacturingLagType::getValidValues())), __LINE__);
        }
        $this->lagType = $lagType;
        return $this;
    }
    /**
     * Get lagAmount value
     * @return int|null
     */
    public function getLagAmount()
    {
        return $this->lagAmount;
    }
    /**
     * Set lagAmount value
     * @param int $lagAmount
     * @return \StructType\ManufacturingOperationTaskPredecessor
     */
    public function setLagAmount($lagAmount = null)
    {
        // validation for constraint: int
        if (!is_null($lagAmount) && !(is_int($lagAmount) || ctype_digit($lagAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lagAmount, true), gettype($lagAmount)), __LINE__);
        }
        $this->lagAmount = $lagAmount;
        return $this;
    }
    /**
     * Get lagUnits value
     * @return string|null
     */
    public function getLagUnits()
    {
        return $this->lagUnits;
    }
    /**
     * Set lagUnits value
     * @param string $lagUnits
     * @return \StructType\ManufacturingOperationTaskPredecessor
     */
    public function setLagUnits($lagUnits = null)
    {
        // validation for constraint: string
        if (!is_null($lagUnits) && !is_string($lagUnits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lagUnits, true), gettype($lagUnits)), __LINE__);
        }
        $this->lagUnits = $lagUnits;
        return $this;
    }
}
