<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ManufacturingCostDetailList StructType
 * @subpackage Structs
 */
class ManufacturingCostDetailList extends AbstractStructBase
{
    /**
     * The manufacturingCostDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ManufacturingCostDetail[]
     */
    public $manufacturingCostDetail;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for ManufacturingCostDetailList
     * @uses ManufacturingCostDetailList::setManufacturingCostDetail()
     * @uses ManufacturingCostDetailList::setReplaceAll()
     * @param \StructType\ManufacturingCostDetail[] $manufacturingCostDetail
     * @param bool $replaceAll
     */
    public function __construct(array $manufacturingCostDetail = array(), $replaceAll = true)
    {
        $this
            ->setManufacturingCostDetail($manufacturingCostDetail)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get manufacturingCostDetail value
     * @return \StructType\ManufacturingCostDetail[]|null
     */
    public function getManufacturingCostDetail()
    {
        return $this->manufacturingCostDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setManufacturingCostDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setManufacturingCostDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateManufacturingCostDetailForArrayConstraintsFromSetManufacturingCostDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $manufacturingCostDetailListManufacturingCostDetailItem) {
            // validation for constraint: itemType
            if (!$manufacturingCostDetailListManufacturingCostDetailItem instanceof \StructType\ManufacturingCostDetail) {
                $invalidValues[] = is_object($manufacturingCostDetailListManufacturingCostDetailItem) ? get_class($manufacturingCostDetailListManufacturingCostDetailItem) : sprintf('%s(%s)', gettype($manufacturingCostDetailListManufacturingCostDetailItem), var_export($manufacturingCostDetailListManufacturingCostDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The manufacturingCostDetail property can only contain items of type \StructType\ManufacturingCostDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set manufacturingCostDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\ManufacturingCostDetail[] $manufacturingCostDetail
     * @return \StructType\ManufacturingCostDetailList
     */
    public function setManufacturingCostDetail(array $manufacturingCostDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($manufacturingCostDetailArrayErrorMessage = self::validateManufacturingCostDetailForArrayConstraintsFromSetManufacturingCostDetail($manufacturingCostDetail))) {
            throw new \InvalidArgumentException($manufacturingCostDetailArrayErrorMessage, __LINE__);
        }
        $this->manufacturingCostDetail = $manufacturingCostDetail;
        return $this;
    }
    /**
     * Add item to manufacturingCostDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\ManufacturingCostDetail $item
     * @return \StructType\ManufacturingCostDetailList
     */
    public function addToManufacturingCostDetail(\StructType\ManufacturingCostDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ManufacturingCostDetail) {
            throw new \InvalidArgumentException(sprintf('The manufacturingCostDetail property can only contain items of type \StructType\ManufacturingCostDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->manufacturingCostDetail[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\ManufacturingCostDetailList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
