<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LocationSearchBasic StructType
 * @subpackage Structs
 */
class LocationSearchBasic extends SearchRecordBasic
{
    /**
     * The address
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchStringField
     */
    public $address;
    /**
     * The allowStorePickup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchBooleanField
     */
    public $allowStorePickup;
    /**
     * The autoAssignmentRegionSetting
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchEnumMultiSelectField
     */
    public $autoAssignmentRegionSetting;
    /**
     * The bufferStock
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchLongField
     */
    public $bufferStock;
    /**
     * The city
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchStringField
     */
    public $city;
    /**
     * The country
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchEnumMultiSelectField
     */
    public $country;
    /**
     * The county
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchStringField
     */
    public $county;
    /**
     * The dailyShippingCapacity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchLongField
     */
    public $dailyShippingCapacity;
    /**
     * The endTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchDateField
     */
    public $endTime;
    /**
     * The externalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $externalId;
    /**
     * The externalIdString
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchStringField
     */
    public $externalIdString;
    /**
     * The geolocationMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchEnumMultiSelectField
     */
    public $geolocationMethod;
    /**
     * The internalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $internalId;
    /**
     * The internalIdNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchLongField
     */
    public $internalIdNumber;
    /**
     * The isFriday
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchBooleanField
     */
    public $isFriday;
    /**
     * The isInactive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchBooleanField
     */
    public $isInactive;
    /**
     * The isIncludeInCt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchBooleanField
     */
    public $isIncludeInCt;
    /**
     * The isMonday
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchBooleanField
     */
    public $isMonday;
    /**
     * The isOffice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchBooleanField
     */
    public $isOffice;
    /**
     * The isSaturday
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchBooleanField
     */
    public $isSaturday;
    /**
     * The isSunday
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchBooleanField
     */
    public $isSunday;
    /**
     * The isThursday
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchBooleanField
     */
    public $isThursday;
    /**
     * The isTuesday
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchBooleanField
     */
    public $isTuesday;
    /**
     * The isWednesday
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchBooleanField
     */
    public $isWednesday;
    /**
     * The latitude
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchDoubleField
     */
    public $latitude;
    /**
     * The locationType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchEnumMultiSelectField
     */
    public $locationType;
    /**
     * The longitude
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchDoubleField
     */
    public $longitude;
    /**
     * The makeInventoryAvailable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchBooleanField
     */
    public $makeInventoryAvailable;
    /**
     * The makeInventoryAvailableStore
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchBooleanField
     */
    public $makeInventoryAvailableStore;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchStringField
     */
    public $name;
    /**
     * The nameNoHierarchy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchStringField
     */
    public $nameNoHierarchy;
    /**
     * The nextPickupCutOffTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchDateField
     */
    public $nextPickupCutOffTime;
    /**
     * The phone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchStringField
     */
    public $phone;
    /**
     * The sameDayPickupCutOffTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchDateField
     */
    public $sameDayPickupCutOffTime;
    /**
     * The startTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchDateField
     */
    public $startTime;
    /**
     * The state
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchStringField
     */
    public $state;
    /**
     * The storePickupBufferStock
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchDoubleField
     */
    public $storePickupBufferStock;
    /**
     * The subsidiary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchMultiSelectField
     */
    public $subsidiary;
    /**
     * The timeZone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchEnumMultiSelectField
     */
    public $timeZone;
    /**
     * The totalShippingCapacity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchLongField
     */
    public $totalShippingCapacity;
    /**
     * The tranprefix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchStringField
     */
    public $tranprefix;
    /**
     * The usesBins
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchBooleanField
     */
    public $usesBins;
    /**
     * The zip
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchStringField
     */
    public $zip;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SearchCustomFieldList
     */
    public $customFieldList;
    /**
     * Constructor method for LocationSearchBasic
     * @uses LocationSearchBasic::setAddress()
     * @uses LocationSearchBasic::setAllowStorePickup()
     * @uses LocationSearchBasic::setAutoAssignmentRegionSetting()
     * @uses LocationSearchBasic::setBufferStock()
     * @uses LocationSearchBasic::setCity()
     * @uses LocationSearchBasic::setCountry()
     * @uses LocationSearchBasic::setCounty()
     * @uses LocationSearchBasic::setDailyShippingCapacity()
     * @uses LocationSearchBasic::setEndTime()
     * @uses LocationSearchBasic::setExternalId()
     * @uses LocationSearchBasic::setExternalIdString()
     * @uses LocationSearchBasic::setGeolocationMethod()
     * @uses LocationSearchBasic::setInternalId()
     * @uses LocationSearchBasic::setInternalIdNumber()
     * @uses LocationSearchBasic::setIsFriday()
     * @uses LocationSearchBasic::setIsInactive()
     * @uses LocationSearchBasic::setIsIncludeInCt()
     * @uses LocationSearchBasic::setIsMonday()
     * @uses LocationSearchBasic::setIsOffice()
     * @uses LocationSearchBasic::setIsSaturday()
     * @uses LocationSearchBasic::setIsSunday()
     * @uses LocationSearchBasic::setIsThursday()
     * @uses LocationSearchBasic::setIsTuesday()
     * @uses LocationSearchBasic::setIsWednesday()
     * @uses LocationSearchBasic::setLatitude()
     * @uses LocationSearchBasic::setLocationType()
     * @uses LocationSearchBasic::setLongitude()
     * @uses LocationSearchBasic::setMakeInventoryAvailable()
     * @uses LocationSearchBasic::setMakeInventoryAvailableStore()
     * @uses LocationSearchBasic::setName()
     * @uses LocationSearchBasic::setNameNoHierarchy()
     * @uses LocationSearchBasic::setNextPickupCutOffTime()
     * @uses LocationSearchBasic::setPhone()
     * @uses LocationSearchBasic::setSameDayPickupCutOffTime()
     * @uses LocationSearchBasic::setStartTime()
     * @uses LocationSearchBasic::setState()
     * @uses LocationSearchBasic::setStorePickupBufferStock()
     * @uses LocationSearchBasic::setSubsidiary()
     * @uses LocationSearchBasic::setTimeZone()
     * @uses LocationSearchBasic::setTotalShippingCapacity()
     * @uses LocationSearchBasic::setTranprefix()
     * @uses LocationSearchBasic::setUsesBins()
     * @uses LocationSearchBasic::setZip()
     * @uses LocationSearchBasic::setCustomFieldList()
     * @param \StructType\SearchStringField $address
     * @param \StructType\SearchBooleanField $allowStorePickup
     * @param \StructType\SearchEnumMultiSelectField $autoAssignmentRegionSetting
     * @param \StructType\SearchLongField $bufferStock
     * @param \StructType\SearchStringField $city
     * @param \StructType\SearchEnumMultiSelectField $country
     * @param \StructType\SearchStringField $county
     * @param \StructType\SearchLongField $dailyShippingCapacity
     * @param \StructType\SearchDateField $endTime
     * @param \StructType\SearchMultiSelectField $externalId
     * @param \StructType\SearchStringField $externalIdString
     * @param \StructType\SearchEnumMultiSelectField $geolocationMethod
     * @param \StructType\SearchMultiSelectField $internalId
     * @param \StructType\SearchLongField $internalIdNumber
     * @param \StructType\SearchBooleanField $isFriday
     * @param \StructType\SearchBooleanField $isInactive
     * @param \StructType\SearchBooleanField $isIncludeInCt
     * @param \StructType\SearchBooleanField $isMonday
     * @param \StructType\SearchBooleanField $isOffice
     * @param \StructType\SearchBooleanField $isSaturday
     * @param \StructType\SearchBooleanField $isSunday
     * @param \StructType\SearchBooleanField $isThursday
     * @param \StructType\SearchBooleanField $isTuesday
     * @param \StructType\SearchBooleanField $isWednesday
     * @param \StructType\SearchDoubleField $latitude
     * @param \StructType\SearchEnumMultiSelectField $locationType
     * @param \StructType\SearchDoubleField $longitude
     * @param \StructType\SearchBooleanField $makeInventoryAvailable
     * @param \StructType\SearchBooleanField $makeInventoryAvailableStore
     * @param \StructType\SearchStringField $name
     * @param \StructType\SearchStringField $nameNoHierarchy
     * @param \StructType\SearchDateField $nextPickupCutOffTime
     * @param \StructType\SearchStringField $phone
     * @param \StructType\SearchDateField $sameDayPickupCutOffTime
     * @param \StructType\SearchDateField $startTime
     * @param \StructType\SearchStringField $state
     * @param \StructType\SearchDoubleField $storePickupBufferStock
     * @param \StructType\SearchMultiSelectField $subsidiary
     * @param \StructType\SearchEnumMultiSelectField $timeZone
     * @param \StructType\SearchLongField $totalShippingCapacity
     * @param \StructType\SearchStringField $tranprefix
     * @param \StructType\SearchBooleanField $usesBins
     * @param \StructType\SearchStringField $zip
     * @param \StructType\SearchCustomFieldList $customFieldList
     */
    public function __construct(\StructType\SearchStringField $address = null, \StructType\SearchBooleanField $allowStorePickup = null, \StructType\SearchEnumMultiSelectField $autoAssignmentRegionSetting = null, \StructType\SearchLongField $bufferStock = null, \StructType\SearchStringField $city = null, \StructType\SearchEnumMultiSelectField $country = null, \StructType\SearchStringField $county = null, \StructType\SearchLongField $dailyShippingCapacity = null, \StructType\SearchDateField $endTime = null, \StructType\SearchMultiSelectField $externalId = null, \StructType\SearchStringField $externalIdString = null, \StructType\SearchEnumMultiSelectField $geolocationMethod = null, \StructType\SearchMultiSelectField $internalId = null, \StructType\SearchLongField $internalIdNumber = null, \StructType\SearchBooleanField $isFriday = null, \StructType\SearchBooleanField $isInactive = null, \StructType\SearchBooleanField $isIncludeInCt = null, \StructType\SearchBooleanField $isMonday = null, \StructType\SearchBooleanField $isOffice = null, \StructType\SearchBooleanField $isSaturday = null, \StructType\SearchBooleanField $isSunday = null, \StructType\SearchBooleanField $isThursday = null, \StructType\SearchBooleanField $isTuesday = null, \StructType\SearchBooleanField $isWednesday = null, \StructType\SearchDoubleField $latitude = null, \StructType\SearchEnumMultiSelectField $locationType = null, \StructType\SearchDoubleField $longitude = null, \StructType\SearchBooleanField $makeInventoryAvailable = null, \StructType\SearchBooleanField $makeInventoryAvailableStore = null, \StructType\SearchStringField $name = null, \StructType\SearchStringField $nameNoHierarchy = null, \StructType\SearchDateField $nextPickupCutOffTime = null, \StructType\SearchStringField $phone = null, \StructType\SearchDateField $sameDayPickupCutOffTime = null, \StructType\SearchDateField $startTime = null, \StructType\SearchStringField $state = null, \StructType\SearchDoubleField $storePickupBufferStock = null, \StructType\SearchMultiSelectField $subsidiary = null, \StructType\SearchEnumMultiSelectField $timeZone = null, \StructType\SearchLongField $totalShippingCapacity = null, \StructType\SearchStringField $tranprefix = null, \StructType\SearchBooleanField $usesBins = null, \StructType\SearchStringField $zip = null, \StructType\SearchCustomFieldList $customFieldList = null)
    {
        $this
            ->setAddress($address)
            ->setAllowStorePickup($allowStorePickup)
            ->setAutoAssignmentRegionSetting($autoAssignmentRegionSetting)
            ->setBufferStock($bufferStock)
            ->setCity($city)
            ->setCountry($country)
            ->setCounty($county)
            ->setDailyShippingCapacity($dailyShippingCapacity)
            ->setEndTime($endTime)
            ->setExternalId($externalId)
            ->setExternalIdString($externalIdString)
            ->setGeolocationMethod($geolocationMethod)
            ->setInternalId($internalId)
            ->setInternalIdNumber($internalIdNumber)
            ->setIsFriday($isFriday)
            ->setIsInactive($isInactive)
            ->setIsIncludeInCt($isIncludeInCt)
            ->setIsMonday($isMonday)
            ->setIsOffice($isOffice)
            ->setIsSaturday($isSaturday)
            ->setIsSunday($isSunday)
            ->setIsThursday($isThursday)
            ->setIsTuesday($isTuesday)
            ->setIsWednesday($isWednesday)
            ->setLatitude($latitude)
            ->setLocationType($locationType)
            ->setLongitude($longitude)
            ->setMakeInventoryAvailable($makeInventoryAvailable)
            ->setMakeInventoryAvailableStore($makeInventoryAvailableStore)
            ->setName($name)
            ->setNameNoHierarchy($nameNoHierarchy)
            ->setNextPickupCutOffTime($nextPickupCutOffTime)
            ->setPhone($phone)
            ->setSameDayPickupCutOffTime($sameDayPickupCutOffTime)
            ->setStartTime($startTime)
            ->setState($state)
            ->setStorePickupBufferStock($storePickupBufferStock)
            ->setSubsidiary($subsidiary)
            ->setTimeZone($timeZone)
            ->setTotalShippingCapacity($totalShippingCapacity)
            ->setTranprefix($tranprefix)
            ->setUsesBins($usesBins)
            ->setZip($zip)
            ->setCustomFieldList($customFieldList);
    }
    /**
     * Get address value
     * @return \StructType\SearchStringField|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param \StructType\SearchStringField $address
     * @return \StructType\LocationSearchBasic
     */
    public function setAddress(\StructType\SearchStringField $address = null)
    {
        $this->address = $address;
        return $this;
    }
    /**
     * Get allowStorePickup value
     * @return \StructType\SearchBooleanField|null
     */
    public function getAllowStorePickup()
    {
        return $this->allowStorePickup;
    }
    /**
     * Set allowStorePickup value
     * @param \StructType\SearchBooleanField $allowStorePickup
     * @return \StructType\LocationSearchBasic
     */
    public function setAllowStorePickup(\StructType\SearchBooleanField $allowStorePickup = null)
    {
        $this->allowStorePickup = $allowStorePickup;
        return $this;
    }
    /**
     * Get autoAssignmentRegionSetting value
     * @return \StructType\SearchEnumMultiSelectField|null
     */
    public function getAutoAssignmentRegionSetting()
    {
        return $this->autoAssignmentRegionSetting;
    }
    /**
     * Set autoAssignmentRegionSetting value
     * @param \StructType\SearchEnumMultiSelectField $autoAssignmentRegionSetting
     * @return \StructType\LocationSearchBasic
     */
    public function setAutoAssignmentRegionSetting(\StructType\SearchEnumMultiSelectField $autoAssignmentRegionSetting = null)
    {
        $this->autoAssignmentRegionSetting = $autoAssignmentRegionSetting;
        return $this;
    }
    /**
     * Get bufferStock value
     * @return \StructType\SearchLongField|null
     */
    public function getBufferStock()
    {
        return $this->bufferStock;
    }
    /**
     * Set bufferStock value
     * @param \StructType\SearchLongField $bufferStock
     * @return \StructType\LocationSearchBasic
     */
    public function setBufferStock(\StructType\SearchLongField $bufferStock = null)
    {
        $this->bufferStock = $bufferStock;
        return $this;
    }
    /**
     * Get city value
     * @return \StructType\SearchStringField|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param \StructType\SearchStringField $city
     * @return \StructType\LocationSearchBasic
     */
    public function setCity(\StructType\SearchStringField $city = null)
    {
        $this->city = $city;
        return $this;
    }
    /**
     * Get country value
     * @return \StructType\SearchEnumMultiSelectField|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param \StructType\SearchEnumMultiSelectField $country
     * @return \StructType\LocationSearchBasic
     */
    public function setCountry(\StructType\SearchEnumMultiSelectField $country = null)
    {
        $this->country = $country;
        return $this;
    }
    /**
     * Get county value
     * @return \StructType\SearchStringField|null
     */
    public function getCounty()
    {
        return $this->county;
    }
    /**
     * Set county value
     * @param \StructType\SearchStringField $county
     * @return \StructType\LocationSearchBasic
     */
    public function setCounty(\StructType\SearchStringField $county = null)
    {
        $this->county = $county;
        return $this;
    }
    /**
     * Get dailyShippingCapacity value
     * @return \StructType\SearchLongField|null
     */
    public function getDailyShippingCapacity()
    {
        return $this->dailyShippingCapacity;
    }
    /**
     * Set dailyShippingCapacity value
     * @param \StructType\SearchLongField $dailyShippingCapacity
     * @return \StructType\LocationSearchBasic
     */
    public function setDailyShippingCapacity(\StructType\SearchLongField $dailyShippingCapacity = null)
    {
        $this->dailyShippingCapacity = $dailyShippingCapacity;
        return $this;
    }
    /**
     * Get endTime value
     * @return \StructType\SearchDateField|null
     */
    public function getEndTime()
    {
        return $this->endTime;
    }
    /**
     * Set endTime value
     * @param \StructType\SearchDateField $endTime
     * @return \StructType\LocationSearchBasic
     */
    public function setEndTime(\StructType\SearchDateField $endTime = null)
    {
        $this->endTime = $endTime;
        return $this;
    }
    /**
     * Get externalId value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getExternalId()
    {
        return $this->externalId;
    }
    /**
     * Set externalId value
     * @param \StructType\SearchMultiSelectField $externalId
     * @return \StructType\LocationSearchBasic
     */
    public function setExternalId(\StructType\SearchMultiSelectField $externalId = null)
    {
        $this->externalId = $externalId;
        return $this;
    }
    /**
     * Get externalIdString value
     * @return \StructType\SearchStringField|null
     */
    public function getExternalIdString()
    {
        return $this->externalIdString;
    }
    /**
     * Set externalIdString value
     * @param \StructType\SearchStringField $externalIdString
     * @return \StructType\LocationSearchBasic
     */
    public function setExternalIdString(\StructType\SearchStringField $externalIdString = null)
    {
        $this->externalIdString = $externalIdString;
        return $this;
    }
    /**
     * Get geolocationMethod value
     * @return \StructType\SearchEnumMultiSelectField|null
     */
    public function getGeolocationMethod()
    {
        return $this->geolocationMethod;
    }
    /**
     * Set geolocationMethod value
     * @param \StructType\SearchEnumMultiSelectField $geolocationMethod
     * @return \StructType\LocationSearchBasic
     */
    public function setGeolocationMethod(\StructType\SearchEnumMultiSelectField $geolocationMethod = null)
    {
        $this->geolocationMethod = $geolocationMethod;
        return $this;
    }
    /**
     * Get internalId value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getInternalId()
    {
        return $this->internalId;
    }
    /**
     * Set internalId value
     * @param \StructType\SearchMultiSelectField $internalId
     * @return \StructType\LocationSearchBasic
     */
    public function setInternalId(\StructType\SearchMultiSelectField $internalId = null)
    {
        $this->internalId = $internalId;
        return $this;
    }
    /**
     * Get internalIdNumber value
     * @return \StructType\SearchLongField|null
     */
    public function getInternalIdNumber()
    {
        return $this->internalIdNumber;
    }
    /**
     * Set internalIdNumber value
     * @param \StructType\SearchLongField $internalIdNumber
     * @return \StructType\LocationSearchBasic
     */
    public function setInternalIdNumber(\StructType\SearchLongField $internalIdNumber = null)
    {
        $this->internalIdNumber = $internalIdNumber;
        return $this;
    }
    /**
     * Get isFriday value
     * @return \StructType\SearchBooleanField|null
     */
    public function getIsFriday()
    {
        return $this->isFriday;
    }
    /**
     * Set isFriday value
     * @param \StructType\SearchBooleanField $isFriday
     * @return \StructType\LocationSearchBasic
     */
    public function setIsFriday(\StructType\SearchBooleanField $isFriday = null)
    {
        $this->isFriday = $isFriday;
        return $this;
    }
    /**
     * Get isInactive value
     * @return \StructType\SearchBooleanField|null
     */
    public function getIsInactive()
    {
        return $this->isInactive;
    }
    /**
     * Set isInactive value
     * @param \StructType\SearchBooleanField $isInactive
     * @return \StructType\LocationSearchBasic
     */
    public function setIsInactive(\StructType\SearchBooleanField $isInactive = null)
    {
        $this->isInactive = $isInactive;
        return $this;
    }
    /**
     * Get isIncludeInCt value
     * @return \StructType\SearchBooleanField|null
     */
    public function getIsIncludeInCt()
    {
        return $this->isIncludeInCt;
    }
    /**
     * Set isIncludeInCt value
     * @param \StructType\SearchBooleanField $isIncludeInCt
     * @return \StructType\LocationSearchBasic
     */
    public function setIsIncludeInCt(\StructType\SearchBooleanField $isIncludeInCt = null)
    {
        $this->isIncludeInCt = $isIncludeInCt;
        return $this;
    }
    /**
     * Get isMonday value
     * @return \StructType\SearchBooleanField|null
     */
    public function getIsMonday()
    {
        return $this->isMonday;
    }
    /**
     * Set isMonday value
     * @param \StructType\SearchBooleanField $isMonday
     * @return \StructType\LocationSearchBasic
     */
    public function setIsMonday(\StructType\SearchBooleanField $isMonday = null)
    {
        $this->isMonday = $isMonday;
        return $this;
    }
    /**
     * Get isOffice value
     * @return \StructType\SearchBooleanField|null
     */
    public function getIsOffice()
    {
        return $this->isOffice;
    }
    /**
     * Set isOffice value
     * @param \StructType\SearchBooleanField $isOffice
     * @return \StructType\LocationSearchBasic
     */
    public function setIsOffice(\StructType\SearchBooleanField $isOffice = null)
    {
        $this->isOffice = $isOffice;
        return $this;
    }
    /**
     * Get isSaturday value
     * @return \StructType\SearchBooleanField|null
     */
    public function getIsSaturday()
    {
        return $this->isSaturday;
    }
    /**
     * Set isSaturday value
     * @param \StructType\SearchBooleanField $isSaturday
     * @return \StructType\LocationSearchBasic
     */
    public function setIsSaturday(\StructType\SearchBooleanField $isSaturday = null)
    {
        $this->isSaturday = $isSaturday;
        return $this;
    }
    /**
     * Get isSunday value
     * @return \StructType\SearchBooleanField|null
     */
    public function getIsSunday()
    {
        return $this->isSunday;
    }
    /**
     * Set isSunday value
     * @param \StructType\SearchBooleanField $isSunday
     * @return \StructType\LocationSearchBasic
     */
    public function setIsSunday(\StructType\SearchBooleanField $isSunday = null)
    {
        $this->isSunday = $isSunday;
        return $this;
    }
    /**
     * Get isThursday value
     * @return \StructType\SearchBooleanField|null
     */
    public function getIsThursday()
    {
        return $this->isThursday;
    }
    /**
     * Set isThursday value
     * @param \StructType\SearchBooleanField $isThursday
     * @return \StructType\LocationSearchBasic
     */
    public function setIsThursday(\StructType\SearchBooleanField $isThursday = null)
    {
        $this->isThursday = $isThursday;
        return $this;
    }
    /**
     * Get isTuesday value
     * @return \StructType\SearchBooleanField|null
     */
    public function getIsTuesday()
    {
        return $this->isTuesday;
    }
    /**
     * Set isTuesday value
     * @param \StructType\SearchBooleanField $isTuesday
     * @return \StructType\LocationSearchBasic
     */
    public function setIsTuesday(\StructType\SearchBooleanField $isTuesday = null)
    {
        $this->isTuesday = $isTuesday;
        return $this;
    }
    /**
     * Get isWednesday value
     * @return \StructType\SearchBooleanField|null
     */
    public function getIsWednesday()
    {
        return $this->isWednesday;
    }
    /**
     * Set isWednesday value
     * @param \StructType\SearchBooleanField $isWednesday
     * @return \StructType\LocationSearchBasic
     */
    public function setIsWednesday(\StructType\SearchBooleanField $isWednesday = null)
    {
        $this->isWednesday = $isWednesday;
        return $this;
    }
    /**
     * Get latitude value
     * @return \StructType\SearchDoubleField|null
     */
    public function getLatitude()
    {
        return $this->latitude;
    }
    /**
     * Set latitude value
     * @param \StructType\SearchDoubleField $latitude
     * @return \StructType\LocationSearchBasic
     */
    public function setLatitude(\StructType\SearchDoubleField $latitude = null)
    {
        $this->latitude = $latitude;
        return $this;
    }
    /**
     * Get locationType value
     * @return \StructType\SearchEnumMultiSelectField|null
     */
    public function getLocationType()
    {
        return $this->locationType;
    }
    /**
     * Set locationType value
     * @param \StructType\SearchEnumMultiSelectField $locationType
     * @return \StructType\LocationSearchBasic
     */
    public function setLocationType(\StructType\SearchEnumMultiSelectField $locationType = null)
    {
        $this->locationType = $locationType;
        return $this;
    }
    /**
     * Get longitude value
     * @return \StructType\SearchDoubleField|null
     */
    public function getLongitude()
    {
        return $this->longitude;
    }
    /**
     * Set longitude value
     * @param \StructType\SearchDoubleField $longitude
     * @return \StructType\LocationSearchBasic
     */
    public function setLongitude(\StructType\SearchDoubleField $longitude = null)
    {
        $this->longitude = $longitude;
        return $this;
    }
    /**
     * Get makeInventoryAvailable value
     * @return \StructType\SearchBooleanField|null
     */
    public function getMakeInventoryAvailable()
    {
        return $this->makeInventoryAvailable;
    }
    /**
     * Set makeInventoryAvailable value
     * @param \StructType\SearchBooleanField $makeInventoryAvailable
     * @return \StructType\LocationSearchBasic
     */
    public function setMakeInventoryAvailable(\StructType\SearchBooleanField $makeInventoryAvailable = null)
    {
        $this->makeInventoryAvailable = $makeInventoryAvailable;
        return $this;
    }
    /**
     * Get makeInventoryAvailableStore value
     * @return \StructType\SearchBooleanField|null
     */
    public function getMakeInventoryAvailableStore()
    {
        return $this->makeInventoryAvailableStore;
    }
    /**
     * Set makeInventoryAvailableStore value
     * @param \StructType\SearchBooleanField $makeInventoryAvailableStore
     * @return \StructType\LocationSearchBasic
     */
    public function setMakeInventoryAvailableStore(\StructType\SearchBooleanField $makeInventoryAvailableStore = null)
    {
        $this->makeInventoryAvailableStore = $makeInventoryAvailableStore;
        return $this;
    }
    /**
     * Get name value
     * @return \StructType\SearchStringField|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param \StructType\SearchStringField $name
     * @return \StructType\LocationSearchBasic
     */
    public function setName(\StructType\SearchStringField $name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get nameNoHierarchy value
     * @return \StructType\SearchStringField|null
     */
    public function getNameNoHierarchy()
    {
        return $this->nameNoHierarchy;
    }
    /**
     * Set nameNoHierarchy value
     * @param \StructType\SearchStringField $nameNoHierarchy
     * @return \StructType\LocationSearchBasic
     */
    public function setNameNoHierarchy(\StructType\SearchStringField $nameNoHierarchy = null)
    {
        $this->nameNoHierarchy = $nameNoHierarchy;
        return $this;
    }
    /**
     * Get nextPickupCutOffTime value
     * @return \StructType\SearchDateField|null
     */
    public function getNextPickupCutOffTime()
    {
        return $this->nextPickupCutOffTime;
    }
    /**
     * Set nextPickupCutOffTime value
     * @param \StructType\SearchDateField $nextPickupCutOffTime
     * @return \StructType\LocationSearchBasic
     */
    public function setNextPickupCutOffTime(\StructType\SearchDateField $nextPickupCutOffTime = null)
    {
        $this->nextPickupCutOffTime = $nextPickupCutOffTime;
        return $this;
    }
    /**
     * Get phone value
     * @return \StructType\SearchStringField|null
     */
    public function getPhone()
    {
        return $this->phone;
    }
    /**
     * Set phone value
     * @param \StructType\SearchStringField $phone
     * @return \StructType\LocationSearchBasic
     */
    public function setPhone(\StructType\SearchStringField $phone = null)
    {
        $this->phone = $phone;
        return $this;
    }
    /**
     * Get sameDayPickupCutOffTime value
     * @return \StructType\SearchDateField|null
     */
    public function getSameDayPickupCutOffTime()
    {
        return $this->sameDayPickupCutOffTime;
    }
    /**
     * Set sameDayPickupCutOffTime value
     * @param \StructType\SearchDateField $sameDayPickupCutOffTime
     * @return \StructType\LocationSearchBasic
     */
    public function setSameDayPickupCutOffTime(\StructType\SearchDateField $sameDayPickupCutOffTime = null)
    {
        $this->sameDayPickupCutOffTime = $sameDayPickupCutOffTime;
        return $this;
    }
    /**
     * Get startTime value
     * @return \StructType\SearchDateField|null
     */
    public function getStartTime()
    {
        return $this->startTime;
    }
    /**
     * Set startTime value
     * @param \StructType\SearchDateField $startTime
     * @return \StructType\LocationSearchBasic
     */
    public function setStartTime(\StructType\SearchDateField $startTime = null)
    {
        $this->startTime = $startTime;
        return $this;
    }
    /**
     * Get state value
     * @return \StructType\SearchStringField|null
     */
    public function getState()
    {
        return $this->state;
    }
    /**
     * Set state value
     * @param \StructType\SearchStringField $state
     * @return \StructType\LocationSearchBasic
     */
    public function setState(\StructType\SearchStringField $state = null)
    {
        $this->state = $state;
        return $this;
    }
    /**
     * Get storePickupBufferStock value
     * @return \StructType\SearchDoubleField|null
     */
    public function getStorePickupBufferStock()
    {
        return $this->storePickupBufferStock;
    }
    /**
     * Set storePickupBufferStock value
     * @param \StructType\SearchDoubleField $storePickupBufferStock
     * @return \StructType\LocationSearchBasic
     */
    public function setStorePickupBufferStock(\StructType\SearchDoubleField $storePickupBufferStock = null)
    {
        $this->storePickupBufferStock = $storePickupBufferStock;
        return $this;
    }
    /**
     * Get subsidiary value
     * @return \StructType\SearchMultiSelectField|null
     */
    public function getSubsidiary()
    {
        return $this->subsidiary;
    }
    /**
     * Set subsidiary value
     * @param \StructType\SearchMultiSelectField $subsidiary
     * @return \StructType\LocationSearchBasic
     */
    public function setSubsidiary(\StructType\SearchMultiSelectField $subsidiary = null)
    {
        $this->subsidiary = $subsidiary;
        return $this;
    }
    /**
     * Get timeZone value
     * @return \StructType\SearchEnumMultiSelectField|null
     */
    public function getTimeZone()
    {
        return $this->timeZone;
    }
    /**
     * Set timeZone value
     * @param \StructType\SearchEnumMultiSelectField $timeZone
     * @return \StructType\LocationSearchBasic
     */
    public function setTimeZone(\StructType\SearchEnumMultiSelectField $timeZone = null)
    {
        $this->timeZone = $timeZone;
        return $this;
    }
    /**
     * Get totalShippingCapacity value
     * @return \StructType\SearchLongField|null
     */
    public function getTotalShippingCapacity()
    {
        return $this->totalShippingCapacity;
    }
    /**
     * Set totalShippingCapacity value
     * @param \StructType\SearchLongField $totalShippingCapacity
     * @return \StructType\LocationSearchBasic
     */
    public function setTotalShippingCapacity(\StructType\SearchLongField $totalShippingCapacity = null)
    {
        $this->totalShippingCapacity = $totalShippingCapacity;
        return $this;
    }
    /**
     * Get tranprefix value
     * @return \StructType\SearchStringField|null
     */
    public function getTranprefix()
    {
        return $this->tranprefix;
    }
    /**
     * Set tranprefix value
     * @param \StructType\SearchStringField $tranprefix
     * @return \StructType\LocationSearchBasic
     */
    public function setTranprefix(\StructType\SearchStringField $tranprefix = null)
    {
        $this->tranprefix = $tranprefix;
        return $this;
    }
    /**
     * Get usesBins value
     * @return \StructType\SearchBooleanField|null
     */
    public function getUsesBins()
    {
        return $this->usesBins;
    }
    /**
     * Set usesBins value
     * @param \StructType\SearchBooleanField $usesBins
     * @return \StructType\LocationSearchBasic
     */
    public function setUsesBins(\StructType\SearchBooleanField $usesBins = null)
    {
        $this->usesBins = $usesBins;
        return $this;
    }
    /**
     * Get zip value
     * @return \StructType\SearchStringField|null
     */
    public function getZip()
    {
        return $this->zip;
    }
    /**
     * Set zip value
     * @param \StructType\SearchStringField $zip
     * @return \StructType\LocationSearchBasic
     */
    public function setZip(\StructType\SearchStringField $zip = null)
    {
        $this->zip = $zip;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\SearchCustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\SearchCustomFieldList $customFieldList
     * @return \StructType\LocationSearchBasic
     */
    public function setCustomFieldList(\StructType\SearchCustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
}
