<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LocationSearch StructType
 * @subpackage Structs
 */
class LocationSearch extends SearchRecord
{
    /**
     * The basic
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\LocationSearchBasic
     */
    public $basic;
    /**
     * The addressJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AddressSearchBasic
     */
    public $addressJoin;
    /**
     * The returnAddressJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AddressSearchBasic
     */
    public $returnAddressJoin;
    /**
     * The userJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EmployeeSearchBasic
     */
    public $userJoin;
    /**
     * The customSearchJoin
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomSearchJoin[]
     */
    public $customSearchJoin;
    /**
     * Constructor method for LocationSearch
     * @uses LocationSearch::setBasic()
     * @uses LocationSearch::setAddressJoin()
     * @uses LocationSearch::setReturnAddressJoin()
     * @uses LocationSearch::setUserJoin()
     * @uses LocationSearch::setCustomSearchJoin()
     * @param \StructType\LocationSearchBasic $basic
     * @param \StructType\AddressSearchBasic $addressJoin
     * @param \StructType\AddressSearchBasic $returnAddressJoin
     * @param \StructType\EmployeeSearchBasic $userJoin
     * @param \StructType\CustomSearchJoin[] $customSearchJoin
     */
    public function __construct(\StructType\LocationSearchBasic $basic = null, \StructType\AddressSearchBasic $addressJoin = null, \StructType\AddressSearchBasic $returnAddressJoin = null, \StructType\EmployeeSearchBasic $userJoin = null, array $customSearchJoin = array())
    {
        $this
            ->setBasic($basic)
            ->setAddressJoin($addressJoin)
            ->setReturnAddressJoin($returnAddressJoin)
            ->setUserJoin($userJoin)
            ->setCustomSearchJoin($customSearchJoin);
    }
    /**
     * Get basic value
     * @return \StructType\LocationSearchBasic|null
     */
    public function getBasic()
    {
        return $this->basic;
    }
    /**
     * Set basic value
     * @param \StructType\LocationSearchBasic $basic
     * @return \StructType\LocationSearch
     */
    public function setBasic(\StructType\LocationSearchBasic $basic = null)
    {
        $this->basic = $basic;
        return $this;
    }
    /**
     * Get addressJoin value
     * @return \StructType\AddressSearchBasic|null
     */
    public function getAddressJoin()
    {
        return $this->addressJoin;
    }
    /**
     * Set addressJoin value
     * @param \StructType\AddressSearchBasic $addressJoin
     * @return \StructType\LocationSearch
     */
    public function setAddressJoin(\StructType\AddressSearchBasic $addressJoin = null)
    {
        $this->addressJoin = $addressJoin;
        return $this;
    }
    /**
     * Get returnAddressJoin value
     * @return \StructType\AddressSearchBasic|null
     */
    public function getReturnAddressJoin()
    {
        return $this->returnAddressJoin;
    }
    /**
     * Set returnAddressJoin value
     * @param \StructType\AddressSearchBasic $returnAddressJoin
     * @return \StructType\LocationSearch
     */
    public function setReturnAddressJoin(\StructType\AddressSearchBasic $returnAddressJoin = null)
    {
        $this->returnAddressJoin = $returnAddressJoin;
        return $this;
    }
    /**
     * Get userJoin value
     * @return \StructType\EmployeeSearchBasic|null
     */
    public function getUserJoin()
    {
        return $this->userJoin;
    }
    /**
     * Set userJoin value
     * @param \StructType\EmployeeSearchBasic $userJoin
     * @return \StructType\LocationSearch
     */
    public function setUserJoin(\StructType\EmployeeSearchBasic $userJoin = null)
    {
        $this->userJoin = $userJoin;
        return $this;
    }
    /**
     * Get customSearchJoin value
     * @return \StructType\CustomSearchJoin[]|null
     */
    public function getCustomSearchJoin()
    {
        return $this->customSearchJoin;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomSearchJoin method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomSearchJoin method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomSearchJoinForArrayConstraintsFromSetCustomSearchJoin(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $locationSearchCustomSearchJoinItem) {
            // validation for constraint: itemType
            if (!$locationSearchCustomSearchJoinItem instanceof \StructType\CustomSearchJoin) {
                $invalidValues[] = is_object($locationSearchCustomSearchJoinItem) ? get_class($locationSearchCustomSearchJoinItem) : sprintf('%s(%s)', gettype($locationSearchCustomSearchJoinItem), var_export($locationSearchCustomSearchJoinItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The customSearchJoin property can only contain items of type \StructType\CustomSearchJoin, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set customSearchJoin value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomSearchJoin[] $customSearchJoin
     * @return \StructType\LocationSearch
     */
    public function setCustomSearchJoin(array $customSearchJoin = array())
    {
        // validation for constraint: array
        if ('' !== ($customSearchJoinArrayErrorMessage = self::validateCustomSearchJoinForArrayConstraintsFromSetCustomSearchJoin($customSearchJoin))) {
            throw new \InvalidArgumentException($customSearchJoinArrayErrorMessage, __LINE__);
        }
        $this->customSearchJoin = $customSearchJoin;
        return $this;
    }
    /**
     * Add item to customSearchJoin value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomSearchJoin $item
     * @return \StructType\LocationSearch
     */
    public function addToCustomSearchJoin(\StructType\CustomSearchJoin $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomSearchJoin) {
            throw new \InvalidArgumentException(sprintf('The customSearchJoin property can only contain items of type \StructType\CustomSearchJoin, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->customSearchJoin[] = $item;
        return $this;
    }
}
