<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LanguageValue StructType
 * @subpackage Structs
 */
class LanguageValue extends AbstractStructBase
{
    /**
     * The locale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $locale;
    /**
     * The value
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $value;
    /**
     * Constructor method for LanguageValue
     * @uses LanguageValue::setLocale()
     * @uses LanguageValue::setValue()
     * @param string $locale
     * @param string $value
     */
    public function __construct($locale = null, $value = null)
    {
        $this
            ->setLocale($locale)
            ->setValue($value);
    }
    /**
     * Get locale value
     * @return string|null
     */
    public function getLocale()
    {
        return $this->locale;
    }
    /**
     * Set locale value
     * @uses \EnumType\Language::valueIsValid()
     * @uses \EnumType\Language::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $locale
     * @return \StructType\LanguageValue
     */
    public function setLocale($locale = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Language::valueIsValid($locale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Language', is_array($locale) ? implode(', ', $locale) : var_export($locale, true), implode(', ', \EnumType\Language::getValidValues())), __LINE__);
        }
        $this->locale = $locale;
        return $this;
    }
    /**
     * Get value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param string $value
     * @return \StructType\LanguageValue
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
}
