<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JournalEntryLine StructType
 * @subpackage Structs
 */
class JournalEntryLine extends AbstractStructBase
{
    /**
     * The account
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $account;
    /**
     * The line
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $line;
    /**
     * The debit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $debit;
    /**
     * The credit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $credit;
    /**
     * The taxAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $taxAccount;
    /**
     * The lineTaxCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $lineTaxCode;
    /**
     * The lineTaxRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $lineTaxRate;
    /**
     * The debitTax
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $debitTax;
    /**
     * The creditTax
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $creditTax;
    /**
     * The taxBasis
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $taxBasis;
    /**
     * The totalAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $totalAmount;
    /**
     * The taxCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $taxCode;
    /**
     * The memo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $memo;
    /**
     * The taxRate1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $taxRate1;
    /**
     * The entity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $entity;
    /**
     * The grossAmt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $grossAmt;
    /**
     * The department
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $department;
    /**
     * The class
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $class;
    /**
     * The location
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $location;
    /**
     * The revenueRecognitionRule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $revenueRecognitionRule;
    /**
     * The eliminate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $eliminate;
    /**
     * The schedule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $schedule;
    /**
     * The startDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $startDate;
    /**
     * The endDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $endDate;
    /**
     * The residual
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $residual;
    /**
     * The scheduleNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $scheduleNum;
    /**
     * The tax1Amt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $tax1Amt;
    /**
     * The tax1Acct
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $tax1Acct;
    /**
     * The customFieldList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomFieldList
     */
    public $customFieldList;
    /**
     * Constructor method for JournalEntryLine
     * @uses JournalEntryLine::setAccount()
     * @uses JournalEntryLine::setLine()
     * @uses JournalEntryLine::setDebit()
     * @uses JournalEntryLine::setCredit()
     * @uses JournalEntryLine::setTaxAccount()
     * @uses JournalEntryLine::setLineTaxCode()
     * @uses JournalEntryLine::setLineTaxRate()
     * @uses JournalEntryLine::setDebitTax()
     * @uses JournalEntryLine::setCreditTax()
     * @uses JournalEntryLine::setTaxBasis()
     * @uses JournalEntryLine::setTotalAmount()
     * @uses JournalEntryLine::setTaxCode()
     * @uses JournalEntryLine::setMemo()
     * @uses JournalEntryLine::setTaxRate1()
     * @uses JournalEntryLine::setEntity()
     * @uses JournalEntryLine::setGrossAmt()
     * @uses JournalEntryLine::setDepartment()
     * @uses JournalEntryLine::setClass()
     * @uses JournalEntryLine::setLocation()
     * @uses JournalEntryLine::setRevenueRecognitionRule()
     * @uses JournalEntryLine::setEliminate()
     * @uses JournalEntryLine::setSchedule()
     * @uses JournalEntryLine::setStartDate()
     * @uses JournalEntryLine::setEndDate()
     * @uses JournalEntryLine::setResidual()
     * @uses JournalEntryLine::setScheduleNum()
     * @uses JournalEntryLine::setTax1Amt()
     * @uses JournalEntryLine::setTax1Acct()
     * @uses JournalEntryLine::setCustomFieldList()
     * @param \StructType\RecordRef $account
     * @param int $line
     * @param float $debit
     * @param float $credit
     * @param \StructType\RecordRef $taxAccount
     * @param \StructType\RecordRef $lineTaxCode
     * @param float $lineTaxRate
     * @param float $debitTax
     * @param float $creditTax
     * @param float $taxBasis
     * @param float $totalAmount
     * @param \StructType\RecordRef $taxCode
     * @param string $memo
     * @param float $taxRate1
     * @param \StructType\RecordRef $entity
     * @param float $grossAmt
     * @param \StructType\RecordRef $department
     * @param \StructType\RecordRef $class
     * @param \StructType\RecordRef $location
     * @param \StructType\RecordRef $revenueRecognitionRule
     * @param bool $eliminate
     * @param \StructType\RecordRef $schedule
     * @param string $startDate
     * @param string $endDate
     * @param string $residual
     * @param \StructType\RecordRef $scheduleNum
     * @param float $tax1Amt
     * @param \StructType\RecordRef $tax1Acct
     * @param \StructType\CustomFieldList $customFieldList
     */
    public function __construct(\StructType\RecordRef $account = null, $line = null, $debit = null, $credit = null, \StructType\RecordRef $taxAccount = null, \StructType\RecordRef $lineTaxCode = null, $lineTaxRate = null, $debitTax = null, $creditTax = null, $taxBasis = null, $totalAmount = null, \StructType\RecordRef $taxCode = null, $memo = null, $taxRate1 = null, \StructType\RecordRef $entity = null, $grossAmt = null, \StructType\RecordRef $department = null, \StructType\RecordRef $class = null, \StructType\RecordRef $location = null, \StructType\RecordRef $revenueRecognitionRule = null, $eliminate = null, \StructType\RecordRef $schedule = null, $startDate = null, $endDate = null, $residual = null, \StructType\RecordRef $scheduleNum = null, $tax1Amt = null, \StructType\RecordRef $tax1Acct = null, \StructType\CustomFieldList $customFieldList = null)
    {
        $this
            ->setAccount($account)
            ->setLine($line)
            ->setDebit($debit)
            ->setCredit($credit)
            ->setTaxAccount($taxAccount)
            ->setLineTaxCode($lineTaxCode)
            ->setLineTaxRate($lineTaxRate)
            ->setDebitTax($debitTax)
            ->setCreditTax($creditTax)
            ->setTaxBasis($taxBasis)
            ->setTotalAmount($totalAmount)
            ->setTaxCode($taxCode)
            ->setMemo($memo)
            ->setTaxRate1($taxRate1)
            ->setEntity($entity)
            ->setGrossAmt($grossAmt)
            ->setDepartment($department)
            ->setClass($class)
            ->setLocation($location)
            ->setRevenueRecognitionRule($revenueRecognitionRule)
            ->setEliminate($eliminate)
            ->setSchedule($schedule)
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setResidual($residual)
            ->setScheduleNum($scheduleNum)
            ->setTax1Amt($tax1Amt)
            ->setTax1Acct($tax1Acct)
            ->setCustomFieldList($customFieldList);
    }
    /**
     * Get account value
     * @return \StructType\RecordRef|null
     */
    public function getAccount()
    {
        return $this->account;
    }
    /**
     * Set account value
     * @param \StructType\RecordRef $account
     * @return \StructType\JournalEntryLine
     */
    public function setAccount(\StructType\RecordRef $account = null)
    {
        $this->account = $account;
        return $this;
    }
    /**
     * Get line value
     * @return int|null
     */
    public function getLine()
    {
        return $this->line;
    }
    /**
     * Set line value
     * @param int $line
     * @return \StructType\JournalEntryLine
     */
    public function setLine($line = null)
    {
        // validation for constraint: int
        if (!is_null($line) && !(is_int($line) || ctype_digit($line))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($line, true), gettype($line)), __LINE__);
        }
        $this->line = $line;
        return $this;
    }
    /**
     * Get debit value
     * @return float|null
     */
    public function getDebit()
    {
        return $this->debit;
    }
    /**
     * Set debit value
     * @param float $debit
     * @return \StructType\JournalEntryLine
     */
    public function setDebit($debit = null)
    {
        // validation for constraint: float
        if (!is_null($debit) && !(is_float($debit) || is_numeric($debit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($debit, true), gettype($debit)), __LINE__);
        }
        $this->debit = $debit;
        return $this;
    }
    /**
     * Get credit value
     * @return float|null
     */
    public function getCredit()
    {
        return $this->credit;
    }
    /**
     * Set credit value
     * @param float $credit
     * @return \StructType\JournalEntryLine
     */
    public function setCredit($credit = null)
    {
        // validation for constraint: float
        if (!is_null($credit) && !(is_float($credit) || is_numeric($credit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($credit, true), gettype($credit)), __LINE__);
        }
        $this->credit = $credit;
        return $this;
    }
    /**
     * Get taxAccount value
     * @return \StructType\RecordRef|null
     */
    public function getTaxAccount()
    {
        return $this->taxAccount;
    }
    /**
     * Set taxAccount value
     * @param \StructType\RecordRef $taxAccount
     * @return \StructType\JournalEntryLine
     */
    public function setTaxAccount(\StructType\RecordRef $taxAccount = null)
    {
        $this->taxAccount = $taxAccount;
        return $this;
    }
    /**
     * Get lineTaxCode value
     * @return \StructType\RecordRef|null
     */
    public function getLineTaxCode()
    {
        return $this->lineTaxCode;
    }
    /**
     * Set lineTaxCode value
     * @param \StructType\RecordRef $lineTaxCode
     * @return \StructType\JournalEntryLine
     */
    public function setLineTaxCode(\StructType\RecordRef $lineTaxCode = null)
    {
        $this->lineTaxCode = $lineTaxCode;
        return $this;
    }
    /**
     * Get lineTaxRate value
     * @return float|null
     */
    public function getLineTaxRate()
    {
        return $this->lineTaxRate;
    }
    /**
     * Set lineTaxRate value
     * @param float $lineTaxRate
     * @return \StructType\JournalEntryLine
     */
    public function setLineTaxRate($lineTaxRate = null)
    {
        // validation for constraint: float
        if (!is_null($lineTaxRate) && !(is_float($lineTaxRate) || is_numeric($lineTaxRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($lineTaxRate, true), gettype($lineTaxRate)), __LINE__);
        }
        $this->lineTaxRate = $lineTaxRate;
        return $this;
    }
    /**
     * Get debitTax value
     * @return float|null
     */
    public function getDebitTax()
    {
        return $this->debitTax;
    }
    /**
     * Set debitTax value
     * @param float $debitTax
     * @return \StructType\JournalEntryLine
     */
    public function setDebitTax($debitTax = null)
    {
        // validation for constraint: float
        if (!is_null($debitTax) && !(is_float($debitTax) || is_numeric($debitTax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($debitTax, true), gettype($debitTax)), __LINE__);
        }
        $this->debitTax = $debitTax;
        return $this;
    }
    /**
     * Get creditTax value
     * @return float|null
     */
    public function getCreditTax()
    {
        return $this->creditTax;
    }
    /**
     * Set creditTax value
     * @param float $creditTax
     * @return \StructType\JournalEntryLine
     */
    public function setCreditTax($creditTax = null)
    {
        // validation for constraint: float
        if (!is_null($creditTax) && !(is_float($creditTax) || is_numeric($creditTax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($creditTax, true), gettype($creditTax)), __LINE__);
        }
        $this->creditTax = $creditTax;
        return $this;
    }
    /**
     * Get taxBasis value
     * @return float|null
     */
    public function getTaxBasis()
    {
        return $this->taxBasis;
    }
    /**
     * Set taxBasis value
     * @param float $taxBasis
     * @return \StructType\JournalEntryLine
     */
    public function setTaxBasis($taxBasis = null)
    {
        // validation for constraint: float
        if (!is_null($taxBasis) && !(is_float($taxBasis) || is_numeric($taxBasis))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxBasis, true), gettype($taxBasis)), __LINE__);
        }
        $this->taxBasis = $taxBasis;
        return $this;
    }
    /**
     * Get totalAmount value
     * @return float|null
     */
    public function getTotalAmount()
    {
        return $this->totalAmount;
    }
    /**
     * Set totalAmount value
     * @param float $totalAmount
     * @return \StructType\JournalEntryLine
     */
    public function setTotalAmount($totalAmount = null)
    {
        // validation for constraint: float
        if (!is_null($totalAmount) && !(is_float($totalAmount) || is_numeric($totalAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalAmount, true), gettype($totalAmount)), __LINE__);
        }
        $this->totalAmount = $totalAmount;
        return $this;
    }
    /**
     * Get taxCode value
     * @return \StructType\RecordRef|null
     */
    public function getTaxCode()
    {
        return $this->taxCode;
    }
    /**
     * Set taxCode value
     * @param \StructType\RecordRef $taxCode
     * @return \StructType\JournalEntryLine
     */
    public function setTaxCode(\StructType\RecordRef $taxCode = null)
    {
        $this->taxCode = $taxCode;
        return $this;
    }
    /**
     * Get memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->memo;
    }
    /**
     * Set memo value
     * @param string $memo
     * @return \StructType\JournalEntryLine
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->memo = $memo;
        return $this;
    }
    /**
     * Get taxRate1 value
     * @return float|null
     */
    public function getTaxRate1()
    {
        return $this->taxRate1;
    }
    /**
     * Set taxRate1 value
     * @param float $taxRate1
     * @return \StructType\JournalEntryLine
     */
    public function setTaxRate1($taxRate1 = null)
    {
        // validation for constraint: float
        if (!is_null($taxRate1) && !(is_float($taxRate1) || is_numeric($taxRate1))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxRate1, true), gettype($taxRate1)), __LINE__);
        }
        $this->taxRate1 = $taxRate1;
        return $this;
    }
    /**
     * Get entity value
     * @return \StructType\RecordRef|null
     */
    public function getEntity()
    {
        return $this->entity;
    }
    /**
     * Set entity value
     * @param \StructType\RecordRef $entity
     * @return \StructType\JournalEntryLine
     */
    public function setEntity(\StructType\RecordRef $entity = null)
    {
        $this->entity = $entity;
        return $this;
    }
    /**
     * Get grossAmt value
     * @return float|null
     */
    public function getGrossAmt()
    {
        return $this->grossAmt;
    }
    /**
     * Set grossAmt value
     * @param float $grossAmt
     * @return \StructType\JournalEntryLine
     */
    public function setGrossAmt($grossAmt = null)
    {
        // validation for constraint: float
        if (!is_null($grossAmt) && !(is_float($grossAmt) || is_numeric($grossAmt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($grossAmt, true), gettype($grossAmt)), __LINE__);
        }
        $this->grossAmt = $grossAmt;
        return $this;
    }
    /**
     * Get department value
     * @return \StructType\RecordRef|null
     */
    public function getDepartment()
    {
        return $this->department;
    }
    /**
     * Set department value
     * @param \StructType\RecordRef $department
     * @return \StructType\JournalEntryLine
     */
    public function setDepartment(\StructType\RecordRef $department = null)
    {
        $this->department = $department;
        return $this;
    }
    /**
     * Get class value
     * @return \StructType\RecordRef|null
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @param \StructType\RecordRef $class
     * @return \StructType\JournalEntryLine
     */
    public function setClass(\StructType\RecordRef $class = null)
    {
        $this->class = $class;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\RecordRef|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\RecordRef $location
     * @return \StructType\JournalEntryLine
     */
    public function setLocation(\StructType\RecordRef $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get revenueRecognitionRule value
     * @return \StructType\RecordRef|null
     */
    public function getRevenueRecognitionRule()
    {
        return $this->revenueRecognitionRule;
    }
    /**
     * Set revenueRecognitionRule value
     * @param \StructType\RecordRef $revenueRecognitionRule
     * @return \StructType\JournalEntryLine
     */
    public function setRevenueRecognitionRule(\StructType\RecordRef $revenueRecognitionRule = null)
    {
        $this->revenueRecognitionRule = $revenueRecognitionRule;
        return $this;
    }
    /**
     * Get eliminate value
     * @return bool|null
     */
    public function getEliminate()
    {
        return $this->eliminate;
    }
    /**
     * Set eliminate value
     * @param bool $eliminate
     * @return \StructType\JournalEntryLine
     */
    public function setEliminate($eliminate = null)
    {
        // validation for constraint: boolean
        if (!is_null($eliminate) && !is_bool($eliminate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($eliminate, true), gettype($eliminate)), __LINE__);
        }
        $this->eliminate = $eliminate;
        return $this;
    }
    /**
     * Get schedule value
     * @return \StructType\RecordRef|null
     */
    public function getSchedule()
    {
        return $this->schedule;
    }
    /**
     * Set schedule value
     * @param \StructType\RecordRef $schedule
     * @return \StructType\JournalEntryLine
     */
    public function setSchedule(\StructType\RecordRef $schedule = null)
    {
        $this->schedule = $schedule;
        return $this;
    }
    /**
     * Get startDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \StructType\JournalEntryLine
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \StructType\JournalEntryLine
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Get residual value
     * @return string|null
     */
    public function getResidual()
    {
        return $this->residual;
    }
    /**
     * Set residual value
     * @param string $residual
     * @return \StructType\JournalEntryLine
     */
    public function setResidual($residual = null)
    {
        // validation for constraint: string
        if (!is_null($residual) && !is_string($residual)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($residual, true), gettype($residual)), __LINE__);
        }
        $this->residual = $residual;
        return $this;
    }
    /**
     * Get scheduleNum value
     * @return \StructType\RecordRef|null
     */
    public function getScheduleNum()
    {
        return $this->scheduleNum;
    }
    /**
     * Set scheduleNum value
     * @param \StructType\RecordRef $scheduleNum
     * @return \StructType\JournalEntryLine
     */
    public function setScheduleNum(\StructType\RecordRef $scheduleNum = null)
    {
        $this->scheduleNum = $scheduleNum;
        return $this;
    }
    /**
     * Get tax1Amt value
     * @return float|null
     */
    public function getTax1Amt()
    {
        return $this->tax1Amt;
    }
    /**
     * Set tax1Amt value
     * @param float $tax1Amt
     * @return \StructType\JournalEntryLine
     */
    public function setTax1Amt($tax1Amt = null)
    {
        // validation for constraint: float
        if (!is_null($tax1Amt) && !(is_float($tax1Amt) || is_numeric($tax1Amt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tax1Amt, true), gettype($tax1Amt)), __LINE__);
        }
        $this->tax1Amt = $tax1Amt;
        return $this;
    }
    /**
     * Get tax1Acct value
     * @return \StructType\RecordRef|null
     */
    public function getTax1Acct()
    {
        return $this->tax1Acct;
    }
    /**
     * Set tax1Acct value
     * @param \StructType\RecordRef $tax1Acct
     * @return \StructType\JournalEntryLine
     */
    public function setTax1Acct(\StructType\RecordRef $tax1Acct = null)
    {
        $this->tax1Acct = $tax1Acct;
        return $this;
    }
    /**
     * Get customFieldList value
     * @return \StructType\CustomFieldList|null
     */
    public function getCustomFieldList()
    {
        return $this->customFieldList;
    }
    /**
     * Set customFieldList value
     * @param \StructType\CustomFieldList $customFieldList
     * @return \StructType\JournalEntryLine
     */
    public function setCustomFieldList(\StructType\CustomFieldList $customFieldList = null)
    {
        $this->customFieldList = $customFieldList;
        return $this;
    }
}
