<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JobSearchRow StructType
 * @subpackage Structs
 */
class JobSearchRow extends SearchRow
{
    /**
     * The basic
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\JobSearchRowBasic
     */
    public $basic;
    /**
     * The billingAccountJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BillingAccountSearchRowBasic
     */
    public $billingAccountJoin;
    /**
     * The billingScheduleJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BillingScheduleSearchRowBasic
     */
    public $billingScheduleJoin;
    /**
     * The contactPrimaryJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ContactSearchRowBasic
     */
    public $contactPrimaryJoin;
    /**
     * The customerJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomerSearchRowBasic
     */
    public $customerJoin;
    /**
     * The projectManagerJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EmployeeSearchRowBasic
     */
    public $projectManagerJoin;
    /**
     * The projectTaskJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ProjectTaskSearchRowBasic
     */
    public $projectTaskJoin;
    /**
     * The resourceAllocationJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ResourceAllocationSearchRowBasic
     */
    public $resourceAllocationJoin;
    /**
     * The taskJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TaskSearchRowBasic
     */
    public $taskJoin;
    /**
     * The timeJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TimeBillSearchRowBasic
     */
    public $timeJoin;
    /**
     * The customSearchJoin
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomSearchRowBasic[]
     */
    public $customSearchJoin;
    /**
     * Constructor method for JobSearchRow
     * @uses JobSearchRow::setBasic()
     * @uses JobSearchRow::setBillingAccountJoin()
     * @uses JobSearchRow::setBillingScheduleJoin()
     * @uses JobSearchRow::setContactPrimaryJoin()
     * @uses JobSearchRow::setCustomerJoin()
     * @uses JobSearchRow::setProjectManagerJoin()
     * @uses JobSearchRow::setProjectTaskJoin()
     * @uses JobSearchRow::setResourceAllocationJoin()
     * @uses JobSearchRow::setTaskJoin()
     * @uses JobSearchRow::setTimeJoin()
     * @uses JobSearchRow::setCustomSearchJoin()
     * @param \StructType\JobSearchRowBasic $basic
     * @param \StructType\BillingAccountSearchRowBasic $billingAccountJoin
     * @param \StructType\BillingScheduleSearchRowBasic $billingScheduleJoin
     * @param \StructType\ContactSearchRowBasic $contactPrimaryJoin
     * @param \StructType\CustomerSearchRowBasic $customerJoin
     * @param \StructType\EmployeeSearchRowBasic $projectManagerJoin
     * @param \StructType\ProjectTaskSearchRowBasic $projectTaskJoin
     * @param \StructType\ResourceAllocationSearchRowBasic $resourceAllocationJoin
     * @param \StructType\TaskSearchRowBasic $taskJoin
     * @param \StructType\TimeBillSearchRowBasic $timeJoin
     * @param \StructType\CustomSearchRowBasic[] $customSearchJoin
     */
    public function __construct(\StructType\JobSearchRowBasic $basic = null, \StructType\BillingAccountSearchRowBasic $billingAccountJoin = null, \StructType\BillingScheduleSearchRowBasic $billingScheduleJoin = null, \StructType\ContactSearchRowBasic $contactPrimaryJoin = null, \StructType\CustomerSearchRowBasic $customerJoin = null, \StructType\EmployeeSearchRowBasic $projectManagerJoin = null, \StructType\ProjectTaskSearchRowBasic $projectTaskJoin = null, \StructType\ResourceAllocationSearchRowBasic $resourceAllocationJoin = null, \StructType\TaskSearchRowBasic $taskJoin = null, \StructType\TimeBillSearchRowBasic $timeJoin = null, array $customSearchJoin = array())
    {
        $this
            ->setBasic($basic)
            ->setBillingAccountJoin($billingAccountJoin)
            ->setBillingScheduleJoin($billingScheduleJoin)
            ->setContactPrimaryJoin($contactPrimaryJoin)
            ->setCustomerJoin($customerJoin)
            ->setProjectManagerJoin($projectManagerJoin)
            ->setProjectTaskJoin($projectTaskJoin)
            ->setResourceAllocationJoin($resourceAllocationJoin)
            ->setTaskJoin($taskJoin)
            ->setTimeJoin($timeJoin)
            ->setCustomSearchJoin($customSearchJoin);
    }
    /**
     * Get basic value
     * @return \StructType\JobSearchRowBasic|null
     */
    public function getBasic()
    {
        return $this->basic;
    }
    /**
     * Set basic value
     * @param \StructType\JobSearchRowBasic $basic
     * @return \StructType\JobSearchRow
     */
    public function setBasic(\StructType\JobSearchRowBasic $basic = null)
    {
        $this->basic = $basic;
        return $this;
    }
    /**
     * Get billingAccountJoin value
     * @return \StructType\BillingAccountSearchRowBasic|null
     */
    public function getBillingAccountJoin()
    {
        return $this->billingAccountJoin;
    }
    /**
     * Set billingAccountJoin value
     * @param \StructType\BillingAccountSearchRowBasic $billingAccountJoin
     * @return \StructType\JobSearchRow
     */
    public function setBillingAccountJoin(\StructType\BillingAccountSearchRowBasic $billingAccountJoin = null)
    {
        $this->billingAccountJoin = $billingAccountJoin;
        return $this;
    }
    /**
     * Get billingScheduleJoin value
     * @return \StructType\BillingScheduleSearchRowBasic|null
     */
    public function getBillingScheduleJoin()
    {
        return $this->billingScheduleJoin;
    }
    /**
     * Set billingScheduleJoin value
     * @param \StructType\BillingScheduleSearchRowBasic $billingScheduleJoin
     * @return \StructType\JobSearchRow
     */
    public function setBillingScheduleJoin(\StructType\BillingScheduleSearchRowBasic $billingScheduleJoin = null)
    {
        $this->billingScheduleJoin = $billingScheduleJoin;
        return $this;
    }
    /**
     * Get contactPrimaryJoin value
     * @return \StructType\ContactSearchRowBasic|null
     */
    public function getContactPrimaryJoin()
    {
        return $this->contactPrimaryJoin;
    }
    /**
     * Set contactPrimaryJoin value
     * @param \StructType\ContactSearchRowBasic $contactPrimaryJoin
     * @return \StructType\JobSearchRow
     */
    public function setContactPrimaryJoin(\StructType\ContactSearchRowBasic $contactPrimaryJoin = null)
    {
        $this->contactPrimaryJoin = $contactPrimaryJoin;
        return $this;
    }
    /**
     * Get customerJoin value
     * @return \StructType\CustomerSearchRowBasic|null
     */
    public function getCustomerJoin()
    {
        return $this->customerJoin;
    }
    /**
     * Set customerJoin value
     * @param \StructType\CustomerSearchRowBasic $customerJoin
     * @return \StructType\JobSearchRow
     */
    public function setCustomerJoin(\StructType\CustomerSearchRowBasic $customerJoin = null)
    {
        $this->customerJoin = $customerJoin;
        return $this;
    }
    /**
     * Get projectManagerJoin value
     * @return \StructType\EmployeeSearchRowBasic|null
     */
    public function getProjectManagerJoin()
    {
        return $this->projectManagerJoin;
    }
    /**
     * Set projectManagerJoin value
     * @param \StructType\EmployeeSearchRowBasic $projectManagerJoin
     * @return \StructType\JobSearchRow
     */
    public function setProjectManagerJoin(\StructType\EmployeeSearchRowBasic $projectManagerJoin = null)
    {
        $this->projectManagerJoin = $projectManagerJoin;
        return $this;
    }
    /**
     * Get projectTaskJoin value
     * @return \StructType\ProjectTaskSearchRowBasic|null
     */
    public function getProjectTaskJoin()
    {
        return $this->projectTaskJoin;
    }
    /**
     * Set projectTaskJoin value
     * @param \StructType\ProjectTaskSearchRowBasic $projectTaskJoin
     * @return \StructType\JobSearchRow
     */
    public function setProjectTaskJoin(\StructType\ProjectTaskSearchRowBasic $projectTaskJoin = null)
    {
        $this->projectTaskJoin = $projectTaskJoin;
        return $this;
    }
    /**
     * Get resourceAllocationJoin value
     * @return \StructType\ResourceAllocationSearchRowBasic|null
     */
    public function getResourceAllocationJoin()
    {
        return $this->resourceAllocationJoin;
    }
    /**
     * Set resourceAllocationJoin value
     * @param \StructType\ResourceAllocationSearchRowBasic $resourceAllocationJoin
     * @return \StructType\JobSearchRow
     */
    public function setResourceAllocationJoin(\StructType\ResourceAllocationSearchRowBasic $resourceAllocationJoin = null)
    {
        $this->resourceAllocationJoin = $resourceAllocationJoin;
        return $this;
    }
    /**
     * Get taskJoin value
     * @return \StructType\TaskSearchRowBasic|null
     */
    public function getTaskJoin()
    {
        return $this->taskJoin;
    }
    /**
     * Set taskJoin value
     * @param \StructType\TaskSearchRowBasic $taskJoin
     * @return \StructType\JobSearchRow
     */
    public function setTaskJoin(\StructType\TaskSearchRowBasic $taskJoin = null)
    {
        $this->taskJoin = $taskJoin;
        return $this;
    }
    /**
     * Get timeJoin value
     * @return \StructType\TimeBillSearchRowBasic|null
     */
    public function getTimeJoin()
    {
        return $this->timeJoin;
    }
    /**
     * Set timeJoin value
     * @param \StructType\TimeBillSearchRowBasic $timeJoin
     * @return \StructType\JobSearchRow
     */
    public function setTimeJoin(\StructType\TimeBillSearchRowBasic $timeJoin = null)
    {
        $this->timeJoin = $timeJoin;
        return $this;
    }
    /**
     * Get customSearchJoin value
     * @return \StructType\CustomSearchRowBasic[]|null
     */
    public function getCustomSearchJoin()
    {
        return $this->customSearchJoin;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomSearchJoin method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomSearchJoin method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomSearchJoinForArrayConstraintsFromSetCustomSearchJoin(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $jobSearchRowCustomSearchJoinItem) {
            // validation for constraint: itemType
            if (!$jobSearchRowCustomSearchJoinItem instanceof \StructType\CustomSearchRowBasic) {
                $invalidValues[] = is_object($jobSearchRowCustomSearchJoinItem) ? get_class($jobSearchRowCustomSearchJoinItem) : sprintf('%s(%s)', gettype($jobSearchRowCustomSearchJoinItem), var_export($jobSearchRowCustomSearchJoinItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The customSearchJoin property can only contain items of type \StructType\CustomSearchRowBasic, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set customSearchJoin value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomSearchRowBasic[] $customSearchJoin
     * @return \StructType\JobSearchRow
     */
    public function setCustomSearchJoin(array $customSearchJoin = array())
    {
        // validation for constraint: array
        if ('' !== ($customSearchJoinArrayErrorMessage = self::validateCustomSearchJoinForArrayConstraintsFromSetCustomSearchJoin($customSearchJoin))) {
            throw new \InvalidArgumentException($customSearchJoinArrayErrorMessage, __LINE__);
        }
        $this->customSearchJoin = $customSearchJoin;
        return $this;
    }
    /**
     * Add item to customSearchJoin value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomSearchRowBasic $item
     * @return \StructType\JobSearchRow
     */
    public function addToCustomSearchJoin(\StructType\CustomSearchRowBasic $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomSearchRowBasic) {
            throw new \InvalidArgumentException(sprintf('The customSearchJoin property can only contain items of type \StructType\CustomSearchRowBasic, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->customSearchJoin[] = $item;
        return $this;
    }
}
