<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JobResources StructType
 * @subpackage Structs
 */
class JobResources extends AbstractStructBase
{
    /**
     * The jobResource
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $jobResource;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $email;
    /**
     * The role
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RecordRef
     */
    public $role;
    /**
     * Constructor method for JobResources
     * @uses JobResources::setJobResource()
     * @uses JobResources::setEmail()
     * @uses JobResources::setRole()
     * @param \StructType\RecordRef $jobResource
     * @param string $email
     * @param \StructType\RecordRef $role
     */
    public function __construct(\StructType\RecordRef $jobResource = null, $email = null, \StructType\RecordRef $role = null)
    {
        $this
            ->setJobResource($jobResource)
            ->setEmail($email)
            ->setRole($role);
    }
    /**
     * Get jobResource value
     * @return \StructType\RecordRef|null
     */
    public function getJobResource()
    {
        return $this->jobResource;
    }
    /**
     * Set jobResource value
     * @param \StructType\RecordRef $jobResource
     * @return \StructType\JobResources
     */
    public function setJobResource(\StructType\RecordRef $jobResource = null)
    {
        $this->jobResource = $jobResource;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\JobResources
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get role value
     * @return \StructType\RecordRef|null
     */
    public function getRole()
    {
        return $this->role;
    }
    /**
     * Set role value
     * @param \StructType\RecordRef $role
     * @return \StructType\JobResources
     */
    public function setRole(\StructType\RecordRef $role = null)
    {
        $this->role = $role;
        return $this;
    }
}
