<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JobPlStatementList StructType
 * @subpackage Structs
 */
class JobPlStatementList extends AbstractStructBase
{
    /**
     * The jobPlStatement
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JobPlStatement[]
     */
    public $jobPlStatement;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for JobPlStatementList
     * @uses JobPlStatementList::setJobPlStatement()
     * @uses JobPlStatementList::setReplaceAll()
     * @param \StructType\JobPlStatement[] $jobPlStatement
     * @param bool $replaceAll
     */
    public function __construct(array $jobPlStatement = array(), $replaceAll = true)
    {
        $this
            ->setJobPlStatement($jobPlStatement)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get jobPlStatement value
     * @return \StructType\JobPlStatement[]|null
     */
    public function getJobPlStatement()
    {
        return $this->jobPlStatement;
    }
    /**
     * This method is responsible for validating the values passed to the setJobPlStatement method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJobPlStatement method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateJobPlStatementForArrayConstraintsFromSetJobPlStatement(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $jobPlStatementListJobPlStatementItem) {
            // validation for constraint: itemType
            if (!$jobPlStatementListJobPlStatementItem instanceof \StructType\JobPlStatement) {
                $invalidValues[] = is_object($jobPlStatementListJobPlStatementItem) ? get_class($jobPlStatementListJobPlStatementItem) : sprintf('%s(%s)', gettype($jobPlStatementListJobPlStatementItem), var_export($jobPlStatementListJobPlStatementItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The jobPlStatement property can only contain items of type \StructType\JobPlStatement, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set jobPlStatement value
     * @throws \InvalidArgumentException
     * @param \StructType\JobPlStatement[] $jobPlStatement
     * @return \StructType\JobPlStatementList
     */
    public function setJobPlStatement(array $jobPlStatement = array())
    {
        // validation for constraint: array
        if ('' !== ($jobPlStatementArrayErrorMessage = self::validateJobPlStatementForArrayConstraintsFromSetJobPlStatement($jobPlStatement))) {
            throw new \InvalidArgumentException($jobPlStatementArrayErrorMessage, __LINE__);
        }
        $this->jobPlStatement = $jobPlStatement;
        return $this;
    }
    /**
     * Add item to jobPlStatement value
     * @throws \InvalidArgumentException
     * @param \StructType\JobPlStatement $item
     * @return \StructType\JobPlStatementList
     */
    public function addToJobPlStatement(\StructType\JobPlStatement $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JobPlStatement) {
            throw new \InvalidArgumentException(sprintf('The jobPlStatement property can only contain items of type \StructType\JobPlStatement, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->jobPlStatement[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\JobPlStatementList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
