<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemSupplyPlanSearch StructType
 * @subpackage Structs
 */
class ItemSupplyPlanSearch extends SearchRecord
{
    /**
     * The basic
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ItemSupplyPlanSearchBasic
     */
    public $basic;
    /**
     * The itemJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ItemSearchBasic
     */
    public $itemJoin;
    /**
     * The locationJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\LocationSearchBasic
     */
    public $locationJoin;
    /**
     * The userJoin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EmployeeSearchBasic
     */
    public $userJoin;
    /**
     * The customSearchJoin
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomSearchJoin[]
     */
    public $customSearchJoin;
    /**
     * Constructor method for ItemSupplyPlanSearch
     * @uses ItemSupplyPlanSearch::setBasic()
     * @uses ItemSupplyPlanSearch::setItemJoin()
     * @uses ItemSupplyPlanSearch::setLocationJoin()
     * @uses ItemSupplyPlanSearch::setUserJoin()
     * @uses ItemSupplyPlanSearch::setCustomSearchJoin()
     * @param \StructType\ItemSupplyPlanSearchBasic $basic
     * @param \StructType\ItemSearchBasic $itemJoin
     * @param \StructType\LocationSearchBasic $locationJoin
     * @param \StructType\EmployeeSearchBasic $userJoin
     * @param \StructType\CustomSearchJoin[] $customSearchJoin
     */
    public function __construct(\StructType\ItemSupplyPlanSearchBasic $basic = null, \StructType\ItemSearchBasic $itemJoin = null, \StructType\LocationSearchBasic $locationJoin = null, \StructType\EmployeeSearchBasic $userJoin = null, array $customSearchJoin = array())
    {
        $this
            ->setBasic($basic)
            ->setItemJoin($itemJoin)
            ->setLocationJoin($locationJoin)
            ->setUserJoin($userJoin)
            ->setCustomSearchJoin($customSearchJoin);
    }
    /**
     * Get basic value
     * @return \StructType\ItemSupplyPlanSearchBasic|null
     */
    public function getBasic()
    {
        return $this->basic;
    }
    /**
     * Set basic value
     * @param \StructType\ItemSupplyPlanSearchBasic $basic
     * @return \StructType\ItemSupplyPlanSearch
     */
    public function setBasic(\StructType\ItemSupplyPlanSearchBasic $basic = null)
    {
        $this->basic = $basic;
        return $this;
    }
    /**
     * Get itemJoin value
     * @return \StructType\ItemSearchBasic|null
     */
    public function getItemJoin()
    {
        return $this->itemJoin;
    }
    /**
     * Set itemJoin value
     * @param \StructType\ItemSearchBasic $itemJoin
     * @return \StructType\ItemSupplyPlanSearch
     */
    public function setItemJoin(\StructType\ItemSearchBasic $itemJoin = null)
    {
        $this->itemJoin = $itemJoin;
        return $this;
    }
    /**
     * Get locationJoin value
     * @return \StructType\LocationSearchBasic|null
     */
    public function getLocationJoin()
    {
        return $this->locationJoin;
    }
    /**
     * Set locationJoin value
     * @param \StructType\LocationSearchBasic $locationJoin
     * @return \StructType\ItemSupplyPlanSearch
     */
    public function setLocationJoin(\StructType\LocationSearchBasic $locationJoin = null)
    {
        $this->locationJoin = $locationJoin;
        return $this;
    }
    /**
     * Get userJoin value
     * @return \StructType\EmployeeSearchBasic|null
     */
    public function getUserJoin()
    {
        return $this->userJoin;
    }
    /**
     * Set userJoin value
     * @param \StructType\EmployeeSearchBasic $userJoin
     * @return \StructType\ItemSupplyPlanSearch
     */
    public function setUserJoin(\StructType\EmployeeSearchBasic $userJoin = null)
    {
        $this->userJoin = $userJoin;
        return $this;
    }
    /**
     * Get customSearchJoin value
     * @return \StructType\CustomSearchJoin[]|null
     */
    public function getCustomSearchJoin()
    {
        return $this->customSearchJoin;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomSearchJoin method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomSearchJoin method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomSearchJoinForArrayConstraintsFromSetCustomSearchJoin(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemSupplyPlanSearchCustomSearchJoinItem) {
            // validation for constraint: itemType
            if (!$itemSupplyPlanSearchCustomSearchJoinItem instanceof \StructType\CustomSearchJoin) {
                $invalidValues[] = is_object($itemSupplyPlanSearchCustomSearchJoinItem) ? get_class($itemSupplyPlanSearchCustomSearchJoinItem) : sprintf('%s(%s)', gettype($itemSupplyPlanSearchCustomSearchJoinItem), var_export($itemSupplyPlanSearchCustomSearchJoinItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The customSearchJoin property can only contain items of type \StructType\CustomSearchJoin, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set customSearchJoin value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomSearchJoin[] $customSearchJoin
     * @return \StructType\ItemSupplyPlanSearch
     */
    public function setCustomSearchJoin(array $customSearchJoin = array())
    {
        // validation for constraint: array
        if ('' !== ($customSearchJoinArrayErrorMessage = self::validateCustomSearchJoinForArrayConstraintsFromSetCustomSearchJoin($customSearchJoin))) {
            throw new \InvalidArgumentException($customSearchJoinArrayErrorMessage, __LINE__);
        }
        $this->customSearchJoin = $customSearchJoin;
        return $this;
    }
    /**
     * Add item to customSearchJoin value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomSearchJoin $item
     * @return \StructType\ItemSupplyPlanSearch
     */
    public function addToCustomSearchJoin(\StructType\CustomSearchJoin $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomSearchJoin) {
            throw new \InvalidArgumentException(sprintf('The customSearchJoin property can only contain items of type \StructType\CustomSearchJoin, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->customSearchJoin[] = $item;
        return $this;
    }
}
