<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemMemberList StructType
 * @subpackage Structs
 */
class ItemMemberList extends AbstractStructBase
{
    /**
     * The itemMember
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ItemMember[]
     */
    public $itemMember;
    /**
     * The replaceAll
     * Meta information extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $replaceAll;
    /**
     * Constructor method for ItemMemberList
     * @uses ItemMemberList::setItemMember()
     * @uses ItemMemberList::setReplaceAll()
     * @param \StructType\ItemMember[] $itemMember
     * @param bool $replaceAll
     */
    public function __construct(array $itemMember = array(), $replaceAll = true)
    {
        $this
            ->setItemMember($itemMember)
            ->setReplaceAll($replaceAll);
    }
    /**
     * Get itemMember value
     * @return \StructType\ItemMember[]|null
     */
    public function getItemMember()
    {
        return $this->itemMember;
    }
    /**
     * This method is responsible for validating the values passed to the setItemMember method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItemMember method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemMemberForArrayConstraintsFromSetItemMember(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $itemMemberListItemMemberItem) {
            // validation for constraint: itemType
            if (!$itemMemberListItemMemberItem instanceof \StructType\ItemMember) {
                $invalidValues[] = is_object($itemMemberListItemMemberItem) ? get_class($itemMemberListItemMemberItem) : sprintf('%s(%s)', gettype($itemMemberListItemMemberItem), var_export($itemMemberListItemMemberItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The itemMember property can only contain items of type \StructType\ItemMember, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set itemMember value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemMember[] $itemMember
     * @return \StructType\ItemMemberList
     */
    public function setItemMember(array $itemMember = array())
    {
        // validation for constraint: array
        if ('' !== ($itemMemberArrayErrorMessage = self::validateItemMemberForArrayConstraintsFromSetItemMember($itemMember))) {
            throw new \InvalidArgumentException($itemMemberArrayErrorMessage, __LINE__);
        }
        $this->itemMember = $itemMember;
        return $this;
    }
    /**
     * Add item to itemMember value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemMember $item
     * @return \StructType\ItemMemberList
     */
    public function addToItemMember(\StructType\ItemMember $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ItemMember) {
            throw new \InvalidArgumentException(sprintf('The itemMember property can only contain items of type \StructType\ItemMember, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->itemMember[] = $item;
        return $this;
    }
    /**
     * Get replaceAll value
     * @return bool|null
     */
    public function getReplaceAll()
    {
        return $this->replaceAll;
    }
    /**
     * Set replaceAll value
     * @param bool $replaceAll
     * @return \StructType\ItemMemberList
     */
    public function setReplaceAll($replaceAll = true)
    {
        // validation for constraint: boolean
        if (!is_null($replaceAll) && !is_bool($replaceAll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($replaceAll, true), gettype($replaceAll)), __LINE__);
        }
        $this->replaceAll = $replaceAll;
        return $this;
    }
}
